/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.security;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.mortbay.io.Buffer;
import org.mortbay.io.Buffers;
import org.mortbay.io.nio.NIOBuffer;
import org.mortbay.io.nio.SelectorManager;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.log.Log;

public class SslHttpChannelEndPoint
extends SelectChannelConnector.ConnectorEndPoint
implements Runnable {
    private static final ByteBuffer[] __NO_BUFFERS = new ByteBuffer[0];
    private static final ByteBuffer __EMPTY = ByteBuffer.allocate(0);
    private Buffers _buffers;
    private SSLEngine _engine;
    private ByteBuffer _inBuffer;
    private NIOBuffer _inNIOBuffer;
    private ByteBuffer _outBuffer;
    private NIOBuffer _outNIOBuffer;
    private NIOBuffer[] _reuseBuffer = new NIOBuffer[2];
    private ByteBuffer[] _gather = new ByteBuffer[2];
    protected SSLSession _session;

    public SslHttpChannelEndPoint(Buffers buffers, SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey key, SSLEngine engine) throws SSLException, IOException {
        super(channel, selectSet, key);
        this._buffers = buffers;
        this._engine = engine;
        this._engine.setUseClientMode(false);
        this._session = engine.getSession();
        this._outNIOBuffer = (NIOBuffer)buffers.getBuffer(this._session.getPacketBufferSize());
        this._outBuffer = this._outNIOBuffer.getByteBuffer();
        this._inNIOBuffer = (NIOBuffer)buffers.getBuffer(this._session.getPacketBufferSize());
        this._inBuffer = this._inNIOBuffer.getByteBuffer();
    }

    protected void idleExpired() {
        try {
            this._selectSet.getManager().dispatch(new Runnable(){

                public void run() {
                    try {
                        SslHttpChannelEndPoint.this.close();
                    }
                    catch (Exception e) {
                        Log.ignore((Throwable)e);
                    }
                }
            });
        }
        catch (Exception e) {
            Log.ignore((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws IOException {
        this._engine.closeOutbound();
        try {
            try {
                int tries = 0;
                block14: while (this.isOpen() && !this._engine.isOutboundDone() && tries++ < 100) {
                    if (this._outNIOBuffer.length() > 0) {
                        this.flush();
                        Thread.sleep(100L);
                    }
                    switch (this._engine.getHandshakeStatus()) {
                        case FINISHED: 
                        case NOT_HANDSHAKING: {
                            break block14;
                        }
                        case NEED_UNWRAP: {
                            if (this.fill(__EMPTY)) break;
                            Thread.sleep(100L);
                            continue block14;
                        }
                        case NEED_TASK: {
                            Runnable task;
                            while ((task = this._engine.getDelegatedTask()) != null) {
                                task.run();
                            }
                            break;
                        }
                        case NEED_WRAP: {
                            if (this._outNIOBuffer.length() > 0) {
                                this.flush();
                            }
                            SSLEngineResult result = null;
                            try {
                                this._outNIOBuffer.compact();
                                int put = this._outNIOBuffer.putIndex();
                                this._outBuffer.position(put);
                                result = this._engine.wrap(__NO_BUFFERS, this._outBuffer);
                                this._outNIOBuffer.setPutIndex(put + result.bytesProduced());
                            }
                            finally {
                                this._outBuffer.position(0);
                            }
                            this.flush();
                            continue block14;
                        }
                    }
                }
                Object var6_7 = null;
            }
            catch (IOException e) {
                Log.ignore((Throwable)e);
                Object var6_8 = null;
                super.close();
                if (this._inNIOBuffer != null) {
                    this._buffers.returnBuffer((Buffer)this._inNIOBuffer);
                }
                if (this._outNIOBuffer != null) {
                    this._buffers.returnBuffer((Buffer)this._outNIOBuffer);
                }
                if (this._reuseBuffer[0] != null) {
                    this._buffers.returnBuffer((Buffer)this._reuseBuffer[0]);
                }
                if (this._reuseBuffer[1] == null) return;
                this._buffers.returnBuffer((Buffer)this._reuseBuffer[1]);
                return;
            }
            catch (InterruptedException e) {
                Log.ignore((Throwable)e);
                Object var6_9 = null;
                super.close();
                if (this._inNIOBuffer != null) {
                    this._buffers.returnBuffer((Buffer)this._inNIOBuffer);
                }
                if (this._outNIOBuffer != null) {
                    this._buffers.returnBuffer((Buffer)this._outNIOBuffer);
                }
                if (this._reuseBuffer[0] != null) {
                    this._buffers.returnBuffer((Buffer)this._reuseBuffer[0]);
                }
                if (this._reuseBuffer[1] == null) return;
                this._buffers.returnBuffer((Buffer)this._reuseBuffer[1]);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            super.close();
            if (this._inNIOBuffer != null) {
                this._buffers.returnBuffer((Buffer)this._inNIOBuffer);
            }
            if (this._outNIOBuffer != null) {
                this._buffers.returnBuffer((Buffer)this._outNIOBuffer);
            }
            if (this._reuseBuffer[0] != null) {
                this._buffers.returnBuffer((Buffer)this._reuseBuffer[0]);
            }
            if (this._reuseBuffer[1] == null) throw throwable;
            this._buffers.returnBuffer((Buffer)this._reuseBuffer[1]);
            throw throwable;
        }
        super.close();
        if (this._inNIOBuffer != null) {
            this._buffers.returnBuffer((Buffer)this._inNIOBuffer);
        }
        if (this._outNIOBuffer != null) {
            this._buffers.returnBuffer((Buffer)this._outNIOBuffer);
        }
        if (this._reuseBuffer[0] != null) {
            this._buffers.returnBuffer((Buffer)this._reuseBuffer[0]);
        }
        if (this._reuseBuffer[1] == null) return;
        this._buffers.returnBuffer((Buffer)this._reuseBuffer[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int fill(Buffer buffer) throws IOException {
        Buffer buffer2 = buffer;
        // MONITORENTER : buffer2
        ByteBuffer bbuf = this.extractInputBuffer(buffer);
        int size = buffer.length();
        try {
            this.fill(bbuf);
            while (this._inBuffer.remaining() > 0) {
                if (this._outNIOBuffer.length() > 0) {
                    this.flush();
                }
                switch (this._engine.getHandshakeStatus()) {
                    case FINISHED: 
                    case NOT_HANDSHAKING: {
                        return buffer.length() - size;
                    }
                    case NEED_UNWRAP: {
                        if (this.fill(bbuf)) break;
                        return buffer.length() - size;
                    }
                    case NEED_TASK: {
                        Runnable task;
                        while ((task = this._engine.getDelegatedTask()) != null) {
                            task.run();
                        }
                        break;
                    }
                    case NEED_WRAP: {
                        SSLEngineResult result = null;
                        ByteBuffer byteBuffer = this._outBuffer;
                        // MONITORENTER : byteBuffer
                        try {
                            this._outNIOBuffer.compact();
                            int put = this._outNIOBuffer.putIndex();
                            this._outBuffer.position();
                            result = this._engine.wrap(__NO_BUFFERS, this._outBuffer);
                            this._outNIOBuffer.setPutIndex(put + result.bytesProduced());
                        }
                        finally {
                            this._outBuffer.position(0);
                        }
                        this.flush();
                    }
                }
            }
            return buffer.length() - size;
        }
        catch (SSLException e) {
            Log.warn((Throwable)e);
            return buffer.length() - size;
        }
        finally {
            buffer.setPutIndex(bbuf.position());
            bbuf.position(0);
        }
    }

    public int flush(Buffer buffer) throws IOException {
        return this.flush(buffer, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int flush(Buffer header, Buffer buffer, Buffer trailer) throws IOException {
        SSLEngineResult result;
        block31: {
            if (this._outNIOBuffer.length() > 0) {
                this.flush();
                if (this._outNIOBuffer.length() > 0) {
                    return 0;
                }
            }
            result = null;
            if (header == null || buffer == null) break block31;
            this._gather[0] = this.extractOutputBuffer(header, 0);
            ByteBuffer byteBuffer = this._gather[0];
            synchronized (byteBuffer) {
                this._gather[0].position(header.getIndex());
                this._gather[0].limit(header.putIndex());
                this._gather[1] = this.extractOutputBuffer(buffer, 1);
                ByteBuffer byteBuffer2 = this._gather[1];
                synchronized (byteBuffer2) {
                    this._gather[1].position(buffer.getIndex());
                    this._gather[1].limit(buffer.putIndex());
                    ByteBuffer byteBuffer3 = this._outBuffer;
                    synchronized (byteBuffer3) {
                        int len2;
                        int consumed = 0;
                        try {
                            this._outNIOBuffer.clear();
                            this._outBuffer.position(0);
                            this._outBuffer.limit(this._outBuffer.capacity());
                            result = this._engine.wrap(this._gather, this._outBuffer);
                            this._outNIOBuffer.setGetIndex(0);
                            this._outNIOBuffer.setPutIndex(result.bytesProduced());
                            consumed = result.bytesConsumed();
                            Object var10_12 = null;
                            this._outBuffer.position(0);
                        }
                        catch (Throwable throwable) {
                            int len2;
                            Object var10_13 = null;
                            this._outBuffer.position(0);
                            if (consumed > 0 && header != null) {
                                len2 = consumed < header.length() ? consumed : header.length();
                                header.skip(len2);
                                consumed -= len2;
                                this._gather[0].position(0);
                                this._gather[0].limit(this._gather[0].capacity());
                            }
                            if (consumed > 0 && buffer != null) {
                                len2 = consumed < buffer.length() ? consumed : buffer.length();
                                buffer.skip(len2);
                                consumed -= len2;
                                this._gather[1].position(0);
                                this._gather[1].limit(this._gather[1].capacity());
                            }
                            assert (consumed == 0);
                            throw throwable;
                        }
                        if (consumed > 0 && header != null) {
                            len2 = consumed < header.length() ? consumed : header.length();
                            header.skip(len2);
                            consumed -= len2;
                            this._gather[0].position(0);
                            this._gather[0].limit(this._gather[0].capacity());
                        }
                        if (consumed > 0 && buffer != null) {
                            len2 = consumed < buffer.length() ? consumed : buffer.length();
                            buffer.skip(len2);
                            consumed -= len2;
                            this._gather[1].position(0);
                            this._gather[1].limit(this._gather[1].capacity());
                        }
                        assert (consumed == 0);
                    }
                }
            }
        }
        this._gather[0] = this.extractOutputBuffer(header, 0);
        ByteBuffer byteBuffer = this._gather[0];
        synchronized (byteBuffer) {
            this._gather[0].position(header.getIndex());
            this._gather[0].limit(header.putIndex());
            int consumed = 0;
            ByteBuffer byteBuffer4 = this._outBuffer;
            synchronized (byteBuffer4) {
                try {
                    this._outNIOBuffer.clear();
                    this._outBuffer.position(0);
                    this._outBuffer.limit(this._outBuffer.capacity());
                    result = this._engine.wrap(this._gather[0], this._outBuffer);
                    this._outNIOBuffer.setGetIndex(0);
                    this._outNIOBuffer.setPutIndex(result.bytesProduced());
                    consumed = result.bytesConsumed();
                    Object var16_20 = null;
                    this._outBuffer.position(0);
                }
                catch (Throwable throwable) {
                    Object var16_21 = null;
                    this._outBuffer.position(0);
                    if (consumed > 0 && header != null) {
                        int len = consumed < header.length() ? consumed : header.length();
                        header.skip(len);
                        consumed -= len;
                        this._gather[0].position(0);
                        this._gather[0].limit(this._gather[0].capacity());
                    }
                    assert (consumed == 0);
                    throw throwable;
                }
                if (consumed > 0 && header != null) {
                    int len = consumed < header.length() ? consumed : header.length();
                    header.skip(len);
                    consumed -= len;
                    this._gather[0].position(0);
                    this._gather[0].limit(this._gather[0].capacity());
                }
                assert (consumed == 0);
            }
        }
        this.flush();
        return result.bytesConsumed();
    }

    public void flush() throws IOException {
        while (this._outNIOBuffer.length() > 0) {
            int flushed = super.flush((Buffer)this._outNIOBuffer);
            if (flushed != 0) continue;
            Thread.yield();
            flushed = super.flush((Buffer)this._outNIOBuffer);
            if (flushed != 0) continue;
            return;
        }
    }

    private ByteBuffer extractInputBuffer(Buffer buffer) {
        assert (buffer instanceof NIOBuffer);
        NIOBuffer nbuf = (NIOBuffer)buffer;
        ByteBuffer bbuf = nbuf.getByteBuffer();
        bbuf.position(buffer.putIndex());
        return bbuf;
    }

    private ByteBuffer extractOutputBuffer(Buffer buffer, int n) {
        Object src = null;
        NIOBuffer nBuf = null;
        if (buffer.buffer() instanceof NIOBuffer) {
            nBuf = (NIOBuffer)buffer.buffer();
            return nBuf.getByteBuffer();
        }
        if (this._reuseBuffer[n] == null) {
            this._reuseBuffer[n] = (NIOBuffer)this._buffers.getBuffer(this._session.getApplicationBufferSize());
        }
        NIOBuffer buf = this._reuseBuffer[n];
        buf.clear();
        buf.put(buffer);
        return buf.getByteBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fill(ByteBuffer buffer) throws IOException {
        SSLEngineResult result;
        int in_len = 0;
        if (this._inNIOBuffer.hasContent()) {
            this._inNIOBuffer.compact();
        } else {
            this._inNIOBuffer.clear();
        }
        while (this._inNIOBuffer.space() > 0) {
            int len = super.fill((Buffer)this._inNIOBuffer);
            if (len <= 0) {
                if (len < 0) {
                    this._engine.closeInbound();
                }
                if (len == 0 || in_len > 0) break;
                return false;
            }
            in_len += len;
        }
        if (this._inNIOBuffer.length() == 0) {
            return false;
        }
        try {
            this._inBuffer.position(this._inNIOBuffer.getIndex());
            this._inBuffer.limit(this._inNIOBuffer.putIndex());
            result = this._engine.unwrap(this._inBuffer, buffer);
            this._inNIOBuffer.skip(result.bytesConsumed());
        }
        finally {
            this._inBuffer.position(0);
            this._inBuffer.limit(this._inBuffer.capacity());
        }
        if (result != null) {
            switch (result.getStatus()) {
                case OK: {
                    break;
                }
                case CLOSED: {
                    throw new IOException("sslEngine closed");
                }
                case BUFFER_OVERFLOW: {
                    Log.debug((String)"unwrap {}", (Object)result);
                    break;
                }
                case BUFFER_UNDERFLOW: {
                    Log.debug((String)"unwrap {}", (Object)result);
                    break;
                }
                default: {
                    Log.warn((String)("unwrap " + result));
                    throw new IOException(result.toString());
                }
            }
        }
        return result.bytesProduced() + result.bytesConsumed() > 0;
    }

    public boolean isBufferingInput() {
        return this._inNIOBuffer.hasContent();
    }

    public boolean isBufferingOutput() {
        return this._outNIOBuffer.hasContent();
    }

    public boolean isBufferred() {
        return true;
    }

    public SSLEngine getSSLEngine() {
        return this._engine;
    }
}

