/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.setuid;

import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Server;
import org.mortbay.log.Log;
import org.mortbay.setuid.Group;
import org.mortbay.setuid.Passwd;
import org.mortbay.setuid.SetUID;

public class SetUIDServer
extends Server {
    private int _uid = 0;
    private int _gid = 0;
    private int _umask = 0;
    private boolean _startServerAsPrivileged;

    public void setUsername(String username) {
        Passwd passwd = SetUID.getpwnam(username);
        this._uid = passwd.getPwUid();
    }

    public String getUsername() {
        Passwd passwd = SetUID.getpwuid(this._uid);
        return passwd.getPwName();
    }

    public void setGroupname(String groupname) {
        Group group = SetUID.getgrnam(groupname);
        this._gid = group.getGrGid();
    }

    public String getGroupname() {
        Group group = SetUID.getgrgid(this._gid);
        return group.getGrName();
    }

    public int getUmask() {
        return this._umask;
    }

    public void setUmask(int umask) {
        this._umask = umask;
    }

    public int getUid() {
        return this._uid;
    }

    public void setUid(int uid) {
        this._uid = uid;
    }

    public void setGid(int gid) {
        this._gid = gid;
    }

    public int getGid() {
        return this._gid;
    }

    protected void doStart() throws Exception {
        if (this._umask != 0) {
            Log.info((String)("Setting umask=0" + Integer.toString(this._umask, 8)));
            SetUID.setumask(this._umask);
        }
        if (this._startServerAsPrivileged) {
            super.doStart();
            if (this._gid != 0) {
                Log.info((String)("Setting GID=" + this._gid));
                SetUID.setgid(this._gid);
            }
            if (this._uid != 0) {
                Log.info((String)("Setting UID=" + this._uid));
                SetUID.setuid(this._uid);
            }
        } else {
            Connector[] connectors = this.getConnectors();
            for (int i = 0; connectors != null && i < connectors.length; ++i) {
                connectors[i].open();
            }
            if (this._gid != 0) {
                Log.info((String)("Setting GID=" + this._gid));
                SetUID.setgid(this._gid);
            }
            if (this._uid != 0) {
                Log.info((String)("Setting UID=" + this._uid));
                SetUID.setuid(this._uid);
            }
            super.doStart();
        }
    }

    public boolean isStartServerAsPrivileged() {
        return this._startServerAsPrivileged;
    }

    public void setStartServerAsPrivileged(boolean startContextsAsPrivileged) {
        this._startServerAsPrivileged = startContextsAsPrivileged;
    }
}

