/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.handler.rewrite;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.AbstractConnector;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.rewrite.RuleContainer;
import org.mortbay.log.Log;
import org.mortbay.thread.ThreadPool;

public class LowThreadsRuleContainer
extends RuleContainer {
    private ThreadPool _threadPool;
    private Server _server;

    public Server getServer() {
        return this._server;
    }

    public void setServer(Server server) {
        this._server = server;
    }

    public ThreadPool getThreadPool() {
        return this._threadPool;
    }

    private ThreadPool getThreadPool(Request request) {
        if (this._threadPool == null) {
            Connector connector = request.getConnection().getConnector();
            if (connector instanceof AbstractConnector) {
                this._threadPool = ((AbstractConnector)connector).getThreadPool();
                return this._threadPool;
            }
            if (this._server != null) {
                this._threadPool = this._server.getThreadPool();
                return this._threadPool;
            }
        }
        return this._threadPool;
    }

    public void setThreadPool(ThreadPool pool) {
        this._threadPool = pool;
    }

    public String matchAndApply(String target, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this._threadPool = this.getThreadPool((Request)request);
        if (this._threadPool == null) {
            Log.warn((String)"ThreadPool not found");
            return target;
        }
        Log.debug((String)"Low on threads: ", (Object)this._threadPool.isLowOnThreads());
        if (!this._threadPool.isLowOnThreads()) {
            return target;
        }
        return this.apply(target, request, response);
    }
}

