/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.handler.rewrite;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.handler.rewrite.RuleContainer;
import org.mortbay.util.LazyList;

public class VirtualHostRuleContainer
extends RuleContainer {
    private String[] _virtualHosts;

    public void setVirtualHosts(String[] virtualHosts) {
        if (virtualHosts == null) {
            this._virtualHosts = virtualHosts;
        } else {
            this._virtualHosts = new String[virtualHosts.length];
            for (int i = 0; i < virtualHosts.length; ++i) {
                this._virtualHosts[i] = this.normalizeHostname(virtualHosts[i]);
            }
        }
    }

    public String[] getVirtualHosts() {
        return this._virtualHosts;
    }

    public void addVirtualHost(String virtualHost) {
        this._virtualHosts = (String[])LazyList.addToArray((Object[])this._virtualHosts, (Object)virtualHost, String.class);
    }

    public String matchAndApply(String target, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this._virtualHosts != null && this._virtualHosts.length > 0) {
            String requestHost = this.normalizeHostname(request.getServerName());
            for (String ruleHost : this._virtualHosts) {
                if (ruleHost != null && !requestHost.equalsIgnoreCase(ruleHost)) continue;
                return this.apply(target, request, response);
            }
        } else {
            return this.apply(target, request, response);
        }
        return null;
    }

    private String normalizeHostname(String host) {
        if (host == null) {
            return null;
        }
        if (host.endsWith(".")) {
            return host.substring(0, host.length() - 1);
        }
        return host;
    }
}

