/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus.webapp;

import java.net.URL;
import java.util.List;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.mortbay.jetty.plus.naming.EnvEntry;
import org.mortbay.jetty.plus.naming.NamingEntry;
import org.mortbay.jetty.webapp.Configuration;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.log.Log;
import org.mortbay.resource.Resource;
import org.mortbay.xml.XmlConfiguration;

public class EnvConfiguration
implements Configuration {
    private WebAppContext webAppContext;
    private Context compCtx;
    private URL jettyEnvXmlUrl;

    protected void createEnvContext() throws NamingException {
        InitialContext context = new InitialContext();
        this.compCtx = (Context)context.lookup("java:comp");
        Context envCtx = this.compCtx.createSubcontext("env");
        if (Log.isDebugEnabled()) {
            Log.debug((String)("Created java:comp/env for webapp " + this.getWebAppContext().getContextPath()));
        }
    }

    public void setWebAppContext(WebAppContext context) {
        this.webAppContext = context;
    }

    public void setJettyEnvXml(URL url) {
        this.jettyEnvXmlUrl = url;
    }

    public WebAppContext getWebAppContext() {
        return this.webAppContext;
    }

    public void configureClassLoader() throws Exception {
    }

    public void configureDefaults() throws Exception {
    }

    public void configureWebApp() throws Exception {
        Resource jettyEnv;
        Resource web_inf;
        this.createEnvContext();
        this.bindGlobalEnvEntries();
        NamingEntry.setScope(1);
        if (this.jettyEnvXmlUrl == null && (web_inf = this.getWebAppContext().getWebInf()) != null && web_inf.isDirectory() && (jettyEnv = web_inf.addPath("jetty-env.xml")).exists()) {
            this.jettyEnvXmlUrl = jettyEnv.getURL();
        }
        if (this.jettyEnvXmlUrl != null) {
            XmlConfiguration configuration = new XmlConfiguration(this.jettyEnvXmlUrl);
            configuration.configure((Object)this.getWebAppContext());
        }
    }

    public void deconfigureWebApp() throws Exception {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.webAppContext.getClassLoader());
        NamingEntry.setScope(1);
        this.unbindLocalNamingEntries();
        this.compCtx.destroySubcontext("env");
        NamingEntry.setScope(0);
        Thread.currentThread().setContextClassLoader(oldLoader);
    }

    public void bindGlobalEnvEntries() throws NamingException {
        Log.debug((String)"Finding global env entries");
        List list = EnvEntry.lookupGlobalEnvEntries();
        for (EnvEntry ee : list) {
            ee.bindToENC(ee.getJndiName());
        }
    }

    public void unbindLocalNamingEntries() throws NamingException {
    }
}

