/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus.annotation;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.mortbay.util.IntrospectionUtil;

public abstract class LifeCycleCallback {
    public static final Object[] __EMPTY_ARGS = new Object[0];
    private Method _target;
    private String _className;

    public String getClassName() {
        return this._className;
    }

    public void setClassName(String name) {
        this._className = name;
    }

    public Method getTarget() {
        return this._target;
    }

    public void setTarget(Method target) {
        this._target = target;
    }

    public void setTarget(Class clazz, String methodName) {
        try {
            Method method = IntrospectionUtil.findMethod((Class)clazz, (String)methodName, null, (boolean)true, (boolean)true);
            this.validate(clazz, method);
            this._target = method;
            this._className = clazz.getName();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Method " + methodName + " not found on class " + clazz.getName());
        }
    }

    public void callback(Object instance) throws Exception {
        if (this.getTarget() != null) {
            boolean accessibility = this.getTarget().isAccessible();
            this.getTarget().setAccessible(true);
            this.getTarget().invoke(instance, __EMPTY_ARGS);
            this.getTarget().setAccessible(accessibility);
        }
    }

    public Method findMethod(Package pack, Class clazz, String methodName, boolean checkInheritance) {
        if (clazz == null) {
            return null;
        }
        try {
            Method method = clazz.getDeclaredMethod(methodName, null);
            if (checkInheritance) {
                int modifiers = method.getModifiers();
                if (Modifier.isProtected(modifiers) || Modifier.isPublic(modifiers) || !Modifier.isPrivate(modifiers) && pack.equals(clazz.getPackage())) {
                    return method;
                }
                return this.findMethod(clazz.getPackage(), clazz.getSuperclass(), methodName, true);
            }
            return method;
        }
        catch (NoSuchMethodException e) {
            return this.findMethod(clazz.getPackage(), clazz.getSuperclass(), methodName, true);
        }
    }

    public abstract void validate(Class var1, Method var2);
}

