/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.mortbay.jetty.plus.annotation.Injection;
import org.mortbay.log.Log;

public class InjectionCollection {
    private HashMap fieldInjectionsMap = new HashMap();
    private HashMap methodInjectionsMap = new HashMap();

    public void add(Injection injection) {
        ArrayList<Injection> injections;
        if (injection == null || injection.getTarget() == null || injection.getClassName() == null) {
            return;
        }
        Log.debug((String)("Adding injection for class=" + injection.getClassName() + " on a " + injection.getTarget().getClass()));
        HashMap injectionsMap = null;
        if (injection.getTarget() instanceof Field) {
            injectionsMap = this.fieldInjectionsMap;
        }
        if (injection.getTarget() instanceof Method) {
            injectionsMap = this.methodInjectionsMap;
        }
        if ((injections = (ArrayList<Injection>)injectionsMap.get(injection.getClassName())) == null) {
            injections = new ArrayList<Injection>();
            injectionsMap.put(injection.getClassName(), injections);
        }
        injections.add(injection);
    }

    public void inject(Object injectable) throws Exception {
        if (injectable == null) {
            return;
        }
        ArrayList injections = new ArrayList();
        injections.addAll(this.getMatchingInjections(injectable.getClass().getDeclaredFields(), (List)this.fieldInjectionsMap.get(injectable.getClass().getName())));
        injections.addAll(this.getMatchingInjections(injectable.getClass().getDeclaredMethods(), (List)this.methodInjectionsMap.get(injectable.getClass().getName())));
        Iterator itor = injections.iterator();
        while (itor.hasNext()) {
            ((Injection)itor.next()).inject(injectable);
        }
    }

    public List getMatchingInjections(Member[] members, List injections) {
        if (injections == null || members == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Injection> results = new ArrayList<Injection>();
        Iterator itor = injections.iterator();
        while (itor.hasNext()) {
            Injection injection = (Injection)itor.next();
            boolean found = false;
            for (int i = 0; i < members.length && !found; ++i) {
                if (!members[i].equals(injection.getTarget())) continue;
                found = true;
                results.add(injection);
            }
        }
        return results;
    }
}

