/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.eclipse.jetty.util.Scanner;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.mortbay.jetty.plugin.AbstractJettyMojo;

public class JettyRunWarMojo
extends AbstractJettyMojo {
    private File webApp;

    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
    }

    public void configureWebApplication() throws Exception {
        super.configureWebApplication();
        this.webAppConfig.setWar(this.webApp.getCanonicalPath());
    }

    public void checkPomConfiguration() throws MojoExecutionException {
    }

    public void configureScanner() throws MojoExecutionException {
        ArrayList<File> scanList = new ArrayList<File>();
        scanList.add(this.getProject().getFile());
        scanList.add(this.webApp);
        this.setScanList(scanList);
        ArrayList<Scanner.BulkListener> listeners = new ArrayList<Scanner.BulkListener>();
        listeners.add(new Scanner.BulkListener(){

            public void filesChanged(List changes) {
                try {
                    boolean reconfigure = changes.contains(JettyRunWarMojo.this.getProject().getFile().getCanonicalPath());
                    JettyRunWarMojo.this.restartWebApp(reconfigure);
                }
                catch (Exception e) {
                    JettyRunWarMojo.this.getLog().error((CharSequence)"Error reconfiguring/restarting webapp after change in watched files", (Throwable)e);
                }
            }
        });
        this.setScannerListeners(listeners);
    }

    public void restartWebApp(boolean reconfigureScanner) throws Exception {
        this.getLog().info((CharSequence)"Restarting webapp ...");
        this.getLog().debug((CharSequence)"Stopping webapp ...");
        this.webAppConfig.stop();
        this.getLog().debug((CharSequence)"Reconfiguring webapp ...");
        this.checkPomConfiguration();
        if (reconfigureScanner) {
            this.getLog().info((CharSequence)"Reconfiguring scanner after change to pom.xml ...");
            ArrayList<File> scanList = this.getScanList();
            scanList.clear();
            scanList.add(this.getProject().getFile());
            scanList.add(this.webApp);
            this.setScanList(scanList);
            this.getScanner().setScanDirs(scanList);
        }
        this.getLog().debug((CharSequence)"Restarting webapp ...");
        this.webAppConfig.start();
        this.getLog().info((CharSequence)"Restart completed.");
    }

    public void finishConfigurationBeforeStart() {
    }

    public void applyJettyXml() throws Exception {
        if (this.getJettyXmlFiles() == null) {
            return;
        }
        for (File xmlFile : this.getJettyXmlFiles()) {
            this.getLog().info((CharSequence)("Configuring Jetty from xml configuration file = " + xmlFile.getCanonicalPath()));
            XmlConfiguration xmlConfiguration = new XmlConfiguration(xmlFile.toURI().toURL());
            xmlConfiguration.configure((Object)this.server);
        }
    }
}

