/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plugin;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.webapp.WebAppClassLoader;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebInfConfiguration;
import org.mortbay.jetty.plugin.JettyWebAppContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenWebInfConfiguration
extends WebInfConfiguration {
    public void configure(WebAppContext context) throws Exception {
        JettyWebAppContext jwac = (JettyWebAppContext)context;
        if (jwac.getClassPathFiles() != null) {
            Log.debug((String)"Setting up classpath ...");
            Iterator<File> itor = jwac.getClassPathFiles().iterator();
            while (itor.hasNext()) {
                ((WebAppClassLoader)context.getClassLoader()).addClassPath(itor.next().getCanonicalPath());
            }
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Classpath = " + LazyList.array2List((Object[])((URLClassLoader)context.getClassLoader()).getURLs())));
            }
        }
        super.configure(context);
        String[] existingServerClasses = context.getServerClasses();
        String[] newServerClasses = new String[2 + (existingServerClasses == null ? 0 : existingServerClasses.length)];
        newServerClasses[0] = "-org.apache.maven.";
        newServerClasses[1] = "-org.codehaus.plexus.";
        System.arraycopy(existingServerClasses, 0, newServerClasses, 2, existingServerClasses.length);
        context.setServerClasses(newServerClasses);
    }

    public void deconfigure(WebAppContext context) throws Exception {
        super.deconfigure(context);
    }

    public void postConfigure(WebAppContext context) throws Exception {
        super.postConfigure(context);
    }

    protected List<Resource> findJars(WebAppContext context) throws Exception {
        ArrayList<Resource> list = new ArrayList<Resource>();
        JettyWebAppContext jwac = (JettyWebAppContext)context;
        if (jwac.getClassPathFiles() != null) {
            for (File f : jwac.getClassPathFiles()) {
                if (!f.getName().toLowerCase().endsWith(".jar")) continue;
                try {
                    list.add(Resource.newResource((URI)f.toURI()));
                }
                catch (Exception e) {
                    Log.warn((String)"Bad url ", (Throwable)e);
                }
            }
        }
        List superList = super.findJars(context);
        list.addAll(superList);
        return list;
    }

    public void unpack(WebAppContext context) throws IOException {
        super.unpack(context);
        Resource web_app = context.getBaseResource();
        Resource web_inf = web_app.addPath("WEB-INF/");
        if (web_inf.exists() && web_inf.isDirectory() && (web_inf.getFile() == null || !web_app.getFile().isDirectory())) {
            File extractedWebInfDir = new File(context.getTempDirectory(), "webinf");
            if (extractedWebInfDir.exists()) {
                extractedWebInfDir.delete();
            }
            extractedWebInfDir.mkdir();
            File webInfDir = new File(extractedWebInfDir, "WEB-INF");
            webInfDir.mkdir();
            Log.info((String)("Extract " + web_inf + " to " + webInfDir));
            web_inf.copyTo(webInfDir);
            web_inf = Resource.newResource((URL)extractedWebInfDir.toURL());
            ResourceCollection rc = new ResourceCollection(new Resource[]{web_inf, web_app});
            context.setBaseResource((Resource)rc);
        }
    }
}

