/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plugin;

import java.io.File;
import java.util.List;
import org.eclipse.jetty.plus.webapp.EnvConfiguration;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.JettyWebXmlConfiguration;
import org.eclipse.jetty.webapp.TagLibConfiguration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebInfConfiguration;
import org.mortbay.jetty.plugin.JettyMavenConfiguration;

public class JettyWebAppContext
extends WebAppContext {
    private List classpathFiles;
    private File jettyEnvXmlFile;
    private File webXmlFile;
    private WebInfConfiguration webInfConfig = new WebInfConfiguration();
    private EnvConfiguration envConfig = new EnvConfiguration();
    private JettyMavenConfiguration mvnConfig = new JettyMavenConfiguration();
    private JettyWebXmlConfiguration jettyWebConfig = new JettyWebXmlConfiguration();
    private TagLibConfiguration tagConfig = new TagLibConfiguration();
    private Configuration[] configs = new Configuration[]{this.webInfConfig, this.envConfig, this.mvnConfig, this.jettyWebConfig, this.tagConfig};

    public JettyWebAppContext() throws Exception {
        this.setConfigurations(this.configs);
    }

    public void setClassPathFiles(List classpathFiles) {
        this.classpathFiles = classpathFiles;
    }

    public List getClassPathFiles() {
        return this.classpathFiles;
    }

    public void setWebXmlFile(File webXmlFile) {
        this.webXmlFile = webXmlFile;
    }

    public File getWebXmlFile() {
        return this.webXmlFile;
    }

    public void setJettyEnvXmlFile(File jettyEnvXmlFile) {
        this.jettyEnvXmlFile = jettyEnvXmlFile;
    }

    public File getJettyEnvXmlFile() {
        return this.jettyEnvXmlFile;
    }

    public void configure() {
        this.setConfigurations(this.configs);
        this.mvnConfig.setClassPathConfiguration(this.classpathFiles);
        this.mvnConfig.setWebXml(this.webXmlFile);
        try {
            if (this.jettyEnvXmlFile != null) {
                this.envConfig.setJettyEnvXml(this.jettyEnvXmlFile.toURL());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void doStart() throws Exception {
        this.setShutdown(false);
        super.doStart();
    }

    public void doStop() throws Exception {
        this.setShutdown(true);
        Thread.currentThread();
        Thread.sleep(500L);
        super.doStop();
    }
}

