/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plugin;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.util.Scanner;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.mortbay.jetty.plugin.AbstractJettyMojo;
import org.mortbay.jetty.plugin.ScanTargetPattern;

public class JettyRunMojo
extends AbstractJettyMojo {
    private boolean useTestClasspath;
    private File jettyEnvXml;
    private File webXml;
    private File classesDirectory;
    private File testClassesDirectory;
    private File webAppSourceDirectory;
    private List pluginArtifacts;
    private File[] scanTargets;
    private ScanTargetPattern[] scanTargetPatterns;
    private File webXmlFile;
    private File jettyEnvXmlFile;
    private List classPathFiles;
    private List extraScanTargets;
    private List _overlays;

    static boolean isEqual(List list1, List list2) {
        if (list2 == null || list1.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list1.size(); ++i) {
            if (list1.get(i).equals(list2.get(i))) continue;
            return false;
        }
        return true;
    }

    public File getWebXml() {
        return this.webXml;
    }

    public File getJettyEnvXml() {
        return this.jettyEnvXml;
    }

    public File getClassesDirectory() {
        return this.classesDirectory;
    }

    public File getWebAppSourceDirectory() {
        return this.webAppSourceDirectory;
    }

    public void setWebXmlFile(File f) {
        this.webXmlFile = f;
    }

    public File getWebXmlFile() {
        return this.webXmlFile;
    }

    public File getJettyEnvXmlFile() {
        return this.jettyEnvXmlFile;
    }

    public void setJettyEnvXmlFile(File f) {
        this.jettyEnvXmlFile = f;
    }

    public void setClassPathFiles(List list) {
        this.classPathFiles = new ArrayList(list);
    }

    public List getClassPathFiles() {
        return this.classPathFiles;
    }

    public List getExtraScanTargets() {
        return this.extraScanTargets;
    }

    public void setExtraScanTargets(List list) {
        this.extraScanTargets = list;
    }

    public void checkPomConfiguration() throws MojoExecutionException {
        int i;
        try {
            if (this.getWebAppSourceDirectory() == null || !this.getWebAppSourceDirectory().exists()) {
                throw new MojoExecutionException("Webapp source directory " + (this.getWebAppSourceDirectory() == null ? "null" : this.getWebAppSourceDirectory().getCanonicalPath()) + " does not exist");
            }
            this.getLog().info((CharSequence)("Webapp source directory = " + this.getWebAppSourceDirectory().getCanonicalPath()));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Webapp source directory does not exist", (Exception)e);
        }
        if (!"automatic".equalsIgnoreCase(this.reload) && !"manual".equalsIgnoreCase(this.reload)) {
            throw new MojoExecutionException("invalid reload mechanic specified, must be 'automatic' or 'manual'");
        }
        this.getLog().info((CharSequence)("Reload Mechanic: " + this.reload));
        if (this.getWebXml() == null) {
            this.webXml = new File(new File(this.getWebAppSourceDirectory(), "WEB-INF"), "web.xml");
        }
        this.setWebXmlFile(this.webXml);
        try {
            if (!this.getWebXmlFile().exists()) {
                throw new MojoExecutionException("web.xml does not exist at location " + this.webXmlFile.getCanonicalPath());
            }
            this.getLog().info((CharSequence)("web.xml file = " + this.webXmlFile.getCanonicalPath()));
        }
        catch (IOException e) {
            throw new MojoExecutionException("web.xml does not exist", (Exception)e);
        }
        if (this.getJettyEnvXml() != null) {
            this.setJettyEnvXmlFile(this.jettyEnvXml);
            try {
                if (!this.getJettyEnvXmlFile().exists()) {
                    throw new MojoExecutionException("jetty-env.xml file does not exist at location " + this.jettyEnvXml);
                }
                this.getLog().info((CharSequence)(" jetty-env.xml = " + this.getJettyEnvXmlFile().getCanonicalPath()));
            }
            catch (IOException e) {
                throw new MojoExecutionException("jetty-env.xml does not exist");
            }
        }
        try {
            if (this.getClassesDirectory() != null) {
                if (!this.getClassesDirectory().exists()) {
                    this.getLog().info((CharSequence)("Classes directory " + this.getClassesDirectory().getCanonicalPath() + " does not exist"));
                } else {
                    this.getLog().info((CharSequence)("Classes = " + this.getClassesDirectory().getCanonicalPath()));
                }
            } else {
                this.getLog().info((CharSequence)"Classes directory not set");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Location of classesDirectory does not exist");
        }
        this.setExtraScanTargets(new ArrayList());
        if (this.scanTargets != null) {
            for (i = 0; i < this.scanTargets.length; ++i) {
                this.getLog().info((CharSequence)("Added extra scan target:" + this.scanTargets[i]));
                this.getExtraScanTargets().add(this.scanTargets[i]);
            }
        }
        if (this.scanTargetPatterns != null) {
            for (i = 0; i < this.scanTargetPatterns.length; ++i) {
                Iterator itor = this.scanTargetPatterns[i].getIncludes().iterator();
                StringBuffer strbuff = new StringBuffer();
                while (itor.hasNext()) {
                    strbuff.append((String)itor.next());
                    if (!itor.hasNext()) continue;
                    strbuff.append(",");
                }
                String includes = strbuff.toString();
                itor = this.scanTargetPatterns[i].getExcludes().iterator();
                strbuff = new StringBuffer();
                while (itor.hasNext()) {
                    strbuff.append((String)itor.next());
                    if (!itor.hasNext()) continue;
                    strbuff.append(",");
                }
                String excludes = strbuff.toString();
                try {
                    List files = FileUtils.getFiles((File)this.scanTargetPatterns[i].getDirectory(), (String)includes, (String)excludes);
                    itor = files.iterator();
                    while (itor.hasNext()) {
                        this.getLog().info((CharSequence)("Adding extra scan target from pattern: " + itor.next()));
                    }
                    List currentTargets = this.getExtraScanTargets();
                    if (currentTargets != null && !currentTargets.isEmpty()) {
                        currentTargets.addAll(files);
                        continue;
                    }
                    this.setExtraScanTargets(files);
                    continue;
                }
                catch (IOException e) {
                    throw new MojoExecutionException(e.getMessage());
                }
            }
        }
    }

    public void configureWebApplication() throws Exception {
        super.configureWebApplication();
        this.setClassPathFiles(this.setUpClassPath());
        if (this.webAppConfig.getWebXmlFile() == null) {
            this.webAppConfig.setWebXmlFile(this.getWebXmlFile());
        }
        if (this.webAppConfig.getJettyEnvXmlFile() == null) {
            this.webAppConfig.setJettyEnvXmlFile(this.getJettyEnvXmlFile());
        }
        if (this.webAppConfig.getClassPathFiles() == null) {
            this.webAppConfig.setClassPathFiles(this.getClassPathFiles());
        }
        if (this.webAppConfig.getWar() == null) {
            this.webAppConfig.setWar(this.getWebAppSourceDirectory().getCanonicalPath());
        }
        this.getLog().info((CharSequence)("Webapp directory = " + this.getWebAppSourceDirectory().getCanonicalPath()));
        this.webAppConfig.configure();
    }

    public void configureScanner() {
        File jettyWebXmlFile;
        ArrayList<File> scanList = new ArrayList<File>();
        scanList.add(this.getWebXmlFile());
        if (this.getJettyEnvXmlFile() != null) {
            scanList.add(this.getJettyEnvXmlFile());
        }
        if ((jettyWebXmlFile = this.findJettyWebXmlFile(new File(this.getWebAppSourceDirectory(), "WEB-INF"))) != null) {
            scanList.add(jettyWebXmlFile);
        }
        scanList.addAll(this.getExtraScanTargets());
        scanList.add(this.getProject().getFile());
        scanList.addAll(this.getClassPathFiles());
        this.setScanList(scanList);
        ArrayList<1> listeners = new ArrayList<1>();
        listeners.add(new Scanner.BulkListener(){

            public void filesChanged(List changes) {
                try {
                    boolean reconfigure = changes.contains(JettyRunMojo.this.getProject().getFile().getCanonicalPath());
                    JettyRunMojo.this.restartWebApp(reconfigure);
                }
                catch (Exception e) {
                    JettyRunMojo.this.getLog().error((CharSequence)"Error reconfiguring/restarting webapp after change in watched files", (Throwable)e);
                }
            }
        });
        this.setScannerListeners(listeners);
    }

    public void restartWebApp(boolean reconfigureScanner) throws Exception {
        this.getLog().info((CharSequence)("restarting " + (Object)((Object)this.webAppConfig)));
        this.getLog().debug((CharSequence)"Stopping webapp ...");
        this.webAppConfig.stop();
        this.getLog().debug((CharSequence)"Reconfiguring webapp ...");
        this.checkPomConfiguration();
        this.configureWebApplication();
        if (reconfigureScanner) {
            this.getLog().info((CharSequence)"Reconfiguring scanner after change to pom.xml ...");
            this.scanList.clear();
            this.scanList.add(this.getWebXmlFile());
            if (this.getJettyEnvXmlFile() != null) {
                this.scanList.add(this.getJettyEnvXmlFile());
            }
            this.scanList.addAll(this.getExtraScanTargets());
            this.scanList.add(this.getProject().getFile());
            this.scanList.addAll(this.getClassPathFiles());
            this.getScanner().setScanDirs((List)this.scanList);
        }
        this.getLog().debug((CharSequence)"Restarting webapp ...");
        this.webAppConfig.start();
        this.getLog().info((CharSequence)("Restart completed at " + new Date().toString()));
    }

    private List getDependencyFiles() {
        ArrayList<File> dependencyFiles = new ArrayList<File>();
        ArrayList<Resource> overlays = new ArrayList<Resource>();
        for (Artifact artifact : this.getProject().getArtifacts()) {
            if (artifact.getType().equals("war")) {
                try {
                    Resource r = Resource.newResource((String)("jar:" + artifact.getFile().toURL().toString() + "!/"));
                    overlays.add(r);
                    this.getExtraScanTargets().add(artifact.getFile());
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (("provided".equals(artifact.getScope()) || "test".equals(artifact.getScope())) && (!this.useTestClasspath || !"test".equals(artifact.getScope()))) continue;
            dependencyFiles.add(artifact.getFile());
            this.getLog().debug((CharSequence)("Adding artifact " + artifact.getFile().getName() + " for WEB-INF/lib "));
        }
        if (!overlays.isEmpty() && !JettyRunMojo.isEqual(overlays, this._overlays)) {
            try {
                Resource resource = this._overlays == null ? this.webAppConfig.getBaseResource() : null;
                ResourceCollection rc = new ResourceCollection();
                if (resource == null) {
                    int size = overlays.size() + 1;
                    Resource[] resources = new Resource[size];
                    resources[0] = Resource.newResource((URL)this.getWebAppSourceDirectory().toURL());
                    for (int i = 1; i < size; ++i) {
                        resources[i] = (Resource)overlays.get(i - 1);
                        this.getLog().info((CharSequence)("Adding overlay: " + resources[i]));
                    }
                    rc.setResources(resources);
                } else if (resource instanceof ResourceCollection) {
                    Resource[] old = ((ResourceCollection)resource).getResources();
                    int size = old.length + overlays.size();
                    Resource[] resources = new Resource[size];
                    System.arraycopy(old, 0, resources, 0, old.length);
                    int i = old.length;
                    int j = 0;
                    while (i < size) {
                        resources[i] = (Resource)overlays.get(j);
                        this.getLog().info((CharSequence)("Adding overlay: " + resources[i]));
                        ++i;
                        ++j;
                    }
                    rc.setResources(resources);
                } else {
                    if (!resource.isDirectory() && String.valueOf(resource.getFile()).endsWith(".war")) {
                        resource = Resource.newResource((String)("jar:" + resource.getURL().toString() + "!/"));
                    }
                    int size = overlays.size() + 1;
                    Resource[] resources = new Resource[size];
                    resources[0] = resource;
                    for (int i = 1; i < size; ++i) {
                        resources[i] = (Resource)overlays.get(i - 1);
                        this.getLog().info((CharSequence)("Adding overlay: " + resources[i]));
                    }
                    rc.setResources(resources);
                }
                this.webAppConfig.setBaseResource((Resource)rc);
                this._overlays = overlays;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return dependencyFiles;
    }

    private List setUpClassPath() {
        ArrayList<File> classPathFiles = new ArrayList<File>();
        if (this.useTestClasspath && this.testClassesDirectory != null) {
            classPathFiles.add(this.testClassesDirectory);
        }
        if (this.getClassesDirectory() != null) {
            classPathFiles.add(this.getClassesDirectory());
        }
        classPathFiles.addAll(this.getDependencyFiles());
        if (this.getLog().isDebugEnabled()) {
            for (int i = 0; i < classPathFiles.size(); ++i) {
                this.getLog().debug((CharSequence)("classpath element: " + ((File)classPathFiles.get(i)).getName()));
            }
        }
        return classPathFiles;
    }

    public void finishConfigurationBeforeStart() throws Exception {
        HandlerCollection contexts = (HandlerCollection)this.server.getChildHandlerByClass(ContextHandlerCollection.class);
        if (contexts == null) {
            contexts = (HandlerCollection)this.server.getChildHandlerByClass(HandlerCollection.class);
        }
        for (int i = 0; this.contextHandlers != null && i < this.contextHandlers.length; ++i) {
            contexts.addHandler((Handler)this.contextHandlers[i]);
        }
    }

    public void applyJettyXml() throws Exception {
        if (this.getJettyXmlFile() == null) {
            return;
        }
        this.getLog().info((CharSequence)("Configuring Jetty from xml configuration file = " + this.getJettyXmlFile()));
        XmlConfiguration xmlConfiguration = new XmlConfiguration(this.getJettyXmlFile().toURL());
        xmlConfiguration.configure((Object)this.server);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
    }
}

