/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plugin;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jetty.annotations.Configuration;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.webapp.WebAppClassLoader;

public class JettyMavenConfiguration
extends Configuration {
    private List classPathFiles;
    private File webXmlFile;

    public void setClassPathConfiguration(List classPathFiles) {
        this.classPathFiles = classPathFiles;
    }

    public void setWebXml(File webXmlFile) {
        this.webXmlFile = webXmlFile;
    }

    public void configureClassLoader() throws Exception {
        if (this.classPathFiles != null) {
            Log.debug((String)"Setting up classpath ...");
            Iterator itor = this.classPathFiles.iterator();
            while (itor.hasNext()) {
                ((WebAppClassLoader)this.getWebAppContext().getClassLoader()).addClassPath(((File)itor.next()).getCanonicalPath());
            }
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Classpath = " + LazyList.array2List((Object[])((URLClassLoader)this.getWebAppContext().getClassLoader()).getURLs())));
            }
        } else {
            super.configureClassLoader();
        }
        String[] existingServerClasses = this.getWebAppContext().getServerClasses();
        String[] newServerClasses = new String[2 + (existingServerClasses == null ? 0 : existingServerClasses.length)];
        newServerClasses[0] = "-org.apache.maven.";
        newServerClasses[1] = "-org.codehaus.plexus.";
        System.arraycopy(existingServerClasses, 0, newServerClasses, 2, existingServerClasses.length);
        this.getWebAppContext().setServerClasses(newServerClasses);
    }

    protected URL findWebXml() throws IOException, MalformedURLException {
        if (this.webXmlFile != null && this.webXmlFile.exists()) {
            return this.webXmlFile.toURL();
        }
        Log.debug((String)"Looking for web.xml file in WEB-INF");
        return super.findWebXml();
    }

    public void parseAnnotations() throws Exception {
        String v = System.getProperty("java.version");
        String[] version = v.split("\\.");
        if (version == null) {
            Log.info((String)"Unable to determine jvm version, annotations will not be supported");
            return;
        }
        int major = Integer.parseInt(version[0]);
        int minor = Integer.parseInt(version[1]);
        if (major >= 1 && minor >= 5) {
            super.parseAnnotations();
        } else {
            Log.info((String)"Annotations are not supported on jvms prior to jdk1.5");
        }
    }
}

