/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.jspc.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.jasper.JspC;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.mortbay.util.IO;

public class JspcMojo
extends AbstractMojo {
    public static final String END_OF_WEBAPP = "</web-app>";
    private MavenProject project;
    private String webXmlFragment;
    private String insertionMarker;
    private boolean mergeFragment;
    private String generatedClasses;
    private boolean keepSources;
    private String packageRoot;
    private String webAppSourceDirectory;
    private String includes;
    private String excludes;
    private File classesDirectory;
    private boolean verbose;
    private boolean validateXml;
    private String javaEncoding;
    private boolean suppressSmap;
    private boolean ignoreJspFragmentErrors;
    private String schemaResourcePrefix;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().info((CharSequence)("verbose=" + this.verbose));
            this.getLog().info((CharSequence)("webAppSourceDirectory=" + this.webAppSourceDirectory));
            this.getLog().info((CharSequence)("generatedClasses=" + this.generatedClasses));
            this.getLog().info((CharSequence)("webXmlFragment=" + this.webXmlFragment));
            this.getLog().info((CharSequence)("validateXml=" + this.validateXml));
            this.getLog().info((CharSequence)("packageRoot=" + this.packageRoot));
            this.getLog().info((CharSequence)("javaEncoding=" + this.javaEncoding));
            this.getLog().info((CharSequence)("insertionMarker=" + (this.insertionMarker == null || this.insertionMarker.equals("") ? END_OF_WEBAPP : this.insertionMarker)));
            this.getLog().info((CharSequence)("keepSources=" + this.keepSources));
            this.getLog().info((CharSequence)("mergeFragment=" + this.mergeFragment));
            this.getLog().info((CharSequence)("suppressSmap=" + this.suppressSmap));
            this.getLog().info((CharSequence)("ignoreJspFragmentErrors=" + this.ignoreJspFragmentErrors));
            this.getLog().info((CharSequence)("schemaResourcePrefix=" + this.schemaResourcePrefix));
        }
        try {
            this.prepare();
            this.compile();
            this.cleanupSrcs();
            this.mergeWebXml();
        }
        catch (Exception e) {
            throw new MojoFailureException((Object)e, "Failure processing jsps", "Failure processing jsps");
        }
    }

    public void compile() throws Exception {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        ArrayList urls = new ArrayList();
        this.setUpClassPath(urls);
        URLClassLoader ucl = new URLClassLoader(urls.toArray(new URL[0]), currentClassLoader);
        StringBuffer classpathStr = new StringBuffer();
        for (int i = 0; i < urls.size(); ++i) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("webappclassloader contains: " + urls.get(i)));
            }
            classpathStr.append(((URL)urls.get(i)).getFile());
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("added to classpath: " + ((URL)urls.get(i)).getFile()));
            }
            classpathStr.append(System.getProperty("path.separator"));
        }
        Thread.currentThread().setContextClassLoader(ucl);
        JspC jspc = new JspC();
        jspc.setWebXmlFragment(this.webXmlFragment);
        jspc.setUriroot(this.webAppSourceDirectory);
        jspc.setPackage(this.packageRoot);
        jspc.setOutputDir(this.generatedClasses);
        jspc.setValidateXml(this.validateXml);
        jspc.setClassPath(classpathStr.toString());
        jspc.setCompile(true);
        jspc.setSmapSuppressed(this.suppressSmap);
        jspc.setSmapDumped(!this.suppressSmap);
        jspc.setJavaEncoding(this.javaEncoding);
        String jspFiles = this.getJspFiles(this.webAppSourceDirectory);
        System.err.println("Compiling " + jspFiles);
        System.err.println("Includes=" + this.includes);
        System.err.println("Excludes=" + this.excludes);
        jspc.setJspFiles(jspFiles);
        if (this.verbose) {
            this.getLog().info((CharSequence)("Files selected to precompile: " + jspFiles));
        }
        try {
            jspc.setIgnoreJspFragmentErrors(this.ignoreJspFragmentErrors);
        }
        catch (NoSuchMethodError e) {
            this.getLog().debug((CharSequence)"Tomcat Jasper does not support configuration option 'ignoreJspFragmentErrors': ignored");
        }
        try {
            if (this.schemaResourcePrefix != null) {
                JspC.setSchemaResourcePrefix((String)this.schemaResourcePrefix);
            }
        }
        catch (NoSuchMethodError e) {
            this.getLog().debug((CharSequence)"Tomcat Jasper does not support configuration option 'schemaResourcePrefix': ignored");
        }
        if (this.verbose) {
            jspc.setVerbose(99);
        } else {
            jspc.setVerbose(0);
        }
        jspc.execute();
        Thread.currentThread().setContextClassLoader(currentClassLoader);
    }

    private String getJspFiles(String webAppSourceDirectory) throws Exception {
        List fileNames = FileUtils.getFileNames((File)new File(webAppSourceDirectory), (String)this.includes, (String)this.excludes, (boolean)false);
        return StringUtils.join((Object[])fileNames.toArray(new String[0]), (String)",");
    }

    public void cleanupSrcs() throws Exception {
        if (!this.keepSources) {
            String packageRootDirectory = this.packageRoot.replace('.', File.separatorChar);
            File generatedClassesDir = new File(this.generatedClasses + File.separatorChar + packageRootDirectory);
            File[] srcFiles = generatedClassesDir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    if (name == null) {
                        return false;
                    }
                    if (name.trim().equals("")) {
                        return false;
                    }
                    return name.endsWith(".java");
                }
            });
            for (int i = 0; srcFiles != null && i < srcFiles.length; ++i) {
                srcFiles[i].delete();
            }
        }
    }

    public void mergeWebXml() throws Exception {
        if (this.mergeFragment) {
            String marker;
            File webXml = new File(this.webAppSourceDirectory + "/WEB-INF/web.xml");
            if (!webXml.exists()) {
                this.getLog().info((CharSequence)(this.webAppSourceDirectory + "/WEB-INF/web.xml does not exist, cannot merge with generated fragment"));
                return;
            }
            File fragmentWebXml = new File(this.webXmlFragment);
            if (!fragmentWebXml.exists()) {
                this.getLog().info((CharSequence)"No fragment web.xml file generated");
            }
            File mergedWebXml = new File(fragmentWebXml.getParentFile(), "web.xml");
            BufferedReader webXmlReader = new BufferedReader(new FileReader(webXml));
            PrintWriter mergedWebXmlWriter = new PrintWriter(new FileWriter(mergedWebXml));
            boolean atInsertPoint = false;
            boolean atEOF = false;
            String string = marker = this.insertionMarker == null || this.insertionMarker.equals("") ? END_OF_WEBAPP : this.insertionMarker;
            while (!atInsertPoint && !atEOF) {
                String line = webXmlReader.readLine();
                if (line == null) {
                    atEOF = true;
                    continue;
                }
                if (line.indexOf(marker) >= 0) {
                    atInsertPoint = true;
                    continue;
                }
                mergedWebXmlWriter.println(line);
            }
            BufferedReader fragmentWebXmlReader = new BufferedReader(new FileReader(fragmentWebXml));
            IO.copy((Reader)fragmentWebXmlReader, (Writer)mergedWebXmlWriter);
            if (marker.equals(END_OF_WEBAPP)) {
                mergedWebXmlWriter.println(END_OF_WEBAPP);
            }
            IO.copy((Reader)webXmlReader, (Writer)mergedWebXmlWriter);
            webXmlReader.close();
            mergedWebXmlWriter.close();
            fragmentWebXmlReader.close();
        }
    }

    private void prepare() throws Exception {
        File generatedSourceDirectoryFile = new File(this.generatedClasses);
        if (!generatedSourceDirectoryFile.exists()) {
            generatedSourceDirectoryFile.mkdirs();
        }
    }

    private void setUpClassPath(List urls) throws Exception {
        String classesDir = this.classesDirectory.getCanonicalPath();
        classesDir = classesDir + (classesDir.endsWith(File.pathSeparator) ? "" : File.separator);
        urls.add(new File(classesDir).toURL());
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Adding to classpath classes dir: " + classesDir));
        }
        for (Artifact artifact : this.project.getArtifacts()) {
            if ("test".equals(artifact.getScope())) continue;
            String filePath = artifact.getFile().getCanonicalPath();
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Adding to classpath dependency file: " + filePath));
            }
            urls.add(artifact.getFile().toURL());
        }
    }
}

