/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.server.rpc;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.impl.ServerSerializableTypeOracle;
import com.google.gwt.user.server.rpc.impl.ServerSerializableTypeOracleImpl;
import com.google.gwt.user.server.rpc.impl.ServerSerializationStreamReader;
import com.google.gwt.user.server.rpc.impl.ServerSerializationStreamWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class OpenRemoteServiceServlet
extends HttpServlet {
    private static final String ACCEPT_ENCODING = "Accept-Encoding";
    private static final String CHARSET_UTF8 = "UTF-8";
    private static final String CONTENT_ENCODING = "Content-Encoding";
    private static final String CONTENT_ENCODING_GZIP = "gzip";
    private static final String CONTENT_TYPE_TEXT_PLAIN_UTF8 = "text/plain; charset=utf-8";
    private static final String GENERIC_FAILURE_MSG = "The call failed on the server; see server log for details";
    private static final HashMap TYPE_NAMES = new HashMap();
    private static final int UNCOMPRESSED_BYTE_SIZE_LIMIT = 256;
    private final Set knownImplementedInterfaces = new HashSet();
    private final ThreadLocal perThreadRequest = new ThreadLocal();
    private final ThreadLocal perThreadResponse = new ThreadLocal();
    private final ServerSerializableTypeOracle serializableTypeOracle = new ServerSerializableTypeOracleImpl(this.getPackagePaths());

    private static boolean acceptsGzipEncoding(HttpServletRequest request) {
        assert (request != null);
        String acceptEncoding = request.getHeader(ACCEPT_ENCODING);
        if (null == acceptEncoding) {
            return false;
        }
        return acceptEncoding.indexOf(CONTENT_ENCODING_GZIP) != -1;
    }

    private static int estimateByteSize(String buffer) {
        return buffer.length() * 2;
    }

    private static Method findInterfaceMethod(Class intf, String methodName, Class[] paramTypes, boolean includeInherited) {
        try {
            return intf.getDeclaredMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException e) {
            if (includeInherited) {
                Class<?>[] superintfs = intf.getInterfaces();
                for (int i = 0; i < superintfs.length; ++i) {
                    Method method = OpenRemoteServiceServlet.findInterfaceMethod(superintfs[i], methodName, paramTypes, true);
                    if (method == null) continue;
                    return method;
                }
            }
            return null;
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        Throwable caught;
        try {
            this.perThreadRequest.set(request);
            this.perThreadResponse.set(response);
            String requestPayload = this.readPayloadAsUtf8(request);
            String responsePayload = this.processCall(requestPayload);
            this.writeResponse(request, response, responsePayload);
            return;
        }
        catch (IOException e) {
            caught = e;
        }
        catch (ServletException e) {
            caught = e;
        }
        catch (SerializationException e) {
            caught = e;
        }
        catch (Throwable e) {
            caught = e;
        }
        this.respondWithFailure(response, caught);
    }

    public String processCall(String payload) throws SerializationException {
        Throwable caught;
        String responsePayload;
        block13: {
            Class serviceIntf;
            this.onBeforeRequestDeserialized(payload);
            ServerSerializationStreamReader streamReader = new ServerSerializationStreamReader(this.serializableTypeOracle);
            streamReader.prepareToRead(payload);
            String serviceIntfName = streamReader.readString();
            if (!this.isImplementedRemoteServiceInterface(serviceIntfName)) {
                throw new SecurityException("Blocked attempt to access interface '" + serviceIntfName + "', which is either not implemented by this servlet or which doesn't extend RemoteService; this is either misconfiguration or a hack attempt");
            }
            try {
                serviceIntf = this.getClassFromName(serviceIntfName);
            }
            catch (ClassNotFoundException e) {
                throw new SerializationException("Unknown service interface class '" + serviceIntfName + "'", (Throwable)e);
            }
            String methodName = streamReader.readString();
            int paramCount = streamReader.readInt();
            Class[] paramTypes = new Class[paramCount];
            for (int i = 0; i < paramTypes.length; ++i) {
                String paramClassName = streamReader.readString();
                try {
                    paramTypes[i] = this.getClassOrPrimitiveFromName(paramClassName);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new SerializationException("Unknown parameter " + i + " type '" + paramClassName + "'", (Throwable)e);
                }
            }
            Method serviceIntfMethod = OpenRemoteServiceServlet.findInterfaceMethod(serviceIntf, methodName, paramTypes, true);
            if (serviceIntfMethod == null) {
                throw new SecurityException("Method '" + methodName + "' (or a particular overload) on interface '" + serviceIntfName + "' was not found, this is either misconfiguration or a hack attempt");
            }
            Object[] args = new Object[paramCount];
            for (int i = 0; i < args.length; ++i) {
                args[i] = streamReader.deserializeValue(paramTypes[i]);
            }
            responsePayload = GENERIC_FAILURE_MSG;
            ServerSerializationStreamWriter streamWriter = new ServerSerializationStreamWriter(this.serializableTypeOracle);
            caught = null;
            try {
                Class<?> returnType = serviceIntfMethod.getReturnType();
                Object returnVal = serviceIntfMethod.invoke((Object)this, args);
                responsePayload = this.createResponse(streamWriter, returnType, returnVal, false);
            }
            catch (IllegalArgumentException e) {
                caught = e;
            }
            catch (IllegalAccessException e) {
                caught = e;
            }
            catch (InvocationTargetException e) {
                caught = e;
                Throwable cause = e.getCause();
                if (cause == null) break block13;
                caught = cause;
                if (!this.isExpectedException(serviceIntfMethod, cause)) break block13;
                Class<?> thrownClass = cause.getClass();
                responsePayload = this.createResponse(streamWriter, thrownClass, cause, true);
                caught = null;
            }
        }
        if (caught != null) {
            this.handleException(responsePayload, caught);
        }
        this.onAfterResponseSerialized(responsePayload);
        return responsePayload;
    }

    protected void handleException(String responsePayload, Throwable caught) {
        responsePayload = GENERIC_FAILURE_MSG;
        ServletContext servletContext = this.getServletContext();
        if (servletContext != null) {
            servletContext.log("Exception while dispatching incoming RPC call", caught);
        }
    }

    protected final HttpServletRequest getThreadLocalRequest() {
        return (HttpServletRequest)this.perThreadRequest.get();
    }

    protected final HttpServletResponse getThreadLocalResponse() {
        return (HttpServletResponse)this.perThreadResponse.get();
    }

    protected void onAfterResponseSerialized(String serializedResponse) {
    }

    protected void onBeforeRequestDeserialized(String serializedRequest) {
    }

    protected boolean shouldCompressResponse(HttpServletRequest request, HttpServletResponse response, String responsePayload) {
        return OpenRemoteServiceServlet.estimateByteSize(responsePayload) > 256;
    }

    private String createResponse(ServerSerializationStreamWriter stream, Class responseType, Object responseObj, boolean isException) {
        stream.prepareToWrite();
        if (responseType != Void.TYPE) {
            try {
                stream.serializeValue(responseObj, responseType);
            }
            catch (SerializationException e) {
                responseObj = e;
                isException = true;
            }
        }
        String bufferStr = (isException ? "{EX}" : "{OK}") + stream.toString();
        return bufferStr;
    }

    private Class getClassOrPrimitiveFromName(String name) throws ClassNotFoundException {
        Object value = TYPE_NAMES.get(name);
        if (value != null) {
            return (Class)value;
        }
        return this.getClassFromName(name);
    }

    private Class getClassFromName(String name) throws ClassNotFoundException {
        return Class.forName(name, false, ((Object)((Object)this)).getClass().getClassLoader());
    }

    private String[] getPackagePaths() {
        return new String[]{"com.google.gwt.user.client.rpc.core"};
    }

    private boolean isExpectedException(Method serviceIntfMethod, Throwable cause) {
        assert (serviceIntfMethod != null);
        assert (cause != null);
        Class<?>[] exceptionsThrown = serviceIntfMethod.getExceptionTypes();
        if (exceptionsThrown.length <= 0) {
            return false;
        }
        Class<?> causeType = cause.getClass();
        for (int index = 0; index < exceptionsThrown.length; ++index) {
            Class<?> exceptionThrown = exceptionsThrown[index];
            assert (exceptionThrown != null);
            if (!exceptionThrown.isAssignableFrom(causeType)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isImplementedRemoteServiceInterface(String intfName) {
        Set set = this.knownImplementedInterfaces;
        synchronized (set) {
            if (this.knownImplementedInterfaces.contains(intfName)) {
                return true;
            }
            for (Class<?> cls = ((Object)((Object)this)).getClass(); cls != null && !OpenRemoteServiceServlet.class.equals(cls); cls = cls.getSuperclass()) {
                Class<?>[] intfs = cls.getInterfaces();
                for (int i = 0; i < intfs.length; ++i) {
                    Class<?> intf = intfs[i];
                    if (!this.isImplementedRemoteServiceInterfaceRecursive(intfName, intf)) continue;
                    this.knownImplementedInterfaces.add(intfName);
                    return true;
                }
            }
            return false;
        }
    }

    private boolean isImplementedRemoteServiceInterfaceRecursive(String intfName, Class intfToCheck) {
        assert (intfToCheck.isInterface());
        if (intfToCheck.getName().equals(intfName)) {
            return RemoteService.class.isAssignableFrom(intfToCheck);
        }
        Class<?>[] intfs = intfToCheck.getInterfaces();
        for (int i = 0; i < intfs.length; ++i) {
            Class<?> intf = intfs[i];
            if (!this.isImplementedRemoteServiceInterfaceRecursive(intfName, intf)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readPayloadAsUtf8(HttpServletRequest request) throws IOException, ServletException {
        int contentLength = request.getContentLength();
        if (contentLength == -1) {
            throw new ServletException("Content-Length must be specified");
        }
        String contentType = request.getContentType();
        boolean contentTypeIsOkay = false;
        if (contentType != null && contentType.startsWith("text/plain")) {
            if (contentType.indexOf("charset=") == -1) {
                contentTypeIsOkay = true;
            } else if (contentType.indexOf("charset=utf-8") != -1) {
                contentTypeIsOkay = true;
            }
        }
        if (!contentTypeIsOkay) {
            throw new ServletException("Content-Type must be 'text/plain' with 'charset=utf-8' (or unspecified charset)");
        }
        ServletInputStream in = request.getInputStream();
        try {
            byte[] payload = new byte[contentLength];
            int offset = 0;
            int len = contentLength;
            while (offset < contentLength) {
                int byteCount = in.read(payload, offset, len);
                if (byteCount == -1) {
                    throw new ServletException("Client did not send " + contentLength + " bytes as expected");
                }
                offset += byteCount;
                len -= byteCount;
            }
            String string = new String(payload, CHARSET_UTF8);
            return string;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    protected void respondWithFailure(HttpServletResponse response, Throwable caught) {
        ServletContext servletContext = this.getServletContext();
        servletContext.log("Exception while dispatching incoming RPC call", caught);
        try {
            response.setContentType("text/plain");
            response.setStatus(500);
            response.getWriter().write(GENERIC_FAILURE_MSG);
        }
        catch (IOException e) {
            servletContext.log("sendError() failed while sending the previous failure to the client", caught);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeResponse(HttpServletRequest request, HttpServletResponse response, String responsePayload) throws IOException {
        byte[] reply = responsePayload.getBytes(CHARSET_UTF8);
        String contentType = CONTENT_TYPE_TEXT_PLAIN_UTF8;
        if (OpenRemoteServiceServlet.acceptsGzipEncoding(request) && this.shouldCompressResponse(request, response, responsePayload)) {
            ByteArrayOutputStream output = null;
            DeflaterOutputStream gzipOutputStream = null;
            IOException caught = null;
            try {
                output = new ByteArrayOutputStream(reply.length);
                gzipOutputStream = new GZIPOutputStream(output);
                gzipOutputStream.write(reply);
                ((GZIPOutputStream)gzipOutputStream).finish();
                gzipOutputStream.flush();
                response.setHeader(CONTENT_ENCODING, CONTENT_ENCODING_GZIP);
                reply = output.toByteArray();
            }
            catch (UnsupportedEncodingException e) {
                caught = e;
            }
            catch (IOException e) {
                caught = e;
            }
            finally {
                if (null != gzipOutputStream) {
                    gzipOutputStream.close();
                }
                if (null != output) {
                    output.close();
                }
            }
            if (caught != null) {
                this.getServletContext().log("Unable to compress response", (Throwable)caught);
                response.sendError(500);
                return;
            }
        }
        response.setContentLength(reply.length);
        response.setContentType(contentType);
        response.setStatus(200);
        response.getOutputStream().write(reply);
    }

    static {
        TYPE_NAMES.put("Z", Boolean.TYPE);
        TYPE_NAMES.put("B", Byte.TYPE);
        TYPE_NAMES.put("C", Character.TYPE);
        TYPE_NAMES.put("D", Double.TYPE);
        TYPE_NAMES.put("F", Float.TYPE);
        TYPE_NAMES.put("I", Integer.TYPE);
        TYPE_NAMES.put("J", Long.TYPE);
        TYPE_NAMES.put("S", Short.TYPE);
    }
}

