/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import javax.servlet.http.Cookie;
import org.mortbay.io.Buffer;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.jetty.client.HttpClient;
import org.mortbay.jetty.client.HttpConnection;
import org.mortbay.jetty.client.HttpExchange;
import org.mortbay.jetty.client.security.Authentication;
import org.mortbay.jetty.client.security.SecurityListener;
import org.mortbay.jetty.servlet.PathMap;
import org.mortbay.log.Log;

public class HttpDestination {
    private ByteArrayBuffer _hostHeader;
    private InetSocketAddress _address;
    private LinkedList<HttpConnection> _connections = new LinkedList();
    private ArrayList<HttpConnection> _idle = new ArrayList();
    private HttpClient _client;
    private boolean _ssl;
    private int _maxConnections;
    private int _pendingConnections = 0;
    private ArrayBlockingQueue<Object> _newQueue = new ArrayBlockingQueue(10, true);
    private int _newConnection = 0;
    private InetSocketAddress _proxy;
    private PathMap _authorizations;
    private List<Cookie> _cookies;
    private LinkedList<HttpExchange> _queue = new LinkedList();

    HttpDestination(HttpClient pool, InetSocketAddress address, boolean ssl, int maxConnections) {
        this._client = pool;
        this._address = address;
        this._ssl = ssl;
        this._maxConnections = maxConnections;
        String host = address.getHostName();
        if (address.getPort() != (this._ssl ? 443 : 80)) {
            host = host + ":" + address.getPort();
        }
        this._hostHeader = new ByteArrayBuffer(host);
    }

    public InetSocketAddress getAddress() {
        return this._address;
    }

    public Buffer getHostHeader() {
        return this._hostHeader;
    }

    public HttpClient getHttpClient() {
        return this._client;
    }

    public boolean isSecure() {
        return this._ssl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAuthorization(String pathSpec, Authentication authentication) {
        HttpDestination httpDestination = this;
        synchronized (httpDestination) {
            if (this._authorizations == null) {
                this._authorizations = new PathMap();
            }
            this._authorizations.put((Object)pathSpec, (Object)authentication);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCookie(Cookie cookie) {
        HttpDestination httpDestination = this;
        synchronized (httpDestination) {
            if (this._cookies == null) {
                this._cookies = new ArrayList<Cookie>();
            }
            this._cookies.add(cookie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpConnection getConnection() throws IOException {
        HttpConnection connection = this.getIdleConnection();
        while (connection == null) {
            HttpDestination httpDestination = this;
            synchronized (httpDestination) {
                ++this._newConnection;
                this.startNewConnection();
            }
            try {
                Object o = this._newQueue.take();
                if (o instanceof HttpConnection) {
                    connection = (HttpConnection)o;
                    continue;
                }
                throw (IOException)o;
            }
            catch (InterruptedException e) {
                Log.ignore((Throwable)e);
            }
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpConnection getIdleConnection() throws IOException {
        HttpDestination httpDestination = this;
        synchronized (httpDestination) {
            long now = System.currentTimeMillis();
            long idleTimeout = this._client.getIdleTimeout();
            while (this._idle.size() > 0) {
                HttpConnection connection = this._idle.remove(this._idle.size() - 1);
                long last = connection.getLast();
                if (connection.getEndPoint().isOpen() && (last == 0L || now - last < idleTimeout)) {
                    return connection;
                }
                this._connections.remove(connection);
                connection.getEndPoint().close();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startNewConnection() {
        try {
            HttpDestination httpDestination = this;
            synchronized (httpDestination) {
                ++this._pendingConnections;
            }
            this._client._connector.startConnection(this);
        }
        catch (Exception e) {
            this.onConnectionFailed(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnectionFailed(Throwable throwable) {
        Throwable connect_failure = null;
        HttpDestination httpDestination = this;
        synchronized (httpDestination) {
            --this._pendingConnections;
            if (this._newConnection > 0) {
                connect_failure = throwable;
                --this._newConnection;
            } else if (this._queue.size() > 0) {
                HttpExchange ex = this._queue.removeFirst();
                ex.getEventListener().onConnectionFailed(throwable);
            }
        }
        if (connect_failure != null) {
            try {
                this._newQueue.put(connect_failure);
            }
            catch (InterruptedException e) {
                Log.ignore((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onException(Throwable throwable) {
        HttpDestination httpDestination = this;
        synchronized (httpDestination) {
            --this._pendingConnections;
            if (this._queue.size() > 0) {
                HttpExchange ex = this._queue.removeFirst();
                ex.getEventListener().onException(throwable);
                ex.setStatus(9);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNewConnection(HttpConnection connection) throws IOException {
        HttpConnection q_connection = null;
        HttpDestination httpDestination = this;
        synchronized (httpDestination) {
            --this._pendingConnections;
            this._connections.add(connection);
            if (this._newConnection > 0) {
                q_connection = connection;
                --this._newConnection;
            } else if (this._queue.size() == 0) {
                this._idle.add(connection);
            } else {
                HttpExchange ex = this._queue.removeFirst();
                connection.send(ex);
            }
        }
        if (q_connection != null) {
            try {
                this._newQueue.put(q_connection);
            }
            catch (InterruptedException e) {
                Log.ignore((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnConnection(HttpConnection connection, boolean close) throws IOException {
        if (close) {
            try {
                connection.close();
            }
            catch (IOException e) {
                Log.ignore((Throwable)e);
            }
        }
        if (!this._client.isStarted()) {
            return;
        }
        if (!close && connection.getEndPoint().isOpen()) {
            HttpDestination httpDestination = this;
            synchronized (httpDestination) {
                if (this._queue.size() == 0) {
                    connection.setLast(System.currentTimeMillis());
                    this._idle.add(connection);
                } else {
                    HttpExchange ex = this._queue.removeFirst();
                    connection.send(ex);
                }
                this.notifyAll();
            }
        }
        HttpDestination httpDestination = this;
        synchronized (httpDestination) {
            this._connections.remove(connection);
            if (!this._queue.isEmpty()) {
                this.startNewConnection();
            }
        }
    }

    public void send(HttpExchange ex) throws IOException {
        if (this._client.hasRealms()) {
            ex.setEventListener(new SecurityListener(this, ex));
        }
        this.doSend(ex);
    }

    public void resend(HttpExchange ex) throws IOException {
        ex.getEventListener().onRetry();
        this.doSend(ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSend(HttpExchange ex) throws IOException {
        Authentication auth;
        if (this._cookies != null) {
            StringBuilder buf = null;
            for (Cookie cookie : this._cookies) {
                if (buf == null) {
                    buf = new StringBuilder();
                } else {
                    buf.append("; ");
                }
                buf.append(cookie.getName());
                buf.append("=");
                buf.append(cookie.getValue());
            }
            if (buf != null) {
                ex.addRequestHeader("Cookie", buf.toString());
            }
        }
        if (this._authorizations != null && (auth = (Authentication)this._authorizations.match(ex.getURI())) != null) {
            auth.setCredentials(ex);
        }
        HttpDestination httpDestination = this;
        synchronized (httpDestination) {
            HttpConnection connection = null;
            if (this._queue.size() > 0 || (connection = this.getIdleConnection()) == null || !connection.send(ex)) {
                this._queue.add(ex);
                if (this._connections.size() + this._pendingConnections < this._maxConnections) {
                    this.startNewConnection();
                }
            }
        }
    }

    public synchronized String toString() {
        return "HttpDestination@" + this.hashCode() + "//" + this._address.getHostName() + ":" + this._address.getPort() + "(" + this._connections.size() + "," + this._idle.size() + "," + this._queue.size() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String toDetailString() {
        StringBuilder b = new StringBuilder();
        b.append(this.toString());
        b.append('\n');
        HttpDestination httpDestination = this;
        synchronized (httpDestination) {
            for (HttpConnection connection : this._connections) {
                if (connection._exchange == null) continue;
                b.append(connection.toDetailString());
                if (this._idle.contains(connection)) {
                    b.append(" IDLE");
                }
                b.append('\n');
            }
        }
        b.append("--");
        b.append('\n');
        return b.toString();
    }

    public void setProxy(InetSocketAddress proxy) {
        this._proxy = proxy;
    }

    public InetSocketAddress getProxy() {
        return this._proxy;
    }

    public boolean isProxied() {
        return this._proxy != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        HttpDestination httpDestination = this;
        synchronized (httpDestination) {
            for (HttpConnection connection : this._connections) {
                connection.close();
            }
        }
    }
}

