/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.asyncblazeds;

import flex.messaging.FlexContext;
import flex.messaging.MessageException;
import flex.messaging.endpoints.amf.AMFFilter;
import flex.messaging.io.MessageSerializer;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.SerializationException;
import flex.messaging.io.amf.ASObject;
import flex.messaging.io.amf.ActionContext;
import flex.messaging.io.amf.ActionMessage;
import flex.messaging.io.amf.AmfTrace;
import flex.messaging.io.amf.MessageBody;
import flex.messaging.log.Log;
import flex.messaging.log.Logger;
import flex.messaging.messages.ErrorMessage;
import flex.messaging.messages.Message;
import flex.messaging.messages.MessagePerformanceInfo;
import flex.messaging.util.ExceptionUtil;
import flex.messaging.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.List;
import org.eclipse.jetty.continuation.ContinuationThrowable;

public class AsyncSerializationFilter
extends AMFFilter {
    private static final int UNHANDLED_ERROR = 10306;
    private static final int REQUEST_ERROR = 10307;
    private static final int RESPONSE_ERROR = 10308;
    private boolean isDebug = Log.isDebug();
    private Logger logger;

    public AsyncSerializationFilter(String logCategory) {
        if (logCategory == null) {
            logCategory = "Endpoint.General";
        }
        this.logger = Log.getLogger((String)logCategory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void invoke(ActionContext context) throws IOException {
        block51: {
            success = false;
            v0 = debugTrace = this.isDebug != false ? new AmfTrace() : null;
            if (context.getResponseMessage() == null) {
                context.setResponseMessage(new ActionMessage());
            }
            sc = SerializationContext.getSerializationContext();
            if (context.getRequestMessage() != null) {
                success = true;
            } else {
                try {
                    try {
                        deserializer = sc.newMessageDeserializer();
                        in = FlexContext.getHttpRequest().getInputStream();
                        deserializer.initialize(sc, (InputStream)in, debugTrace);
                        reqLen = FlexContext.getHttpRequest().getContentLength();
                        context.setDeserializedBytes(reqLen);
                        if (context.isMPIenabled()) {
                            mpi = new MessagePerformanceInfo();
                            mpi.recordMessageSizes = context.isRecordMessageSizes();
                            mpi.recordMessageTimes = context.isRecordMessageTimes();
                            if (context.isRecordMessageTimes()) {
                                mpi.receiveTime = System.currentTimeMillis();
                            }
                            if (context.isRecordMessageSizes()) {
                                mpi.messageSize = reqLen;
                            }
                            context.setMPII(mpi);
                        }
                        m = new ActionMessage();
                        context.setRequestMessage(m);
                        deserializer.readMessage(m, context);
                        success = true;
                    }
                    catch (EOFException eof) {
                        context.setStatus(2);
                        var10_16 = null;
                        respMsg = context.getResponseMessage();
                        respMsg.setVersion(context.getVersion());
                        if (this.isDebug) {
                            this.logger.debug(debugTrace.toString());
                        }
                        break block51;
                    }
                    catch (IOException exc) {
                        if (this.isDebug == false) throw exc;
                        this.logger.debug("IOException reading message - client closed socket before sending the message?");
                        throw exc;
                    }
                    catch (Throwable t) {
                        this.deserializationError(context, t);
                        var10_17 = null;
                        respMsg = context.getResponseMessage();
                        respMsg.setVersion(context.getVersion());
                        if (this.isDebug) {
                            this.logger.debug(debugTrace.toString());
                        }
                        break block51;
                    }
                    var10_15 = null;
                }
                catch (Throwable var9_23) {
                    var10_18 = null;
                    respMsg = context.getResponseMessage();
                    respMsg.setVersion(context.getVersion());
                    if (this.isDebug == false) throw var9_23;
                    this.logger.debug(debugTrace.toString());
                    throw var9_23;
                }
                respMsg = context.getResponseMessage();
                respMsg.setVersion(context.getVersion());
                if (this.isDebug) {
                    this.logger.debug(debugTrace.toString());
                }
            }
        }
        suspended = false;
        try {
            try {
                if (success) {
                    this.next.invoke(context);
                }
                ** GOTO lbl133
            }
            catch (ContinuationThrowable ct) {
                suspended = true;
                throw ct;
            }
            catch (Throwable t) {
                this.unhandledError(context, t);
                var13_25 = null;
                if (suspended != false) return;
                if (context.getStatus() == 2) return;
                outBuffer = new ByteArrayOutputStream();
                respMesg = context.getResponseMessage();
                if (this.isDebug) {
                    debugTrace = new AmfTrace();
                }
                try {
                    try {
                        block52: {
                            serializationOverhead = 0L;
                            if (context.isRecordMessageTimes()) {
                                context.getMPIO().sendTime = System.currentTimeMillis();
                                if (context.isRecordMessageSizes()) {
                                    serializationOverhead = System.currentTimeMillis();
                                }
                            }
                            serializer = sc.newMessageSerializer();
                            serializer.initialize(sc, (OutputStream)outBuffer, debugTrace);
                            serializer.writeMessage(respMesg);
                            context.setSerializedBytes(outBuffer.size());
                            if (context.isRecordMessageSizes()) {
                                try {
                                    context.getMPIO().messageSize = outBuffer.size();
                                    if (context.isRecordMessageTimes()) {
                                        serializationOverhead = System.currentTimeMillis() - serializationOverhead;
                                        context.getMPIO().addToOverhead(serializationOverhead);
                                        context.getMPIO().sendTime = System.currentTimeMillis();
                                    }
                                    outBuffer = new ByteArrayOutputStream();
                                    respMesg = context.getResponseMessage();
                                    serializer = sc.newMessageSerializer();
                                    serializer.initialize(sc, (OutputStream)outBuffer, debugTrace);
                                    serializer.writeMessage(respMesg);
                                }
                                catch (Exception e) {
                                    if (!this.isDebug) break block52;
                                    this.logger.debug("MPI set up error: " + e.toString());
                                }
                            }
                        }
                        context.setResponseOutput(outBuffer);
                    }
                    catch (Exception e) {
                        this.serializationError(context, e);
                        var21_49 = null;
                        if (this.isDebug == false) return;
                        this.logger.debug(debugTrace.toString());
                        return;
                    }
                    var21_48 = null;
                    if (this.isDebug == false) return;
                }
                catch (Throwable var20_55) {
                    var21_50 = null;
                    if (this.isDebug == false) throw var20_55;
                    this.logger.debug(debugTrace.toString());
                    throw var20_55;
                }
lbl133:
                // 1 sources

                var13_24 = null;
                if (suspended != false) return;
                ** GOTO lbl192
                this.logger.debug(debugTrace.toString());
                return;
            }
        }
        catch (Throwable var12_57) {
            block55: {
                block56: {
                    block54: {
                        block53: {
                            var13_26 = null;
                            if (suspended != false) throw var12_57;
                            if (context.getStatus() == 2) throw var12_57;
                            outBuffer = new ByteArrayOutputStream();
                            respMesg = context.getResponseMessage();
                            if (this.isDebug) {
                                debugTrace = new AmfTrace();
                            }
                            ** try [egrp 4[TRYBLOCK] [14 : 395->630)] { 
lbl148:
                            // 1 sources

                            ** try [egrp 5[TRYBLOCK] [13 : 395->609)] { 
lbl149:
                            // 1 sources

                            serializationOverhead = 0L;
                            if (context.isRecordMessageTimes()) {
                                context.getMPIO().sendTime = System.currentTimeMillis();
                                if (context.isRecordMessageSizes()) {
                                    serializationOverhead = System.currentTimeMillis();
                                }
                            }
                            serializer = sc.newMessageSerializer();
                            serializer.initialize(sc, (OutputStream)outBuffer, debugTrace);
                            serializer.writeMessage(respMesg);
                            context.setSerializedBytes(outBuffer.size());
                            if (!context.isRecordMessageSizes()) break block53;
                            try {}
                            catch (Exception e) {
                                if (this.isDebug) {
                                    this.logger.debug("MPI set up error: " + e.toString());
                                }
                                break block53;
                            }
                            context.getMPIO().messageSize = outBuffer.size();
                            if (context.isRecordMessageTimes()) {
                                serializationOverhead = System.currentTimeMillis() - serializationOverhead;
                                context.getMPIO().addToOverhead(serializationOverhead);
                                context.getMPIO().sendTime = System.currentTimeMillis();
                            }
                            outBuffer = new ByteArrayOutputStream();
                            respMesg = context.getResponseMessage();
                            serializer = sc.newMessageSerializer();
                            serializer.initialize(sc, (OutputStream)outBuffer, debugTrace);
                            serializer.writeMessage(respMesg);
                            break block53;
lbl176:
                            // 1 sources

                            catch (Exception e) {
                                this.serializationError(context, e);
                                var21_52 = null;
                                if (this.isDebug == false) throw var12_57;
                                this.logger.debug(debugTrace.toString());
                                throw var12_57;
                            }
                        }
                        context.setResponseOutput(outBuffer);
                        break block55;
lbl186:
                        // 1 sources

                        catch (Throwable var20_56) {
                            var21_53 = null;
                            if (this.isDebug == false) throw var20_56;
                            this.logger.debug(debugTrace.toString());
                            throw var20_56;
                        }
lbl192:
                        // 1 sources

                        if (context.getStatus() == 2) return;
                        outBuffer = new ByteArrayOutputStream();
                        respMesg = context.getResponseMessage();
                        if (this.isDebug) {
                            debugTrace = new AmfTrace();
                        }
                        ** try [egrp 4[TRYBLOCK] [14 : 395->630)] { 
lbl198:
                        // 1 sources

                        ** try [egrp 5[TRYBLOCK] [13 : 395->609)] { 
lbl199:
                        // 1 sources

                        serializationOverhead = 0L;
                        if (context.isRecordMessageTimes()) {
                            context.getMPIO().sendTime = System.currentTimeMillis();
                            if (context.isRecordMessageSizes()) {
                                serializationOverhead = System.currentTimeMillis();
                            }
                        }
                        serializer = sc.newMessageSerializer();
                        serializer.initialize(sc, (OutputStream)outBuffer, debugTrace);
                        serializer.writeMessage(respMesg);
                        context.setSerializedBytes(outBuffer.size());
                        if (!context.isRecordMessageSizes()) break block54;
                        try {}
                        catch (Exception e) {
                            if (this.isDebug) {
                                this.logger.debug("MPI set up error: " + e.toString());
                            }
                            break block54;
                        }
                        context.getMPIO().messageSize = outBuffer.size();
                        if (context.isRecordMessageTimes()) {
                            serializationOverhead = System.currentTimeMillis() - serializationOverhead;
                            context.getMPIO().addToOverhead(serializationOverhead);
                            context.getMPIO().sendTime = System.currentTimeMillis();
                        }
                        outBuffer = new ByteArrayOutputStream();
                        respMesg = context.getResponseMessage();
                        serializer = sc.newMessageSerializer();
                        serializer.initialize(sc, (OutputStream)outBuffer, debugTrace);
                        serializer.writeMessage(respMesg);
                        break block54;
lbl226:
                        // 1 sources

                        catch (Exception e) {
                            this.serializationError(context, e);
                            var21_46 = null;
                            if (this.isDebug == false) return;
                            this.logger.debug(debugTrace.toString());
                            return;
                        }
                    }
                    context.setResponseOutput(outBuffer);
                    break block56;
lbl236:
                    // 1 sources

                    catch (Throwable var20_54) {
                        var21_47 = null;
                        if (this.isDebug == false) throw var20_54;
                        this.logger.debug(debugTrace.toString());
                        throw var20_54;
                    }
                }
                var21_45 = null;
                if (this.isDebug == false) return;
                this.logger.debug(debugTrace.toString());
                return;
            }
            var21_51 = null;
            if (this.isDebug == false) throw var12_57;
            this.logger.debug(debugTrace.toString());
            throw var12_57;
        }
    }

    private void deserializationError(ActionContext context, Throwable t) {
        String message;
        MessageException methodResult;
        context.setStatus(1);
        MessageBody responseBody = new MessageBody();
        if (context.getMessageNumber() < context.getRequestMessage().getBodyCount()) {
            responseBody.setTargetURI(context.getRequestMessageBody().getResponseURI());
        }
        if (context.getVersion() == 0) {
            context.setVersion(3);
        }
        context.getResponseMessage().addBody(responseBody);
        if (t instanceof MessageException) {
            methodResult = (MessageException)t;
            message = methodResult.getMessage();
        } else {
            methodResult = new SerializationException();
            methodResult.setMessage(10307);
            methodResult.setRootCause(t);
            message = methodResult.getMessage();
        }
        responseBody.setData((Object)methodResult.createErrorMessage());
        responseBody.setReplyMethod("/onStatus");
        if (Log.isError()) {
            this.logger.error(message + StringUtils.NEWLINE + ExceptionUtil.toString((Throwable)t));
        }
    }

    private void unhandledError(ActionContext context, Throwable t) {
        MessageException methodResult;
        ActionMessage responseMessage = new ActionMessage();
        context.setResponseMessage(responseMessage);
        MessageBody responseBody = new MessageBody();
        responseBody.setTargetURI(context.getRequestMessageBody().getResponseURI());
        context.getResponseMessage().addBody(responseBody);
        if (t instanceof MessageException) {
            methodResult = (MessageException)t;
        } else {
            methodResult = new SerializationException();
            methodResult.setMessage(10306);
            methodResult.setRootCause(t);
        }
        responseBody.setData((Object)methodResult);
        responseBody.setReplyMethod("/onStatus");
        this.logger.info(t.getMessage());
    }

    private void serializationError(ActionContext context, Throwable t) {
        ActionMessage responseMessage = new ActionMessage();
        context.setResponseMessage(responseMessage);
        int bodyCount = context.getRequestMessage().getBodyCount();
        context.setMessageNumber(0);
        while (context.getMessageNumber() < bodyCount) {
            Object methodResult;
            MessageBody responseBody = new MessageBody();
            responseBody.setTargetURI(context.getRequestMessageBody().getResponseURI());
            context.getResponseMessage().addBody(responseBody);
            if (t instanceof MessageException) {
                methodResult = ((MessageException)t).createErrorMessage();
            } else {
                String message = "An error occurred while serializing server response(s).";
                if (t.getMessage() != null && (message = t.getMessage()) == null) {
                    message = t.toString();
                }
                methodResult = new MessageException(message, t).createErrorMessage();
            }
            if (context.isLegacy()) {
                if (methodResult instanceof ErrorMessage) {
                    ErrorMessage error = methodResult;
                    ASObject aso = new ASObject();
                    aso.put((Object)"message", (Object)error.faultString);
                    aso.put((Object)"code", (Object)error.faultCode);
                    aso.put((Object)"details", (Object)error.faultDetail);
                    aso.put((Object)"rootCause", error.rootCause);
                    methodResult = aso;
                } else if (methodResult instanceof Message) {
                    methodResult = ((Message)methodResult).getBody();
                }
            } else {
                Object data = context.getRequestMessageBody().getData();
                if (data instanceof List) {
                    data = ((List)data).get(0);
                } else if (data.getClass().isArray()) {
                    data = Array.get(data, 0);
                }
                if (data instanceof Message) {
                    Message inMessage = (Message)data;
                    if (inMessage.getClientId() != null) {
                        methodResult.setClientId((Object)inMessage.getClientId().toString());
                    }
                    if (inMessage.getMessageId() != null) {
                        methodResult.setCorrelationId(inMessage.getMessageId());
                        methodResult.setDestination(inMessage.getDestination());
                    }
                }
            }
            responseBody.setData(methodResult);
            responseBody.setReplyMethod("/onStatus");
            context.incrementMessageNumber();
        }
        if (Log.isError()) {
            this.logger.error("Exception occurred during serialization: " + ExceptionUtil.toString((Throwable)t));
        }
        SerializationContext sc = SerializationContext.getSerializationContext();
        MessageSerializer serializer = sc.newMessageSerializer();
        ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
        AmfTrace debugTrace = this.isDebug ? new AmfTrace() : null;
        serializer.initialize(sc, (OutputStream)outBuffer, debugTrace);
        try {
            serializer.writeMessage(context.getResponseMessage());
            context.setResponseOutput(outBuffer);
        }
        catch (IOException e) {
            MessageException ex = new MessageException();
            ex.setMessage(10308);
            ex.setRootCause((Throwable)e);
            throw ex;
        }
    }
}

