/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.asyncblazeds;

import flex.messaging.endpoints.amf.AMFFilter;
import flex.messaging.io.RecoverableSerializationException;
import flex.messaging.io.amf.ActionContext;
import flex.messaging.io.amf.MessageBody;
import org.eclipse.jetty.continuation.ContinuationThrowable;

public class AsyncBatchProcessFilter
extends AMFFilter {
    public void invoke(ActionContext context) {
        int bodyCount = context.getRequestMessage().getBodyCount();
        while (context.getMessageNumber() < bodyCount) {
            try {
                Object o;
                int responses = context.getResponseMessage().getBodyCount();
                if (responses == context.getMessageNumber()) {
                    MessageBody responseBody = new MessageBody();
                    responseBody.setTargetURI(context.getRequestMessageBody().getResponseURI());
                    context.getResponseMessage().addBody(responseBody);
                }
                if ((o = context.getRequestMessageBody().getData()) != null && o instanceof RecoverableSerializationException) {
                    context.getResponseMessageBody().setData((Object)((RecoverableSerializationException)o).createErrorMessage());
                    context.getResponseMessageBody().setReplyMethod("/onStatus");
                    context.incrementMessageNumber();
                    continue;
                }
                this.next.invoke(context);
                context.incrementMessageNumber();
            }
            catch (ContinuationThrowable ct) {
                throw ct;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

