/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.asyncblazeds;

import flex.management.BaseControl;
import flex.messaging.MessageBroker;
import flex.messaging.endpoints.AbstractEndpoint;
import flex.messaging.endpoints.amf.AMFFilter;
import org.mortbay.jetty.asyncblazeds.AsyncAMFEndpointControl;
import org.mortbay.jetty.asyncblazeds.AsyncBatchProcessFilter;
import org.mortbay.jetty.asyncblazeds.AsyncLegacyFilter;
import org.mortbay.jetty.asyncblazeds.AsyncMessageBrokerFilter;
import org.mortbay.jetty.asyncblazeds.AsyncSerializationFilter;
import org.mortbay.jetty.asyncblazeds.AsyncSessionFilter;
import org.mortbay.jetty.asyncblazeds.BaseAsyncHTTPEndpoint;

public class AsyncAMFEndpoint
extends BaseAsyncHTTPEndpoint {
    public static final String LOG_CATEGORY = "Endpoint.AMF";

    public AsyncAMFEndpoint() {
        this(false);
    }

    public AsyncAMFEndpoint(boolean enableManagement) {
        super(enableManagement);
    }

    protected AMFFilter createFilterChain() {
        AsyncSerializationFilter serializationFilter = new AsyncSerializationFilter(this.getLogCategory());
        AsyncBatchProcessFilter batchFilter = new AsyncBatchProcessFilter();
        AsyncSessionFilter sessionFilter = new AsyncSessionFilter();
        AsyncLegacyFilter envelopeFilter = new AsyncLegacyFilter(this);
        AsyncMessageBrokerFilter messageBrokerFilter = new AsyncMessageBrokerFilter((AbstractEndpoint)this);
        serializationFilter.setNext(batchFilter);
        batchFilter.setNext(sessionFilter);
        sessionFilter.setNext(envelopeFilter);
        envelopeFilter.setNext(messageBrokerFilter);
        return serializationFilter;
    }

    protected String getResponseContentType() {
        return "application/x-amf";
    }

    protected String getLogCategory() {
        return LOG_CATEGORY;
    }

    protected String getDeserializerClassName() {
        return "flex.messaging.io.amf.AmfMessageDeserializer";
    }

    protected String getSerializerClassName() {
        return "flex.messaging.io.amf.AmfMessageSerializer";
    }

    protected String getSerializerJava15ClassName() {
        return "flex.messaging.io.amf.Java15AmfMessageSerializer";
    }

    protected void setupEndpointControl(MessageBroker broker) {
        this.controller = new AsyncAMFEndpointControl(this, broker.getControl());
        this.controller.register();
        this.setControl((BaseControl)this.controller);
    }
}

