/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.asyncblazeds;

import flex.messaging.FlexContext;
import flex.messaging.MessageException;
import flex.messaging.endpoints.amf.AMFFilter;
import flex.messaging.io.MessageDeserializer;
import flex.messaging.io.MessageSerializer;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.SerializationException;
import flex.messaging.io.amf.ASObject;
import flex.messaging.io.amf.ActionContext;
import flex.messaging.io.amf.ActionMessage;
import flex.messaging.io.amf.AmfTrace;
import flex.messaging.io.amf.MessageBody;
import flex.messaging.log.Log;
import flex.messaging.log.Logger;
import flex.messaging.messages.ErrorMessage;
import flex.messaging.messages.Message;
import flex.messaging.messages.MessagePerformanceInfo;
import flex.messaging.util.ExceptionUtil;
import flex.messaging.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.List;
import javax.servlet.ServletInputStream;
import org.eclipse.jetty.continuation.ContinuationThrowable;

public class AsyncSerializationFilter
extends AMFFilter {
    private static final int UNHANDLED_ERROR = 10306;
    private static final int REQUEST_ERROR = 10307;
    private static final int RESPONSE_ERROR = 10308;
    private boolean isDebug = Log.isDebug();
    private Logger logger;

    public AsyncSerializationFilter(String logCategory) {
        if (logCategory == null) {
            logCategory = "Endpoint.General";
        }
        this.logger = Log.getLogger((String)logCategory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void invoke(ActionContext context) throws IOException {
        boolean suspended;
        SerializationContext sc;
        AmfTrace debugTrace;
        block48: {
            boolean success;
            block47: {
                success = false;
                AmfTrace amfTrace = debugTrace = this.isDebug ? new AmfTrace() : null;
                if (context.getResponseMessage() == null) {
                    context.setResponseMessage(new ActionMessage());
                }
                sc = SerializationContext.getSerializationContext();
                if (context.getRequestMessage() != null) {
                    success = true;
                } else {
                    MessageDeserializer deserializer = sc.newMessageDeserializer();
                    ServletInputStream in = FlexContext.getHttpRequest().getInputStream();
                    deserializer.initialize(sc, (InputStream)in, debugTrace);
                    int reqLen = FlexContext.getHttpRequest().getContentLength();
                    context.setDeserializedBytes(reqLen);
                    if (context.isMPIenabled()) {
                        MessagePerformanceInfo mpi = new MessagePerformanceInfo();
                        mpi.recordMessageSizes = context.isRecordMessageSizes();
                        mpi.recordMessageTimes = context.isRecordMessageTimes();
                        if (context.isRecordMessageTimes()) {
                            mpi.receiveTime = System.currentTimeMillis();
                        }
                        if (context.isRecordMessageSizes()) {
                            mpi.messageSize = reqLen;
                        }
                        context.setMPII(mpi);
                    }
                    ActionMessage m = new ActionMessage();
                    context.setRequestMessage(m);
                    deserializer.readMessage(m, context);
                    success = true;
                    Object var10_15 = null;
                    ActionMessage respMsg = context.getResponseMessage();
                    respMsg.setVersion(context.getVersion());
                    if (this.isDebug) {
                        this.logger.debug(debugTrace.toString());
                    }
                }
                break block47;
                {
                    catch (EOFException eof) {
                        context.setStatus(2);
                        Object var10_16 = null;
                        ActionMessage respMsg = context.getResponseMessage();
                        respMsg.setVersion(context.getVersion());
                        if (this.isDebug) {
                            this.logger.debug(debugTrace.toString());
                        }
                        break block47;
                    }
                    catch (IOException exc) {
                        if (!this.isDebug) throw exc;
                        this.logger.debug("IOException reading message - client closed socket before sending the message?");
                        throw exc;
                    }
                    catch (Throwable t) {
                        this.deserializationError(context, t);
                        Object var10_17 = null;
                        ActionMessage respMsg = context.getResponseMessage();
                        respMsg.setVersion(context.getVersion());
                        if (this.isDebug) {
                            this.logger.debug(debugTrace.toString());
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var10_18 = null;
                    ActionMessage respMsg = context.getResponseMessage();
                    respMsg.setVersion(context.getVersion());
                    if (!this.isDebug) throw throwable;
                    this.logger.debug(debugTrace.toString());
                    throw throwable;
                }
            }
            suspended = false;
            if (!success) break block48;
            this.next.invoke(context);
        }
        Object var13_24 = null;
        if (suspended || context.getStatus() == 2) return;
        ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
        ActionMessage respMesg = context.getResponseMessage();
        if (this.isDebug) {
            debugTrace = new AmfTrace();
        }
        try {
            block49: {
                long serializationOverhead = 0L;
                if (context.isRecordMessageTimes()) {
                    context.getMPIO().sendTime = System.currentTimeMillis();
                    if (context.isRecordMessageSizes()) {
                        serializationOverhead = System.currentTimeMillis();
                    }
                }
                MessageSerializer serializer = sc.newMessageSerializer();
                serializer.initialize(sc, (OutputStream)outBuffer, debugTrace);
                serializer.writeMessage(respMesg);
                context.setSerializedBytes(outBuffer.size());
                if (context.isRecordMessageSizes()) {
                    try {
                        context.getMPIO().messageSize = outBuffer.size();
                        if (context.isRecordMessageTimes()) {
                            serializationOverhead = System.currentTimeMillis() - serializationOverhead;
                            context.getMPIO().addToOverhead(serializationOverhead);
                            context.getMPIO().sendTime = System.currentTimeMillis();
                        }
                        outBuffer = new ByteArrayOutputStream();
                        respMesg = context.getResponseMessage();
                        serializer = sc.newMessageSerializer();
                        serializer.initialize(sc, (OutputStream)outBuffer, debugTrace);
                        serializer.writeMessage(respMesg);
                    }
                    catch (Exception e) {
                        if (!this.isDebug) break block49;
                        this.logger.debug("MPI set up error: " + e.toString());
                    }
                }
            }
            context.setResponseOutput(outBuffer);
            Object var21_45 = null;
            if (!this.isDebug) return;
        }
        catch (Throwable throwable) {
            Object var21_47 = null;
            if (!this.isDebug) throw throwable;
            this.logger.debug(debugTrace.toString());
            throw throwable;
        }
        this.logger.debug(debugTrace.toString());
        {
            return;
            catch (Exception e) {
                this.serializationError(context, e);
                Object var21_46 = null;
                if (!this.isDebug) return;
                this.logger.debug(debugTrace.toString());
                return;
            }
        }
        {
            catch (ContinuationThrowable ct) {
                suspended = true;
                throw ct;
            }
            catch (Throwable t) {
                this.unhandledError(context, t);
                Object var13_25 = null;
                if (suspended) return;
                if (context.getStatus() == 2) return;
                outBuffer = new ByteArrayOutputStream();
                respMesg = context.getResponseMessage();
                if (this.isDebug) {
                    debugTrace = new AmfTrace();
                }
                try {
                    block50: {
                        long serializationOverhead = 0L;
                        if (context.isRecordMessageTimes()) {
                            context.getMPIO().sendTime = System.currentTimeMillis();
                            if (context.isRecordMessageSizes()) {
                                serializationOverhead = System.currentTimeMillis();
                            }
                        }
                        MessageSerializer serializer = sc.newMessageSerializer();
                        serializer.initialize(sc, (OutputStream)outBuffer, debugTrace);
                        serializer.writeMessage(respMesg);
                        context.setSerializedBytes(outBuffer.size());
                        if (context.isRecordMessageSizes()) {
                            try {
                                context.getMPIO().messageSize = outBuffer.size();
                                if (context.isRecordMessageTimes()) {
                                    serializationOverhead = System.currentTimeMillis() - serializationOverhead;
                                    context.getMPIO().addToOverhead(serializationOverhead);
                                    context.getMPIO().sendTime = System.currentTimeMillis();
                                }
                                outBuffer = new ByteArrayOutputStream();
                                respMesg = context.getResponseMessage();
                                serializer = sc.newMessageSerializer();
                                serializer.initialize(sc, (OutputStream)outBuffer, debugTrace);
                                serializer.writeMessage(respMesg);
                            }
                            catch (Exception e) {
                                if (!this.isDebug) break block50;
                                this.logger.debug("MPI set up error: " + e.toString());
                            }
                        }
                    }
                    context.setResponseOutput(outBuffer);
                    Object var21_48 = null;
                    if (!this.isDebug) return;
                }
                catch (Throwable throwable) {
                    Object var21_50 = null;
                    if (!this.isDebug) throw throwable;
                    this.logger.debug(debugTrace.toString());
                    throw throwable;
                }
                this.logger.debug(debugTrace.toString());
                {
                    return;
                    catch (Exception e) {
                        this.serializationError(context, e);
                        Object var21_49 = null;
                        if (!this.isDebug) return;
                        this.logger.debug(debugTrace.toString());
                        return;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Object var13_26 = null;
            if (suspended || context.getStatus() == 2) throw throwable;
            outBuffer = new ByteArrayOutputStream();
            respMesg = context.getResponseMessage();
            if (this.isDebug) {
                debugTrace = new AmfTrace();
            }
            try {
                block51: {
                    long serializationOverhead = 0L;
                    if (context.isRecordMessageTimes()) {
                        context.getMPIO().sendTime = System.currentTimeMillis();
                        if (context.isRecordMessageSizes()) {
                            serializationOverhead = System.currentTimeMillis();
                        }
                    }
                    MessageSerializer serializer = sc.newMessageSerializer();
                    serializer.initialize(sc, (OutputStream)outBuffer, debugTrace);
                    serializer.writeMessage(respMesg);
                    context.setSerializedBytes(outBuffer.size());
                    if (context.isRecordMessageSizes()) {
                        try {
                            context.getMPIO().messageSize = outBuffer.size();
                            if (context.isRecordMessageTimes()) {
                                serializationOverhead = System.currentTimeMillis() - serializationOverhead;
                                context.getMPIO().addToOverhead(serializationOverhead);
                                context.getMPIO().sendTime = System.currentTimeMillis();
                            }
                            outBuffer = new ByteArrayOutputStream();
                            respMesg = context.getResponseMessage();
                            serializer = sc.newMessageSerializer();
                            serializer.initialize(sc, (OutputStream)outBuffer, debugTrace);
                            serializer.writeMessage(respMesg);
                        }
                        catch (Exception e) {
                            if (!this.isDebug) break block51;
                            this.logger.debug("MPI set up error: " + e.toString());
                        }
                    }
                }
                context.setResponseOutput(outBuffer);
                Object var21_51 = null;
                if (!this.isDebug) throw throwable;
            }
            catch (Throwable throwable2) {
                Object var21_53 = null;
                if (!this.isDebug) throw throwable2;
                this.logger.debug(debugTrace.toString());
                throw throwable2;
            }
            this.logger.debug(debugTrace.toString());
            {
                throw throwable;
                catch (Exception e) {
                    this.serializationError(context, e);
                    Object var21_52 = null;
                    if (!this.isDebug) throw throwable;
                    this.logger.debug(debugTrace.toString());
                    throw throwable;
                }
            }
        }
    }

    private void deserializationError(ActionContext context, Throwable t) {
        String message;
        MessageException methodResult;
        context.setStatus(1);
        MessageBody responseBody = new MessageBody();
        if (context.getMessageNumber() < context.getRequestMessage().getBodyCount()) {
            responseBody.setTargetURI(context.getRequestMessageBody().getResponseURI());
        }
        if (context.getVersion() == 0) {
            context.setVersion(3);
        }
        context.getResponseMessage().addBody(responseBody);
        if (t instanceof MessageException) {
            methodResult = (MessageException)t;
            message = methodResult.getMessage();
        } else {
            methodResult = new SerializationException();
            methodResult.setMessage(10307);
            methodResult.setRootCause(t);
            message = methodResult.getMessage();
        }
        responseBody.setData((Object)methodResult.createErrorMessage());
        responseBody.setReplyMethod("/onStatus");
        if (Log.isError()) {
            this.logger.error(message + StringUtils.NEWLINE + ExceptionUtil.toString((Throwable)t));
        }
    }

    private void unhandledError(ActionContext context, Throwable t) {
        MessageException methodResult;
        ActionMessage responseMessage = new ActionMessage();
        context.setResponseMessage(responseMessage);
        MessageBody responseBody = new MessageBody();
        responseBody.setTargetURI(context.getRequestMessageBody().getResponseURI());
        context.getResponseMessage().addBody(responseBody);
        if (t instanceof MessageException) {
            methodResult = (MessageException)t;
        } else {
            methodResult = new SerializationException();
            methodResult.setMessage(10306);
            methodResult.setRootCause(t);
        }
        responseBody.setData((Object)methodResult);
        responseBody.setReplyMethod("/onStatus");
        this.logger.info(t.getMessage());
    }

    private void serializationError(ActionContext context, Throwable t) {
        ActionMessage responseMessage = new ActionMessage();
        context.setResponseMessage(responseMessage);
        int bodyCount = context.getRequestMessage().getBodyCount();
        context.setMessageNumber(0);
        while (context.getMessageNumber() < bodyCount) {
            Object methodResult;
            MessageBody responseBody = new MessageBody();
            responseBody.setTargetURI(context.getRequestMessageBody().getResponseURI());
            context.getResponseMessage().addBody(responseBody);
            if (t instanceof MessageException) {
                methodResult = ((MessageException)t).createErrorMessage();
            } else {
                String message = "An error occurred while serializing server response(s).";
                if (t.getMessage() != null && (message = t.getMessage()) == null) {
                    message = t.toString();
                }
                methodResult = new MessageException(message, t).createErrorMessage();
            }
            if (context.isLegacy()) {
                if (methodResult instanceof ErrorMessage) {
                    ErrorMessage error = methodResult;
                    ASObject aso = new ASObject();
                    aso.put((Object)"message", (Object)error.faultString);
                    aso.put((Object)"code", (Object)error.faultCode);
                    aso.put((Object)"details", (Object)error.faultDetail);
                    aso.put((Object)"rootCause", error.rootCause);
                    methodResult = aso;
                } else if (methodResult instanceof Message) {
                    methodResult = ((Message)methodResult).getBody();
                }
            } else {
                Object data = context.getRequestMessageBody().getData();
                if (data instanceof List) {
                    data = ((List)data).get(0);
                } else if (data.getClass().isArray()) {
                    data = Array.get(data, 0);
                }
                if (data instanceof Message) {
                    Message inMessage = (Message)data;
                    if (inMessage.getClientId() != null) {
                        methodResult.setClientId((Object)inMessage.getClientId().toString());
                    }
                    if (inMessage.getMessageId() != null) {
                        methodResult.setCorrelationId(inMessage.getMessageId());
                        methodResult.setDestination(inMessage.getDestination());
                    }
                }
            }
            responseBody.setData(methodResult);
            responseBody.setReplyMethod("/onStatus");
            context.incrementMessageNumber();
        }
        if (Log.isError()) {
            this.logger.error("Exception occurred during serialization: " + ExceptionUtil.toString((Throwable)t));
        }
        SerializationContext sc = SerializationContext.getSerializationContext();
        MessageSerializer serializer = sc.newMessageSerializer();
        ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
        AmfTrace debugTrace = this.isDebug ? new AmfTrace() : null;
        serializer.initialize(sc, (OutputStream)outBuffer, debugTrace);
        try {
            serializer.writeMessage(context.getResponseMessage());
            context.setResponseOutput(outBuffer);
        }
        catch (IOException e) {
            MessageException ex = new MessageException();
            ex.setMessage(10308);
            ex.setRootCause((Throwable)e);
            throw ex;
        }
    }
}

