/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.asyncblazeds;

import flex.messaging.FlexContext;
import flex.messaging.FlexSession;
import flex.messaging.MessageException;
import flex.messaging.endpoints.AbstractEndpoint;
import flex.messaging.endpoints.amf.AMFFilter;
import flex.messaging.io.amf.ActionContext;
import flex.messaging.io.amf.MessageBody;
import flex.messaging.log.Log;
import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.ErrorMessage;
import flex.messaging.messages.Message;
import flex.messaging.messages.MessagePerformanceUtils;
import flex.messaging.util.ExceptionUtil;
import flex.messaging.util.StringUtils;
import flex.messaging.util.UUIDUtils;
import java.lang.reflect.Array;
import java.util.List;
import org.eclipse.jetty.continuation.ContinuationThrowable;

public class AsyncMessageBrokerFilter
extends AMFFilter {
    private static final int UNHANDLED_ERROR = 10000;
    static final String LOG_CATEGORY = "Message.General";
    protected AbstractEndpoint endpoint;

    public AsyncMessageBrokerFilter(AbstractEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void invoke(ActionContext context) {
        FlexSession session22;
        MessageBody request = context.getRequestMessageBody();
        MessageBody response = context.getResponseMessageBody();
        Object data = request.getData();
        if (data instanceof List) {
            data = ((List)data).get(0);
        } else if (data.getClass().isArray()) {
            data = Array.get(data, 0);
        }
        if (!(data instanceof Message)) throw new MessageException("Request was not of type flex.messaging.messages.Message");
        Message inMessage = (Message)data;
        ErrorMessage outMessage = null;
        String replyMethodName = "/onStatus";
        boolean suspended = false;
        try {
            try {
                CommandMessage command;
                this.endpoint.setupFlexClient(inMessage);
                if (!(inMessage.getClientId() != null || inMessage instanceof CommandMessage && ((CommandMessage)inMessage).getOperation() == 2)) {
                    String clientId = UUIDUtils.createUUID();
                    inMessage.setClientId((Object)clientId);
                }
                if (inMessage instanceof CommandMessage && (command = (CommandMessage)inMessage).getOperation() == 2 && context.getRequestMessage().getBodyCount() != 1) {
                    command.setHeader("DSSuppressPollWait", (Object)Boolean.TRUE);
                }
                if (context.isMPIenabled()) {
                    MessagePerformanceUtils.setupMPII((ActionContext)context, (Message)inMessage);
                }
                if ((outMessage = this.endpoint.serviceMessage(inMessage)) instanceof ErrorMessage) {
                    context.setStatus(1);
                    replyMethodName = "/onStatus";
                }
                replyMethodName = "/onResult";
            }
            catch (MessageException e) {
                FlexSession session22;
                context.setStatus(1);
                replyMethodName = "/onStatus";
                outMessage = e.createErrorMessage();
                outMessage.setCorrelationId(inMessage.getMessageId());
                outMessage.setDestination(inMessage.getDestination());
                outMessage.setClientId(inMessage.getClientId());
                e.logAtHingePoint(inMessage, outMessage, null);
                Object var13_14 = null;
                if (suspended) return;
                if (context.isRecordMessageSizes() || context.isRecordMessageTimes()) {
                    MessagePerformanceUtils.updateOutgoingMPI((ActionContext)context, (Message)inMessage, (Object)outMessage);
                }
                if ((session22 = FlexContext.getFlexSession()) != null && session22.useSmallMessages() && !context.isLegacy() && context.getVersion() >= 3 && outMessage instanceof Message) {
                    outMessage = this.endpoint.convertToSmallMessage((Message)outMessage);
                }
                response.setReplyMethod(replyMethodName);
                response.setData((Object)outMessage);
                return;
            }
            catch (ContinuationThrowable ct) {
                suspended = true;
                throw ct;
            }
            catch (Throwable t) {
                FlexSession session22;
                context.setStatus(1);
                replyMethodName = "/onStatus";
                String lmeMessage = t.getMessage();
                if (lmeMessage == null) {
                    lmeMessage = t.getClass().getName();
                }
                MessageException lme = new MessageException();
                lme.setMessage(10000, new Object[]{lmeMessage});
                outMessage = lme.createErrorMessage();
                outMessage.setCorrelationId(inMessage.getMessageId());
                outMessage.setDestination(inMessage.getDestination());
                outMessage.setClientId(inMessage.getClientId());
                if (Log.isError()) {
                    Log.getLogger((String)LOG_CATEGORY).error("Unhandled error when processing a message: " + t.toString() + StringUtils.NEWLINE + "  incomingMessage: " + inMessage + StringUtils.NEWLINE + "  errorReply: " + outMessage + StringUtils.NEWLINE + ExceptionUtil.exceptionFollowedByRootCausesToString((Throwable)t) + StringUtils.NEWLINE);
                }
                Object var13_15 = null;
                if (suspended) return;
                if (context.isRecordMessageSizes() || context.isRecordMessageTimes()) {
                    MessagePerformanceUtils.updateOutgoingMPI((ActionContext)context, (Message)inMessage, (Object)outMessage);
                }
                if ((session22 = FlexContext.getFlexSession()) != null && session22.useSmallMessages() && !context.isLegacy() && context.getVersion() >= 3 && outMessage instanceof Message) {
                    outMessage = this.endpoint.convertToSmallMessage((Message)outMessage);
                }
                response.setReplyMethod(replyMethodName);
                response.setData((Object)outMessage);
                return;
            }
            Object var13_13 = null;
            if (suspended) return;
        }
        catch (Throwable throwable) {
            FlexSession session22;
            Object var13_16 = null;
            if (suspended) throw throwable;
            if (context.isRecordMessageSizes() || context.isRecordMessageTimes()) {
                MessagePerformanceUtils.updateOutgoingMPI((ActionContext)context, (Message)inMessage, (Object)outMessage);
            }
            if ((session22 = FlexContext.getFlexSession()) != null && session22.useSmallMessages() && !context.isLegacy() && context.getVersion() >= 3 && outMessage instanceof Message) {
                outMessage = this.endpoint.convertToSmallMessage((Message)outMessage);
            }
            response.setReplyMethod(replyMethodName);
            response.setData((Object)outMessage);
            throw throwable;
        }
        if (context.isRecordMessageSizes() || context.isRecordMessageTimes()) {
            MessagePerformanceUtils.updateOutgoingMPI((ActionContext)context, (Message)inMessage, (Object)outMessage);
        }
        if ((session22 = FlexContext.getFlexSession()) != null && session22.useSmallMessages() && !context.isLegacy() && context.getVersion() >= 3 && outMessage instanceof Message) {
            outMessage = this.endpoint.convertToSmallMessage((Message)outMessage);
        }
        response.setReplyMethod(replyMethodName);
        response.setData((Object)outMessage);
    }
}

