/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.batch.client.jetty;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.mortbay.batch.client.BatchException;
import org.mortbay.batch.client.Binding;
import org.mortbay.batch.client.Validator;
import org.mortbay.batch.client.jetty.FileExchange;
import org.mortbay.batch.client.jetty.FileGetExchange;
import org.mortbay.batch.client.jetty.JettyRetriever;
import org.mortbay.jetty.client.HttpExchange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RetrievalTarget {
    public static final String __PREFIX = "JTY_";
    public static final String __DIGEST_SUFFIX = ".sha1";
    public static final String __TEMP_SUFFIX = ".tmp";
    public static final int __START_STATE = 1;
    public static final int __REQUESTED_STATE = 2;
    public static final int __READY_STATE = 3;
    private int _checksumState;
    private int _targetState;
    private BatchException _exception;
    private Binding _binding;
    private File _tempFile;
    private String _checksumUrl;
    private String _retrievedChecksum;
    private String _calculatedChecksum;
    private JettyRetriever _retriever;
    private boolean _complete;
    private HttpExchange _exchange;
    private Set<Validator> _validators;

    public abstract void onComplete();

    public abstract void onError(BatchException var1);

    public RetrievalTarget(JettyRetriever retriever, Binding binding, Set<Validator> validators) {
        if (binding == null || binding.getRemoteUrl() == null || binding.getLocalFile() == null) {
            throw new IllegalArgumentException("No file to retrieve");
        }
        this._retriever = retriever;
        this._binding = binding;
        this._validators = validators;
        this._checksumUrl = this._binding.getRemoteUrl() + __DIGEST_SUFFIX;
        this._tempFile = new File(this._binding.getLocalFile().getParentFile(), __PREFIX + this._binding.getLocalFile().getName() + __TEMP_SUFFIX);
        this._tempFile.deleteOnExit();
        if (this._tempFile.exists()) {
            this.onError(new BatchException(binding, "File exists " + this._tempFile.getAbsolutePath()));
        } else if (!this._tempFile.getParentFile().canWrite()) {
            this.onError(new BatchException(binding, "Unable to write to dir " + this._tempFile.getParentFile().getAbsolutePath()));
        }
    }

    public boolean isLenientChecksum() {
        return this._binding.isLenientChecksum();
    }

    public void setRetrievedChecksum(String retrievedChecksum) {
        this._retrievedChecksum = retrievedChecksum;
    }

    public String getExpectedChecksum() {
        return this._retrievedChecksum;
    }

    public void setCalculatedChecksum(String calculatedChecksum) {
        this._calculatedChecksum = calculatedChecksum;
    }

    public String getActualChecksum() {
        return this._calculatedChecksum;
    }

    public File getTempFile() {
        return this._tempFile;
    }

    public String getUrl() {
        return this._binding.getRemoteUrl();
    }

    public void retrieve() {
        this.updateChecksumState(1, null);
        this.updateTargetState(1, null);
    }

    public boolean move() {
        return this._tempFile.renameTo(this._binding.getLocalFile());
    }

    public synchronized void cleanup() {
        this.deleteTempFile();
        if (this._exchange != null) {
            this._exchange.cancel();
        }
    }

    public boolean verifyChecksum() {
        if (this._retrievedChecksum != null && this._calculatedChecksum != null && this._calculatedChecksum.equals(this._retrievedChecksum)) {
            return true;
        }
        return this._retrievedChecksum == null && this._binding.isLenientChecksum();
    }

    public boolean validate(List<String> errors) {
        if (this._validators == null || this._validators.isEmpty()) {
            return true;
        }
        String ext = this._binding.getLocalFile() == null ? null : this._binding.getLocalFile().getName();
        int i = ext.lastIndexOf(".");
        ext = i > 0 ? ext.substring(i + 1) : "";
        for (Validator v : this._validators) {
            String vExt = v.getFileExtension();
            if (!vExt.equalsIgnoreCase(ext)) continue;
            try {
                if (v.validate(this._tempFile.getCanonicalPath(), errors)) continue;
                return false;
            }
            catch (IOException e) {
                errors.add(e.getMessage());
                return false;
            }
        }
        return true;
    }

    protected synchronized void updateChecksumState(int state, Throwable ex) {
        this._checksumState = state;
        if (this._exception == null && ex != null) {
            this._exception = ex instanceof BatchException ? (BatchException)ex : new BatchException(this._binding, ex);
        }
        if (this._checksumState == 1) {
            this._exchange = this.retrieveChecksum();
        }
        if (this._checksumState == 3 && this._targetState == 3) {
            this._complete = true;
            if (this._exception == null) {
                this.onComplete();
            } else {
                this.onError(this._exception);
            }
        }
    }

    protected synchronized void updateTargetState(int state, Throwable ex) {
        this._targetState = state;
        if (this._exception == null && ex != null) {
            this._exception = ex instanceof BatchException ? (BatchException)ex : new BatchException(this._binding, ex);
        }
        if (this._targetState == 1) {
            this._exchange = this.retrieveTargetFile();
        }
        if (this._checksumState == 3 && this._targetState == 3) {
            this._complete = true;
            if (this._exception == null) {
                this.onComplete();
            } else {
                this.onError(this._exception);
            }
        }
    }

    private HttpExchange retrieveChecksum() {
        this.updateChecksumState(2, null);
        HttpExchange.ContentExchange exchange = new HttpExchange.ContentExchange(){

            protected void onException(Throwable ex) {
                RetrievalTarget.this.updateChecksumState(3, ex);
            }

            protected void onResponseComplete() throws IOException {
                super.onResponseComplete();
                if (this.getResponseStatus() == 200) {
                    RetrievalTarget.this.setRetrievedChecksum(this.getResponseContent().trim());
                }
                RetrievalTarget.this.updateChecksumState(3, null);
            }
        };
        exchange.setURL(this._checksumUrl);
        try {
            this._retriever.getHttpClient().send((HttpExchange)exchange);
        }
        catch (IOException ex) {
            this.updateChecksumState(3, ex);
        }
        return exchange;
    }

    private HttpExchange retrieveTargetFile() {
        this.updateTargetState(2, null);
        FileGetExchange exchange = new FileGetExchange(this._binding, this.getTempFile(), true, this._retriever.getHttpClient()){

            public void onFileComplete(String url, File localFile, String digest) {
                RetrievalTarget.this._targetState = 3;
                RetrievalTarget.this.setCalculatedChecksum(digest);
                RetrievalTarget.this.updateTargetState(3, null);
            }

            public void onFileError(String url, Exception e) {
                RetrievalTarget.this._targetState = 3;
                RetrievalTarget.this.updateTargetState(3, e);
            }
        };
        ((FileExchange)exchange).send();
        return exchange;
    }

    private boolean deleteTempFile() {
        if (this._tempFile != null && this._tempFile.exists()) {
            return this._tempFile.delete();
        }
        return false;
    }

    public synchronized boolean isComplete() {
        return this._complete;
    }

    public String toString() {
        return "T:" + this._binding.getRemoteUrl() + ":" + this._targetState + ":" + this._checksumState + ":" + this._complete;
    }

    public String getRetrievedChecksum() {
        return this._retrievedChecksum;
    }

    public String getCalculatedChecksum() {
        return this._calculatedChecksum;
    }
}

