/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.batch.client.jetty;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.mortbay.batch.client.BatchException;
import org.mortbay.batch.client.Binding;
import org.mortbay.batch.client.RetrievalCallback;
import org.mortbay.batch.client.RetrievalRequest;
import org.mortbay.batch.client.RetrievalResponse;
import org.mortbay.batch.client.Retriever;
import org.mortbay.batch.client.jetty.JettyRetrievalResponse;
import org.mortbay.batch.client.jetty.RetrievalTarget;
import org.mortbay.jetty.client.HttpClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyRetriever
implements Retriever {
    private HttpClient _httpClient;

    public JettyRetriever() throws BatchException {
        this._httpClient = new HttpClient();
        this._httpClient.setConnectorType(2);
        try {
            this._httpClient.start();
        }
        catch (Exception e) {
            throw new BatchException(null, "unable to start http client", e);
        }
    }

    public JettyRetriever(HttpClient client) throws BatchException {
        this._httpClient = client;
        try {
            if (this._httpClient.isStarted()) {
                this._httpClient.start();
            }
        }
        catch (Exception e) {
            throw new BatchException(null, "unable to start http client", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RetrievalResponse retrieve(RetrievalRequest request) {
        final RetrievalResponse[] response = new RetrievalResponse[]{null};
        this.retrieve(request, new RetrievalCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onComplete(RetrievalResponse r) {
                RetrievalResponse[] retrievalResponseArray = response;
                synchronized (response) {
                    response[0] = r;
                    response.notify();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        });
        RetrievalResponse[] retrievalResponseArray = response;
        synchronized (response) {
            try {
                while (response[0] == null) {
                    response.wait();
                }
            }
            catch (InterruptedException e) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return null;
            }
            return response[0];
        }
    }

    @Override
    public void retrieve(final RetrievalRequest request, final RetrievalCallback callback) {
        if (request == null) {
            throw new IllegalArgumentException("No request");
        }
        if (callback == null) {
            throw new IllegalArgumentException("No callback");
        }
        final AtomicInteger count = new AtomicInteger(request.getBindings().size());
        final ArrayList<RetrievalTarget> targets = new ArrayList<RetrievalTarget>(request.getBindings().size());
        final JettyRetrievalResponse response = new JettyRetrievalResponse();
        Binding[] bindings = new Binding[request.getBindings().size()];
        request.getBindings().toArray(bindings);
        for (int i = 0; i < bindings.length && count.get() > 0; ++i) {
            final Binding binding = bindings[i];
            RetrievalTarget target = null;
            try {
                target = new RetrievalTarget(this, binding, request.getValidators()){

                    public void onComplete() {
                        ArrayList<String> validateErrors;
                        boolean checksumOK = this.verifyChecksum();
                        if (!checksumOK) {
                            response.add(new BatchException(binding, "Checksum failed: " + this.getRetrievedChecksum() + "!=" + this.getCalculatedChecksum()));
                        }
                        if (checksumOK && !this.validate(validateErrors = new ArrayList<String>())) {
                            for (String s : validateErrors) {
                                response.add(new BatchException(binding, s));
                            }
                        }
                        if (JettyRetriever.this.isComplete(count, request, response, targets)) {
                            callback.onComplete(response);
                        }
                    }

                    public void onError(BatchException exception) {
                        response.add(exception);
                        if (JettyRetriever.this.isComplete(count, request, response, targets)) {
                            callback.onComplete(response);
                        }
                    }
                };
                targets.add(target);
                continue;
            }
            catch (Exception e) {
                response.add(new BatchException(binding, (Throwable)e));
                if (!this.isComplete(count, request, response, targets)) continue;
                callback.onComplete(response);
            }
        }
        for (RetrievalTarget target : targets) {
            target.retrieve();
        }
    }

    private boolean isComplete(AtomicInteger count, RetrievalRequest request, RetrievalResponse response, List<RetrievalTarget> targets) {
        boolean completor;
        boolean bl = completor = count.decrementAndGet() == 0;
        if (!completor && request.isFailFast() && response.getExceptions().size() > 0) {
            boolean bl2 = completor = count.getAndSet(0) > 0;
        }
        if (completor) {
            if (response.getExceptions().size() == 0) {
                for (RetrievalTarget t : targets) {
                    if (t == null) continue;
                    t.move();
                }
            }
            for (RetrievalTarget t : targets) {
                t.cleanup();
            }
            return true;
        }
        return false;
    }

    public HttpClient getHttpClient() {
        return this._httpClient;
    }
}

