/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.batch.client.jetty;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.mortbay.batch.client.BatchException;
import org.mortbay.batch.client.Binding;
import org.mortbay.batch.client.DeployCallback;
import org.mortbay.batch.client.DeployRequest;
import org.mortbay.batch.client.DeployResponse;
import org.mortbay.batch.client.Deployer;
import org.mortbay.batch.client.jetty.BatchIdGenerator;
import org.mortbay.batch.client.jetty.DeploymentTarget;
import org.mortbay.batch.client.jetty.HandshakeExchange;
import org.mortbay.batch.client.jetty.JettyDeployResponse;
import org.mortbay.batch.client.jetty.RandomBatchIdGenerator;
import org.mortbay.jetty.client.HttpClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyDeployer
implements Deployer {
    private HttpClient _httpClient;
    private BatchIdGenerator _idGenerator;

    public JettyDeployer() throws BatchException {
        this._idGenerator = new RandomBatchIdGenerator();
        this._httpClient = new HttpClient();
        this._httpClient.setConnectorType(2);
        try {
            this._httpClient.start();
        }
        catch (Exception e) {
            throw new BatchException(null, "unable to start http client", e);
        }
    }

    public JettyDeployer(HttpClient client, BatchIdGenerator idGenerator) throws BatchException {
        this._idGenerator = idGenerator;
        if (this._idGenerator == null) {
            throw new BatchException(null, "no id generator supplied");
        }
        this._httpClient = client;
        try {
            if (this._httpClient.isStarted()) {
                this._httpClient.start();
            }
        }
        catch (Exception e) {
            throw new BatchException(null, "unable to start http client", e);
        }
    }

    public BatchIdGenerator getBatchIdGenerator() {
        return this._idGenerator;
    }

    public HttpClient getHttpClient() {
        return this._httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeployResponse deploy(DeployRequest request) {
        final DeployResponse[] response = new DeployResponse[]{null};
        this.deploy(request, new DeployCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onComplete(DeployResponse r) {
                DeployResponse[] deployResponseArray = response;
                synchronized (response) {
                    response[0] = r;
                    response.notify();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        });
        DeployResponse[] deployResponseArray = response;
        synchronized (response) {
            try {
                while (response[0] == null) {
                    response.wait();
                }
            }
            catch (InterruptedException e) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return null;
            }
            return response[0];
        }
    }

    @Override
    public void deploy(final DeployRequest request, final DeployCallback callback) {
        if (request == null) {
            throw new IllegalArgumentException("No request");
        }
        if (callback == null) {
            throw new IllegalArgumentException("No callback");
        }
        final String batchId = this._idGenerator.getId();
        final AtomicInteger count = new AtomicInteger(request.getBindings().size());
        ArrayList<2> targets = new ArrayList<2>(request.getBindings().size());
        final JettyDeployResponse response = new JettyDeployResponse();
        final HashSet<String> remoteHandshakeUrls = new HashSet<String>();
        Binding[] bindings = new Binding[request.getBindings().size()];
        request.getBindings().toArray(bindings);
        for (int i = 0; i < bindings.length && count.get() > 0; ++i) {
            Binding binding = bindings[i];
            DeploymentTarget target = null;
            try {
                target = new DeploymentTarget(this._httpClient, batchId, binding, request.getValidators()){

                    public void onComplete() {
                        if (this.getRemoteJettyUrl() != null) {
                            remoteHandshakeUrls.add(this.getRemoteJettyUrl());
                        }
                        JettyDeployer.this.checkComplete(callback, batchId, count, request, response, remoteHandshakeUrls);
                    }

                    public void onError(BatchException exception) {
                        if (this.getRemoteJettyUrl() != null) {
                            remoteHandshakeUrls.add(this.getRemoteJettyUrl());
                        }
                        response.add(exception);
                        JettyDeployer.this.checkComplete(callback, batchId, count, request, response, remoteHandshakeUrls);
                    }
                };
                targets.add(target);
                continue;
            }
            catch (Exception e) {
                response.add(new BatchException(binding, (Throwable)e));
                this.checkComplete(callback, batchId, count, request, response, remoteHandshakeUrls);
            }
        }
        for (DeploymentTarget deploymentTarget : targets) {
            deploymentTarget.deploy();
        }
    }

    private synchronized void checkComplete(DeployCallback callback, String batchId, AtomicInteger count, DeployRequest request, DeployResponse response, Set<String> remoteHandshakeUrls) {
        boolean completor;
        int x = count.decrementAndGet();
        boolean bl = completor = x == 0;
        if (!completor && request.isFailFast() && response.getExceptions().size() > 0) {
            boolean bl2 = completor = count.getAndSet(0) > 0;
        }
        if (completor) {
            this.commit(callback, response, batchId, remoteHandshakeUrls);
        }
    }

    private void commit(final DeployCallback callback, final DeployResponse response, String batchId, Set<String> remoteHandshakeUrls) {
        if (remoteHandshakeUrls.isEmpty()) {
            callback.onComplete(response);
        } else {
            final AtomicInteger count = new AtomicInteger(remoteHandshakeUrls.size());
            HashMap<String, String> headers = new HashMap<String, String>();
            if (response.getExceptions().isEmpty()) {
                headers.put("Jetty-Batch-Commit", batchId);
            } else {
                headers.put("Jetty-Batch-Discard", batchId);
            }
            for (String remoteUrl : remoteHandshakeUrls) {
                HandshakeExchange exchange = new HandshakeExchange(this._httpClient, "POST", remoteUrl, headers){

                    public void onHandshakeComplete(String url) {
                        JettyDeployer.this.checkHandshakeComplete(callback, response, count);
                    }

                    public void onHandshakeError(String url, Exception e) {
                        response.getExceptions().add(new BatchException(null, (Throwable)e));
                        JettyDeployer.this.checkHandshakeComplete(callback, response, count);
                    }
                };
            }
        }
    }

    private void checkHandshakeComplete(DeployCallback callback, DeployResponse response, AtomicInteger count) {
        boolean completor;
        boolean bl = completor = count.decrementAndGet() == 0;
        if (completor) {
            callback.onComplete(response);
        }
    }
}

