/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.batch.client.jetty;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.mortbay.batch.client.BatchException;
import org.mortbay.batch.client.Binding;
import org.mortbay.batch.client.jetty.ChecksumCalculator;
import org.mortbay.batch.client.jetty.FileExchange;
import org.mortbay.io.Buffer;
import org.mortbay.jetty.client.HttpClient;

public abstract class FilePutExchange
extends FileExchange {
    private String _batchId;
    private InputStream _inputStream;
    private String _remoteRepoUrl;
    private String _remoteBatchId;

    public abstract void onFileComplete(String var1, File var2, String var3);

    public abstract void onFileError(String var1, Exception var2);

    public FilePutExchange(String batchId, Binding binding, File localFile, boolean digestRequired, HttpClient client) {
        super(binding, localFile, digestRequired, client);
        this._batchId = batchId;
    }

    public void send() {
        try {
            this.setMethod("PUT");
            this.setRequestContentSource(this.getInputStream());
            this.setRequestHeader("Content-Type", "application/octet-stream");
            this.setRequestHeader("Content-Length", String.valueOf(this._localFile.length()));
            this.setRequestHeader("Jetty-Batch-Id", this._batchId);
            System.err.println("Sending PUT for " + this.getURI());
            super.send();
        }
        catch (Exception e) {
            this.onFileError(this._url, e);
        }
    }

    public boolean isRemoteJetty() {
        return this._remoteRepoUrl != null;
    }

    public String getRemoteJettyUrl() {
        return this._remoteRepoUrl;
    }

    protected void onResponseHeader(Buffer name, Buffer value) {
        if (name.toString().equalsIgnoreCase("Jetty-Batch-Supported")) {
            this._remoteRepoUrl = value.toString();
        } else if (name.toString().equalsIgnoreCase("Jetty-Batch-Id")) {
            this._remoteBatchId = value.toString();
        }
    }

    protected void onResponseComplete() {
        System.err.println("On ResponseComplete for put for " + this._url);
        String digest = null;
        try {
            if (this._status != 200 && this._status != 201 && this._status != 204) {
                this.onFileError(this._url, new BatchException(this._binding, "Http status code=" + this._status));
                return;
            }
            if (this._remoteBatchId != null && !this._batchId.equals(this._remoteBatchId)) {
                this.onFileError(this._url, new BatchException(this._binding, "Non matching batch ids. Sent=" + this._batchId + " received=" + this._remoteBatchId));
                return;
            }
            if (this._digestRequired && this._inputStream != null) {
                byte[] bytes = ((DigestInputStream)this._inputStream).getMessageDigest().digest();
                digest = ChecksumCalculator.encodeToAsciiHex(bytes);
            }
            this.onFileComplete(this._url, this._localFile, digest);
        }
        catch (Exception e) {
            this.onFileError(this._url, new BatchException(this._binding, e.getLocalizedMessage()));
        }
    }

    private InputStream getInputStream() throws IOException, NoSuchAlgorithmException {
        if (this._inputStream == null) {
            if (!this._digestRequired) {
                this._inputStream = new FileInputStream(this._localFile);
            } else {
                MessageDigest digest = MessageDigest.getInstance("SHA-1");
                this._inputStream = new DigestInputStream(new FileInputStream(this._localFile), digest);
            }
        }
        System.err.println("Returning input stream for " + this._localFile.getName());
        return this._inputStream;
    }
}

