/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.batch.client.jetty;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.mortbay.batch.client.BatchException;
import org.mortbay.batch.client.Binding;
import org.mortbay.batch.client.jetty.ChecksumCalculator;
import org.mortbay.batch.client.jetty.FileExchange;
import org.mortbay.io.Buffer;
import org.mortbay.jetty.client.HttpClient;

public abstract class FileGetExchange
extends FileExchange {
    private OutputStream _outputStream;

    public FileGetExchange(Binding binding, File localFile, boolean digestRequired, HttpClient client) {
        super(binding, localFile, digestRequired, client);
    }

    public void send() {
        this.setMethod("GET");
        super.send();
    }

    protected void onResponseComplete() {
        String digest = null;
        try {
            if (this._status == 404) {
                this.onFileError(this._url, new FileNotFoundException("File not found on remote server"));
                return;
            }
            if (this._status != 200) {
                this.onFileError(this._url, new Exception("Http status code=" + this._status));
                return;
            }
            if (this._digestRequired && this._outputStream != null) {
                byte[] bytes = ((DigestOutputStream)this._outputStream).getMessageDigest().digest();
                digest = ChecksumCalculator.encodeToAsciiHex(bytes);
            }
            this.onFileComplete(this._url, this._localFile, digest);
        }
        catch (Exception e) {
            this.onFileError(this._url, new BatchException(this._binding, e.getLocalizedMessage()));
        }
    }

    protected void onResponseContent(Buffer content) throws IOException {
        try {
            OutputStream os = this.getOutputStream();
            content.writeTo(os);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e.getLocalizedMessage());
        }
    }

    protected OutputStream getOutputStream() throws IOException, NoSuchAlgorithmException {
        if (this._outputStream == null) {
            if (!this._digestRequired) {
                this._outputStream = new FileOutputStream(this._localFile);
            } else {
                MessageDigest digest = MessageDigest.getInstance("SHA-1");
                this._outputStream = new DigestOutputStream(new FileOutputStream(this._localFile), digest);
            }
        }
        return this._outputStream;
    }
}

