/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.batch.client.jetty;

import java.io.File;
import org.mortbay.batch.client.Binding;
import org.mortbay.io.Buffer;
import org.mortbay.jetty.client.HttpClient;
import org.mortbay.jetty.client.HttpExchange;

public abstract class FileExchange
extends HttpExchange {
    public static final String __BATCH_HEADER = "Jetty-Batch-Id";
    public static final String __BATCH_SUPPORTED_HEADER = "Jetty-Batch-Supported";
    public static final String __BATCH_COMMIT_HEADER = "Jetty-Batch-Commit";
    public static final String __BATCH_DISCARD_HEADER = "Jetty-Batch-Discard";
    public static final String _digestAlgorithm = "SHA-1";
    protected HttpClient _httpClient;
    protected boolean _digestRequired;
    protected int _status;
    protected String _url;
    protected File _localFile;
    protected Binding _binding;

    public abstract void onFileComplete(String var1, File var2, String var3);

    public abstract void onFileError(String var1, Exception var2);

    public FileExchange(Binding binding, File localFile, boolean digestRequired, HttpClient client) {
        this._binding = binding;
        this._url = binding.getRemoteUrl();
        this._localFile = localFile;
        this._httpClient = client;
        this._digestRequired = digestRequired;
        this.setURL(this._url);
    }

    public void send() {
        try {
            this._httpClient.send((HttpExchange)this);
        }
        catch (Exception e) {
            this.onFileError(this._url, e);
        }
    }

    protected void onResponseStatus(Buffer version, int status, Buffer reason) {
        this._status = status;
    }

    protected void onException(Throwable ex) {
        this.onFileError(this._url, new Exception(ex));
    }

    protected void onExpire() {
        this.onFileError(this._url, new Exception("Timeout occurred"));
    }
}

