/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.batch.client.jetty;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Set;
import org.mortbay.batch.client.BatchException;
import org.mortbay.batch.client.Binding;
import org.mortbay.batch.client.Validator;
import org.mortbay.batch.client.jetty.FilePutExchange;
import org.mortbay.jetty.client.HttpClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DeploymentTarget {
    public static final String __DIGEST_SUFFIX = ".sha1";
    private HttpClient _httpClient;
    private String _batchId;
    private Binding _binding;
    private Set<Validator> _validators;
    private File _localChecksumFile;
    private String _calculatedChecksum;
    private TargetState _targetState;
    private TargetState _checksumState;
    private BatchException _exception;
    private String _remoteJettyUrl;

    public abstract void onComplete();

    public abstract void onError(BatchException var1);

    public DeploymentTarget(HttpClient client, String batchId, Binding binding, Set<Validator> validators) {
        this._httpClient = client;
        this._batchId = batchId;
        this._binding = binding;
        this._validators = validators;
        if (this._binding == null || this._binding.getLocalFile() == null || !this._binding.getLocalFile().exists()) {
            throw new IllegalArgumentException("No local file to deploy");
        }
        this._localChecksumFile = new File(this._binding.getLocalFile().getParentFile(), this._binding.getLocalFile().getName() + __DIGEST_SUFFIX);
        this._targetState = new TargetState();
        this._checksumState = new TargetState();
    }

    public void deploy() {
        this.updateState(null);
    }

    private synchronized void updateState(Throwable t) {
        if (t != null && this._exception == null) {
            BatchException batchException = this._exception = t instanceof BatchException ? (BatchException)t : new BatchException(this._binding, t);
        }
        if (this._targetState.isStart()) {
            System.err.println("Starting deployment of " + this._binding.getLocalFile().getName());
            this.deployLocalFile(this._localChecksumFile.exists());
        }
        if (this._checksumState.isStart() && this._localChecksumFile.exists()) {
            System.err.println("Starting deployment of checksum file for " + this._binding.getLocalFile().getName());
            this.deployChecksumFile();
        }
        if (this._targetState.isReady() && this._checksumState.isStart() && !this._localChecksumFile.exists()) {
            System.err.println("Calculated checksum ready, starting deployment");
            this.deployChecksumFile();
        }
        if (this._targetState.isReady() && this._checksumState.isReady()) {
            if (this._exception == null) {
                this.onComplete();
            } else {
                this.onError(this._exception);
            }
        }
    }

    private void deployLocalFile(boolean checksumExists) {
        FilePutExchange exchange = new FilePutExchange(this._batchId, this._binding, this._binding.getLocalFile(), true, this._httpClient){

            public void onFileComplete(String url, File localFile, String digest) {
                DeploymentTarget.this._remoteJettyUrl = this.getRemoteJettyUrl();
                DeploymentTarget.this._calculatedChecksum = digest;
                DeploymentTarget.this._targetState.ready();
                System.err.println("File complete " + url);
                DeploymentTarget.this.updateState(null);
            }

            public void onFileError(String url, Exception e) {
                DeploymentTarget.this._remoteJettyUrl = this.getRemoteJettyUrl();
                DeploymentTarget.this._targetState.ready(e);
                System.err.println("File complete " + url);
                DeploymentTarget.this.updateState(e);
            }
        };
        this._targetState.requested();
        exchange.send();
    }

    private void deployChecksumFile() {
        Binding binding = this._binding;
        File file = this._localChecksumFile;
        if (!this._localChecksumFile.exists() && this._calculatedChecksum != null) {
            try {
                binding = new Binding();
                binding.setRemoteUrl(this._binding.getRemoteUrl() + __DIGEST_SUFFIX);
                file = File.createTempFile(this._binding.getLocalFile().getName() + __DIGEST_SUFFIX, ".tmp");
                OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
                fw.write(this._calculatedChecksum);
                fw.close();
                binding.setLocalFile(file);
            }
            catch (Exception e) {
                this._checksumState.ready(e);
            }
        } else {
            binding = new Binding();
            binding.setRemoteUrl(this._binding.getRemoteUrl() + __DIGEST_SUFFIX);
            binding.setLocalFile(this._localChecksumFile);
        }
        FilePutExchange exchange = new FilePutExchange(this._batchId, binding, file, false, this._httpClient){

            public void onFileComplete(String url, File localFile, String digest) {
                DeploymentTarget.this._remoteJettyUrl = this.getRemoteJettyUrl();
                DeploymentTarget.this._checksumState.ready();
                System.err.println("Checksum file complete: " + url);
                DeploymentTarget.this.updateState(null);
            }

            public void onFileError(String url, Exception e) {
                DeploymentTarget.this._remoteJettyUrl = this.getRemoteJettyUrl();
                DeploymentTarget.this._checksumState.ready(e);
                System.err.println("Checksum file error: " + url);
                DeploymentTarget.this.updateState(e);
            }
        };
        this._checksumState.requested();
        exchange.send();
    }

    public boolean isRemoteJetty() {
        return this._remoteJettyUrl != null;
    }

    public String getRemoteJettyUrl() {
        return this._remoteJettyUrl;
    }

    public synchronized boolean isComplete() {
        return this._checksumState.isReady() && this._targetState.isReady();
    }

    public String toString() {
        return "DeploymentTarget:" + this._binding.getRemoteUrl() + ":" + this._targetState + ":" + this._checksumState + ":" + this.isComplete();
    }

    public class TargetState {
        public static final int __START_STATE = 1;
        public static final int __REQUESTED_STATE = 2;
        public static final int __READY_STATE = 3;
        private int _state = 1;
        private Exception _exception;

        public synchronized void ready() {
            this.setState(3);
        }

        public synchronized void ready(Exception e) {
            this.setState(3);
            this._exception = e;
        }

        public synchronized void requested() {
            this.setState(2);
        }

        public synchronized boolean isStart() {
            return this._state == 1;
        }

        public synchronized boolean isRequested() {
            return this._state == 2;
        }

        public synchronized boolean isError() {
            return this._exception != null;
        }

        public boolean isReady() {
            return this._state == 3;
        }

        public synchronized void setState(int status) {
            this._state = status;
        }

        public synchronized int getState() {
            return this._state;
        }

        public synchronized Exception getException() {
            return this._exception;
        }
    }
}

