/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.batch.client.jetty;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mortbay.util.IO;

public class ChecksumCalculator {
    private static final byte[] __HEX_DIGITS = "0123456789abcdef".getBytes();

    public static String encodeToAsciiHex(byte[] bytes) {
        int l = bytes.length;
        byte[] raw = new byte[l * 2];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            raw[j++] = __HEX_DIGITS[(0xF0 & bytes[i]) >>> 4];
            raw[j++] = __HEX_DIGITS[0xF & bytes[i]];
        }
        return new String(raw);
    }

    public static String readChecksumFromFile(File f) throws FileNotFoundException, IOException {
        if (f == null) {
            return null;
        }
        if (!ChecksumCalculator.isChecksumFile(f)) {
            throw new IOException("Not a checksum file");
        }
        FileInputStream fis = new FileInputStream(f);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IO.copy((InputStream)fis, (OutputStream)baos);
        return baos.toString("UTF-8");
    }

    public static boolean isChecksumFile(File f) {
        if (f == null) {
            return false;
        }
        String fileName = f.getName().toLowerCase();
        return fileName.endsWith(".sha") || fileName.endsWith(".sha1");
    }
}

