/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.ant.types;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.mortbay.jetty.ant.types.Attributes;
import org.mortbay.jetty.ant.types.ContextHandlers;
import org.mortbay.jetty.ant.types.FileMatchingConfiguration;

public class WebApp {
    private List libraries = new ArrayList();
    private List classes = new ArrayList();
    private Project project;
    private String contextPath;
    private String name;
    private File warFile;
    private File webXmlFile;
    private File jettyEnvXml;
    private FileSet scanTargets;
    private Attributes attributes;
    private ContextHandlers contextHandlers;
    private File webDefaultXmlFile;
    private int scanIntervalSeconds = 0;

    public WebApp(Project project) {
        this.project = project;
    }

    public File getWebDefaultXmlFile() {
        return this.webDefaultXmlFile;
    }

    public void setWebDefaultXmlFile(File webDefaultXmlfile) {
        this.webDefaultXmlFile = webDefaultXmlfile;
    }

    public void addLib(FileSet lib) {
        this.libraries.add(lib);
    }

    public List getLibraries() {
        return this.libraries;
    }

    public void addClasses(FileSet classes) {
        this.classes.add(classes);
    }

    public List getClasses() {
        return this.classes;
    }

    public File getWarFile() {
        return this.warFile;
    }

    public void setWarFile(File warFile) {
        this.warFile = warFile;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List getClassPathFiles() {
        ArrayList<File> classPathFiles = new ArrayList<File>();
        for (FileSet clazz : this.classes) {
            classPathFiles.add(clazz.getDirectoryScanner(this.project).getBasedir());
        }
        for (FileSet library : this.libraries) {
            String[] includedFiles = library.getDirectoryScanner(this.project).getIncludedFiles();
            File baseDir = library.getDirectoryScanner(this.project).getBasedir();
            for (int i = 0; i < includedFiles.length; ++i) {
                classPathFiles.add(new File(baseDir, includedFiles[i]));
            }
        }
        return classPathFiles;
    }

    public FileMatchingConfiguration getLibrariesConfiguration() {
        FileMatchingConfiguration config = new FileMatchingConfiguration();
        for (FileSet clazz : this.classes) {
            config.addDirectoryScanner(clazz.getDirectoryScanner(this.project));
        }
        for (FileSet library : this.libraries) {
            config.addDirectoryScanner(library.getDirectoryScanner(this.project));
        }
        return config;
    }

    public FileMatchingConfiguration getScanTargetsConfiguration() {
        FileMatchingConfiguration configuration = new FileMatchingConfiguration();
        if (this.scanTargets != null) {
            configuration.addDirectoryScanner(this.scanTargets.getDirectoryScanner(this.project));
        }
        return configuration;
    }

    public File getWebXmlFile() {
        if (this.webXmlFile == null) {
            File webInf = new File(this.warFile, "WEB-INF");
            return new File(webInf, "web.xml");
        }
        return this.webXmlFile;
    }

    public void setWebXmlFile(File webXmlFile) {
        this.webXmlFile = webXmlFile;
    }

    public void addScanTargets(FileSet scanTargets) {
        if (this.scanTargets != null) {
            throw new BuildException("Only one <scanTargets> tag is allowed!");
        }
        this.scanTargets = scanTargets;
    }

    public void addContextHandlers(ContextHandlers contextHandlers) {
        if (this.contextHandlers != null) {
            throw new BuildException("Only one <contextHandlers> tag is allowed!");
        }
        this.contextHandlers = contextHandlers;
    }

    public void addAttributes(Attributes attributes) {
        if (this.attributes != null) {
            throw new BuildException("Only one <attributes> tag is allowed!");
        }
        this.attributes = attributes;
    }

    public int getScanIntervalSeconds() {
        return this.scanIntervalSeconds;
    }

    public void setScanIntervalSeconds(int scanIntervalSeconds) {
        this.scanIntervalSeconds = scanIntervalSeconds;
    }

    public File getJettyEnvXml() {
        return this.jettyEnvXml;
    }

    public void setJettyEnvXml(File jettyEnvXml) {
        this.jettyEnvXml = jettyEnvXml;
    }

    public List getContextHandlers() {
        return this.contextHandlers != null ? this.contextHandlers.getContextHandlers() : new ArrayList();
    }

    public List getAttributes() {
        return this.attributes != null ? this.attributes.getAttributes() : new ArrayList();
    }
}

