/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.ant;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import org.eclipse.jetty.plus.webapp.EnvConfiguration;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.JettyWebXmlConfiguration;
import org.eclipse.jetty.webapp.TagLibConfiguration;
import org.eclipse.jetty.webapp.WebAppClassLoader;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebInfConfiguration;
import org.mortbay.jetty.ant.JettyWebAppConfiguration;
import org.mortbay.jetty.ant.types.FileMatchingConfiguration;
import org.mortbay.jetty.ant.utils.TaskLog;
import org.mortbay.jetty.ant.utils.WebApplicationProxy;

public class WebApplicationProxyImpl
implements WebApplicationProxy {
    static File baseTempDirectory = new File(".");
    private String name;
    private File warFile;
    private String contextPath;
    private File webXmlFile;
    private File jettyEnvXml;
    private List classPathFiles;
    private WebAppContext webAppContext;
    private FileMatchingConfiguration extraScanTargetsConfiguration;
    private List contextHandlers;
    Configuration[] configurations;
    private FileMatchingConfiguration librariesConfiguration;
    private File webDefaultXmlFile;

    public static void setBaseTempDirectory(File tempDirectory) {
        baseTempDirectory = tempDirectory;
    }

    public WebApplicationProxyImpl(String name) throws Exception {
        this.name = name;
        TaskLog.log("\nConfiguring Jetty for web application: " + name);
        this.configurations = new Configuration[]{new WebInfConfiguration(), new EnvConfiguration(), new JettyWebAppConfiguration(), new JettyWebXmlConfiguration(), new TagLibConfiguration()};
    }

    public List getClassPathFiles() {
        return this.classPathFiles;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getName() {
        return this.name;
    }

    public File getSourceDirectory() {
        return this.warFile;
    }

    public File getWebXmlFile() {
        return this.webXmlFile;
    }

    public void setSourceDirectory(File warFile) {
        this.warFile = warFile;
        TaskLog.log("Webapp source directory = " + warFile);
    }

    public void setContextPath(String contextPath) {
        if (!contextPath.startsWith("/")) {
            contextPath = "/" + contextPath;
        }
        this.contextPath = contextPath;
        TaskLog.log("Context path = " + contextPath);
    }

    public void setWebXml(File webXmlFile) {
        this.webXmlFile = webXmlFile;
    }

    public void setJettyEnvXml(File jettyEnvXml) {
        this.jettyEnvXml = jettyEnvXml;
        if (this.jettyEnvXml != null) {
            TaskLog.log("jetty-env.xml file: = " + jettyEnvXml.getAbsolutePath());
        }
    }

    public void setClassPathFiles(List classPathFiles) {
        this.classPathFiles = classPathFiles;
        TaskLog.log("Classpath = " + classPathFiles);
    }

    public boolean isFileScanned(String pathToFile) {
        return this.librariesConfiguration.isIncluded(pathToFile) || this.extraScanTargetsConfiguration.isIncluded(pathToFile);
    }

    public void setLibrariesConfiguration(FileMatchingConfiguration classesConfiguration) {
        TaskLog.log("Default scanned paths = " + classesConfiguration.getBaseDirectories());
        this.librariesConfiguration = classesConfiguration;
    }

    public List getLibraries() {
        return this.librariesConfiguration.getBaseDirectories();
    }

    public void setExtraScanTargetsConfiguration(FileMatchingConfiguration extraScanTargetsConfiguration) {
        this.extraScanTargetsConfiguration = extraScanTargetsConfiguration;
        TaskLog.log("Extra scan targets = " + extraScanTargetsConfiguration.getBaseDirectories());
    }

    public List getExtraScanTargets() {
        return this.extraScanTargetsConfiguration.getBaseDirectories();
    }

    public List getContextHandlers() {
        return this.contextHandlers;
    }

    public void setContextHandlers(List contextHandlers) {
        this.contextHandlers = contextHandlers;
    }

    public Object getProxiedObject() {
        return this.webAppContext;
    }

    public void start() {
        try {
            TaskLog.logWithTimestamp("Starting web application " + this.name + " ...\n");
            this.webAppContext.setShutdown(false);
            this.webAppContext.start();
        }
        catch (Exception e) {
            TaskLog.log(e.toString());
        }
    }

    public void stop() {
        try {
            TaskLog.logWithTimestamp("Stopping web application " + this.name + " ...");
            this.webAppContext.setShutdown(true);
            Thread.currentThread();
            Thread.sleep(500L);
            this.webAppContext.stop();
        }
        catch (InterruptedException e) {
            TaskLog.log(e.toString());
        }
        catch (Exception e) {
            TaskLog.log(e.toString());
        }
    }

    public void createApplicationContext(ContextHandlerCollection contexts) {
        this.webAppContext = new WebAppContext((HandlerContainer)contexts, this.warFile.getAbsolutePath(), this.contextPath);
        this.webAppContext.setDisplayName(this.name);
        this.configurePaths();
        this.configureHandlers(contexts);
        this.applyConfiguration();
    }

    private void configureHandlers(ContextHandlerCollection contexts) {
        for (ContextHandler contextHandler : this.contextHandlers) {
            contexts.addHandler((Handler)contextHandler);
        }
    }

    private void configurePaths() {
        File tempDir = new File(baseTempDirectory, this.contextPath);
        if (!tempDir.exists()) {
            tempDir.mkdirs();
        }
        this.webAppContext.setTempDirectory(tempDir);
        tempDir.deleteOnExit();
        TaskLog.log("Temp directory = " + tempDir.getAbsolutePath());
        if (this.warFile.isFile()) {
            this.warFile = new File(tempDir, "webapp");
            this.webXmlFile = new File(new File(this.warFile, "WEB-INF"), "web.xml");
        }
    }

    void applyConfiguration() {
        for (int i = 0; i < this.configurations.length; ++i) {
            if (this.configurations[i] instanceof EnvConfiguration) {
                try {
                    if (this.jettyEnvXml == null || !this.jettyEnvXml.exists()) continue;
                    ((EnvConfiguration)this.configurations[i]).setJettyEnvXml(this.jettyEnvXml.toURL());
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!(this.configurations[i] instanceof JettyWebAppConfiguration)) continue;
            ((JettyWebAppConfiguration)this.configurations[i]).setClassPathFiles(this.classPathFiles);
            ((JettyWebAppConfiguration)this.configurations[i]).setWebAppBaseDir(this.warFile);
            ((JettyWebAppConfiguration)this.configurations[i]).setWebXmlFile(this.webXmlFile);
            ((JettyWebAppConfiguration)this.configurations[i]).setWebDefaultXmlFile(this.webDefaultXmlFile);
        }
        try {
            WebAppClassLoader loader = new WebAppClassLoader(this.getClass().getClassLoader(), this.webAppContext);
            this.webAppContext.setParentLoaderPriority(true);
            this.webAppContext.setClassLoader((ClassLoader)loader);
            if (this.webDefaultXmlFile != null) {
                this.webAppContext.setDefaultsDescriptor(this.webDefaultXmlFile.getCanonicalPath());
            }
        }
        catch (IOException e) {
            TaskLog.log(e.toString());
        }
        this.webAppContext.setConfigurations(this.configurations);
    }

    public File getWebDefaultXmlFile() {
        return this.webDefaultXmlFile;
    }

    public void setWebDefaultXmlFile(File webDefaultXmlfile) {
        this.webDefaultXmlFile = webDefaultXmlfile;
    }
}

