/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.ant;

import java.io.File;
import java.net.URL;
import java.util.List;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.WebAppClassLoader;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebXmlConfiguration;
import org.eclipse.jetty.webapp.WebXmlProcessor;
import org.mortbay.jetty.ant.utils.TaskLog;

public class JettyWebAppConfiguration
extends WebXmlConfiguration {
    private List classPathFiles;
    private File webAppBaseDir;
    private File webXmlFile;
    private File webDefaultXmlFile;

    public File getWebDefaultXmlFile() {
        return this.webDefaultXmlFile;
    }

    public void setWebDefaultXmlFile(File webDefaultXmlfile) {
        this.webDefaultXmlFile = webDefaultXmlfile;
    }

    public void setClassPathFiles(List classPathFiles) {
        this.classPathFiles = classPathFiles;
    }

    public void setWebAppBaseDir(File webAppBaseDir) {
        this.webAppBaseDir = webAppBaseDir;
    }

    public void setWebXmlFile(File webXmlFile) {
        this.webXmlFile = webXmlFile;
        if (webXmlFile.exists()) {
            TaskLog.log("web.xml file = " + webXmlFile);
        }
    }

    public void configure(WebAppContext context) throws Exception {
        if (context.isStarted()) {
            TaskLog.log("Cannot configure webapp after it is started");
            return;
        }
        WebXmlProcessor processor = (WebXmlProcessor)context.getAttribute("org.eclipse.jetty.webProcessor");
        if (processor == null) {
            processor = new WebXmlProcessor(context);
            context.setAttribute("org.eclipse.jetty.webProcessor", (Object)processor);
        }
        if (this.webXmlFile.exists()) {
            processor.parseWebXml(Resource.newResource((URL)this.webXmlFile.toURL()));
            processor.processWebXml();
        }
        super.configure(context);
        for (File classPathFile : this.classPathFiles) {
            if (!classPathFile.exists()) continue;
            ((WebAppClassLoader)context.getClassLoader()).addClassPath(classPathFile.getCanonicalPath());
        }
    }
}

