/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.ant;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.RequestLog;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.ant.JettyRunTask;
import org.mortbay.jetty.ant.WebApplicationProxyImpl;
import org.mortbay.jetty.ant.utils.ServerProxy;
import org.mortbay.jetty.ant.utils.TaskLog;
import org.mortbay.jetty.ant.utils.WebApplicationProxy;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.handler.DefaultHandler;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.handler.RequestLogHandler;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.resource.Resource;
import org.mortbay.xml.XmlConfiguration;
import org.xml.sax.SAXException;

public class ServerProxyImpl
implements ServerProxy {
    private Server server;
    private ContextHandlerCollection contexts;
    private File jettyXml;
    private List connectors;
    private RequestLog requestLog;
    private List userRealms;
    private Map webApplications = new HashMap();

    public ServerProxyImpl(List connectors, List userRealmsList, RequestLog requestLog, File jettyXml) {
        this.server = new Server();
        this.server.setStopAtShutdown(true);
        this.connectors = connectors;
        this.userRealms = userRealmsList;
        this.requestLog = requestLog;
        this.jettyXml = jettyXml;
        this.configure();
    }

    public void addWebApplication(WebApplicationProxy webApp, int scanIntervalSeconds) {
        webApp.createApplicationContext(this.contexts);
        if (scanIntervalSeconds > 0) {
            this.webApplications.put(webApp, new Integer(scanIntervalSeconds));
        }
    }

    private void configure() {
        this.applyJettyXml();
        for (Connector jettyConnector : this.connectors) {
            this.server.addConnector(jettyConnector);
        }
        for (UserRealm realm : this.userRealms) {
            this.server.addUserRealm(realm);
        }
        Resource.setDefaultUseCaches((boolean)false);
        this.configureHandlers();
    }

    private void configureHandlers() {
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        if (this.requestLog != null) {
            requestLogHandler.setRequestLog(this.requestLog);
        }
        this.contexts = (ContextHandlerCollection)this.server.getChildHandlerByClass(ContextHandlerCollection.class);
        if (this.contexts == null) {
            this.contexts = new ContextHandlerCollection();
            HandlerCollection handlers = (HandlerCollection)this.server.getChildHandlerByClass(HandlerCollection.class);
            if (handlers == null) {
                handlers = new HandlerCollection();
                this.server.setHandler((Handler)handlers);
                handlers.setHandlers(new Handler[]{this.contexts, new DefaultHandler(), requestLogHandler});
            } else {
                handlers.addHandler((Handler)this.contexts);
            }
        }
    }

    private void applyJettyXml() {
        if (this.jettyXml != null && this.jettyXml.exists()) {
            TaskLog.log("Configuring jetty from xml configuration file = " + this.jettyXml.getAbsolutePath());
            try {
                XmlConfiguration configuration = new XmlConfiguration(this.jettyXml.toURL());
                configuration.configure((Object)this.server);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void start() {
        try {
            this.server.start();
            this.startScanners();
            this.server.join();
        }
        catch (InterruptedException e) {
            new RuntimeException(e);
        }
        catch (Exception e) {
            new RuntimeException(e);
        }
    }

    private void startScanners() {
        for (WebApplicationProxyImpl webApp : this.webApplications.keySet()) {
            Integer scanIntervalSeconds = (Integer)this.webApplications.get(webApp);
            JettyRunTask.startScanner(webApp, scanIntervalSeconds);
        }
    }

    public Object getProxiedObject() {
        return this.server;
    }
}

