/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.ant;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.List;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.ant.JettyWebAppConfiguration;
import org.mortbay.jetty.ant.types.FileMatchingConfiguration;
import org.mortbay.jetty.ant.utils.TaskLog;
import org.mortbay.jetty.ant.utils.WebApplicationProxy;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.plus.webapp.EnvConfiguration;
import org.mortbay.jetty.webapp.Configuration;
import org.mortbay.jetty.webapp.JettyWebXmlConfiguration;
import org.mortbay.jetty.webapp.TagLibConfiguration;
import org.mortbay.jetty.webapp.WebAppClassLoader;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.jetty.webapp.WebInfConfiguration;

public class WebApplicationProxyImpl
implements WebApplicationProxy {
    static File baseTempDirectory = new File(".");
    private String name;
    private File warFile;
    private String contextPath;
    private File webXmlFile;
    private File jettyEnvXml;
    private List classPathFiles;
    private WebAppContext webAppContext;
    private FileMatchingConfiguration extraScanTargetsConfiguration;
    private List contextHandlers;
    Configuration[] configurations = new Configuration[]{new WebInfConfiguration(), new EnvConfiguration(), new JettyWebAppConfiguration(), new JettyWebXmlConfiguration(), new TagLibConfiguration()};
    private FileMatchingConfiguration librariesConfiguration;

    public static void setBaseTempDirectory(File tempDirectory) {
        baseTempDirectory = tempDirectory;
    }

    public WebApplicationProxyImpl(String name) {
        this.name = name;
        TaskLog.log("\nConfiguring Jetty for web application: " + name);
    }

    public List getClassPathFiles() {
        return this.classPathFiles;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getName() {
        return this.name;
    }

    public File getSourceDirectory() {
        return this.warFile;
    }

    public File getWebXmlFile() {
        return this.webXmlFile;
    }

    public void setSourceDirectory(File warFile) {
        this.warFile = warFile;
        TaskLog.log("Webapp source directory = " + warFile);
    }

    public void setContextPath(String contextPath) {
        if (!contextPath.startsWith("/")) {
            contextPath = "/" + contextPath;
        }
        this.contextPath = contextPath;
        TaskLog.log("Context path = " + contextPath);
    }

    public void setWebXml(File webXmlFile) {
        this.webXmlFile = webXmlFile;
    }

    public void setJettyEnvXml(File jettyEnvXml) {
        this.jettyEnvXml = jettyEnvXml;
        if (this.jettyEnvXml != null) {
            TaskLog.log("jetty-env.xml file: = " + jettyEnvXml.getAbsolutePath());
        }
    }

    public void setClassPathFiles(List classPathFiles) {
        this.classPathFiles = classPathFiles;
        TaskLog.log("Classpath = " + classPathFiles);
    }

    public boolean isFileScanned(String pathToFile) {
        return this.librariesConfiguration.isIncluded(pathToFile) || this.extraScanTargetsConfiguration.isIncluded(pathToFile);
    }

    public void setLibrariesConfiguration(FileMatchingConfiguration classesConfiguration) {
        TaskLog.log("Default scanned paths = " + classesConfiguration.getBaseDirectories());
        this.librariesConfiguration = classesConfiguration;
    }

    public List getLibraries() {
        return this.librariesConfiguration.getBaseDirectories();
    }

    public void setExtraScanTargetsConfiguration(FileMatchingConfiguration extraScanTargetsConfiguration) {
        this.extraScanTargetsConfiguration = extraScanTargetsConfiguration;
        TaskLog.log("Extra scan targets = " + extraScanTargetsConfiguration.getBaseDirectories());
    }

    public List getExtraScanTargets() {
        return this.extraScanTargetsConfiguration.getBaseDirectories();
    }

    public List getContextHandlers() {
        return this.contextHandlers;
    }

    public void setContextHandlers(List contextHandlers) {
        this.contextHandlers = contextHandlers;
    }

    public Object getProxiedObject() {
        return this.webAppContext;
    }

    public void start() {
        try {
            TaskLog.logWithTimestamp("Starting web application " + this.name + " ...\n");
            this.webAppContext.setShutdown(false);
            this.webAppContext.start();
        }
        catch (Exception e) {
            TaskLog.log(e.toString());
        }
    }

    public void stop() {
        try {
            TaskLog.logWithTimestamp("Stopping web application " + this.name + " ...");
            this.webAppContext.setShutdown(true);
            Thread.currentThread();
            Thread.sleep(500L);
            this.webAppContext.stop();
        }
        catch (InterruptedException e) {
            TaskLog.log(e.toString());
        }
        catch (Exception e) {
            TaskLog.log(e.toString());
        }
    }

    public void createApplicationContext(ContextHandlerCollection contexts) {
        this.webAppContext = new WebAppContext((HandlerContainer)contexts, this.warFile.getAbsolutePath(), this.contextPath);
        this.webAppContext.setDisplayName(this.name);
        this.configurePaths();
        this.configureHandlers(contexts);
        this.applyConfiguration();
    }

    private void configureHandlers(ContextHandlerCollection contexts) {
        Iterator handlersIterator = this.contextHandlers.iterator();
        while (handlersIterator.hasNext()) {
            ContextHandler contextHandler = (ContextHandler)handlersIterator.next();
            contexts.addHandler((Handler)contextHandler);
        }
    }

    private void configurePaths() {
        File tempDir = new File(baseTempDirectory, this.contextPath);
        if (!tempDir.exists()) {
            tempDir.mkdirs();
        }
        this.webAppContext.setTempDirectory(tempDir);
        tempDir.deleteOnExit();
        TaskLog.log("Temp directory = " + tempDir.getAbsolutePath());
        if (this.warFile.isFile()) {
            this.warFile = new File(tempDir, "webapp");
            this.webXmlFile = new File(new File(this.warFile, "WEB-INF"), "web.xml");
        }
    }

    void applyConfiguration() {
        for (int i = 0; i < this.configurations.length; ++i) {
            if (this.configurations[i] instanceof EnvConfiguration) {
                try {
                    if (this.jettyEnvXml == null || !this.jettyEnvXml.exists()) continue;
                    ((EnvConfiguration)this.configurations[i]).setJettyEnvXml(this.jettyEnvXml.toURL());
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!(this.configurations[i] instanceof JettyWebAppConfiguration)) continue;
            ((JettyWebAppConfiguration)this.configurations[i]).setClassPathFiles(this.classPathFiles);
            ((JettyWebAppConfiguration)this.configurations[i]).setWebAppBaseDir(this.warFile);
            ((JettyWebAppConfiguration)this.configurations[i]).setWebXmlFile(this.webXmlFile);
        }
        try {
            WebAppClassLoader loader = new WebAppClassLoader(this.getClass().getClassLoader(), this.webAppContext);
            this.webAppContext.setParentLoaderPriority(true);
            this.webAppContext.setClassLoader((ClassLoader)loader);
        }
        catch (IOException e) {
            TaskLog.log(e.toString());
        }
        this.webAppContext.setConfigurations(this.configurations);
    }
}

