/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.ant;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.mortbay.jetty.ant.utils.TaskLog;
import org.mortbay.jetty.plus.webapp.Configuration;
import org.mortbay.jetty.webapp.WebAppClassLoader;

public class JettyWebAppConfiguration
extends Configuration {
    private List classPathFiles;
    private File webAppBaseDir;
    private File webXmlFile;

    public void setClassPathFiles(List classPathFiles) {
        this.classPathFiles = classPathFiles;
    }

    public void setWebAppBaseDir(File webAppBaseDir) {
        this.webAppBaseDir = webAppBaseDir;
    }

    public void setWebXmlFile(File webXmlFile) {
        this.webXmlFile = webXmlFile;
        if (webXmlFile.exists()) {
            TaskLog.log("web.xml file = " + webXmlFile);
        }
    }

    public void configureClassLoader() throws Exception {
        Iterator filesIterator = this.classPathFiles.iterator();
        while (filesIterator.hasNext()) {
            File classPathFile = (File)filesIterator.next();
            if (!classPathFile.exists()) continue;
            ((WebAppClassLoader)this.getWebAppContext().getClassLoader()).addClassPath(classPathFile.getCanonicalPath());
        }
    }

    public void configureWebApp() throws Exception {
        if (this.getWebAppContext().isStarted()) {
            TaskLog.log("Cannot configure webapp after it is started");
            return;
        }
        this.getWebAppContext().setResourceBase(this.webAppBaseDir.getAbsolutePath());
        if (this.webXmlFile.exists()) {
            this.configure(this.webXmlFile.toURL().toString());
        }
        this.bindUserTransaction();
        this.lockCompEnv();
    }
}

