/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.annotations;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.annotation.Resources;
import javax.annotation.security.RunAs;
import javax.naming.NamingException;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.http.annotation.InitParam;
import javax.servlet.http.annotation.Servlet;
import javax.servlet.http.annotation.ServletContextListener;
import javax.servlet.http.annotation.ServletFilter;
import javax.servlet.http.annotation.jaxrs.DELETE;
import javax.servlet.http.annotation.jaxrs.GET;
import javax.servlet.http.annotation.jaxrs.HEAD;
import javax.servlet.http.annotation.jaxrs.POST;
import javax.servlet.http.annotation.jaxrs.PUT;
import org.mortbay.jetty.annotations.AnnotationFinder;
import org.mortbay.jetty.plus.annotation.Injection;
import org.mortbay.jetty.plus.annotation.InjectionCollection;
import org.mortbay.jetty.plus.annotation.LifeCycleCallback;
import org.mortbay.jetty.plus.annotation.LifeCycleCallbackCollection;
import org.mortbay.jetty.plus.annotation.PojoContextListener;
import org.mortbay.jetty.plus.annotation.PojoFilter;
import org.mortbay.jetty.plus.annotation.PojoServlet;
import org.mortbay.jetty.plus.annotation.PostConstructCallback;
import org.mortbay.jetty.plus.annotation.PreDestroyCallback;
import org.mortbay.jetty.plus.annotation.RunAsCollection;
import org.mortbay.jetty.plus.naming.NamingEntryUtil;
import org.mortbay.jetty.servlet.Dispatcher;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.FilterMapping;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.ServletMapping;
import org.mortbay.log.Log;
import org.mortbay.util.IntrospectionUtil;
import org.mortbay.util.LazyList;

public class AnnotationProcessor {
    AnnotationFinder _finder;
    ClassLoader _loader;
    RunAsCollection _runAs;
    InjectionCollection _injections;
    LifeCycleCallbackCollection _callbacks;
    List _servlets;
    List _filters;
    List _listeners;
    List _servletMappings;
    List _filterMappings;
    Map _pojoInstances = new HashMap();
    private static Class[] __envEntryTypes = new Class[]{String.class, Character.class, Integer.class, Boolean.class, Double.class, Byte.class, Short.class, Long.class, Float.class};

    public AnnotationProcessor(AnnotationFinder finder, RunAsCollection runAs, InjectionCollection injections, LifeCycleCallbackCollection callbacks, List servlets, List filters, List listeners, List servletMappings, List filterMappings) {
        this._finder = finder;
        this._runAs = runAs;
        this._injections = injections;
        this._callbacks = callbacks;
        this._servlets = servlets;
        this._filters = filters;
        this._listeners = listeners;
        this._servletMappings = servletMappings;
        this._filterMappings = filterMappings;
    }

    public void process() throws Exception {
        this.processServlets();
        this.processFilters();
        this.processListeners();
        this.processRunAsAnnotations();
        this.processLifeCycleCallbackAnnotations();
        this.processResourcesAnnotations();
        this.processResourceAnnotations();
    }

    public void processServlets() throws Exception {
        for (Class<?> clazz : this._finder.getClassesForAnnotation(Servlet.class)) {
            Servlet annotation = clazz.getAnnotation(Servlet.class);
            PojoServlet servlet = new PojoServlet(this.getPojoInstanceFor(clazz));
            List<Method> methods = this._finder.getMethodsForAnnotation(GET.class);
            if (methods.size() > 1) {
                throw new IllegalStateException("More than one GET annotation on " + clazz.getName());
            }
            if (methods.size() == 1) {
                servlet.setGetMethodName(methods.get(0).getName());
            }
            if ((methods = this._finder.getMethodsForAnnotation(POST.class)).size() > 1) {
                throw new IllegalStateException("More than one POST annotation on " + clazz.getName());
            }
            if (methods.size() == 1) {
                servlet.setPostMethodName(methods.get(0).getName());
            }
            if ((methods = this._finder.getMethodsForAnnotation(PUT.class)).size() > 1) {
                throw new IllegalStateException("More than one PUT annotation on " + clazz.getName());
            }
            if (methods.size() == 1) {
                servlet.setPutMethodName(methods.get(0).getName());
            }
            if ((methods = this._finder.getMethodsForAnnotation(DELETE.class)).size() > 1) {
                throw new IllegalStateException("More than one DELETE annotation on " + clazz.getName());
            }
            if (methods.size() == 1) {
                servlet.setDeleteMethodName(methods.get(0).getName());
            }
            if ((methods = this._finder.getMethodsForAnnotation(HEAD.class)).size() > 1) {
                throw new IllegalStateException("More than one HEAD annotation on " + clazz.getName());
            }
            if (methods.size() == 1) {
                servlet.setHeadMethodName(methods.get(0).getName());
            }
            ServletHolder holder = new ServletHolder((javax.servlet.Servlet)servlet);
            holder.setName(annotation.name().equals("") ? clazz.getName() : annotation.name());
            holder.setInitOrder(annotation.loadOnStartup());
            LazyList.add((Object)this._servlets, (Object)holder);
            for (InitParam ip : annotation.initParams()) {
                holder.setInitParameter(ip.name(), ip.value());
            }
            if (annotation.urlMappings().length <= 0) continue;
            ArrayList<String> paths = new ArrayList<String>();
            ServletMapping mapping = new ServletMapping();
            mapping.setServletName(holder.getName());
            for (String s : annotation.urlMappings()) {
                paths.add(AnnotationProcessor.normalizePattern(s));
            }
            mapping.setPathSpecs(paths.toArray(new String[paths.size()]));
            LazyList.add((Object)this._servletMappings, (Object)mapping);
        }
    }

    public void processFilters() throws Exception {
        for (Class<?> clazz : this._finder.getClassesForAnnotation(ServletFilter.class)) {
            ServletFilter annotation = clazz.getAnnotation(ServletFilter.class);
            PojoFilter filter = new PojoFilter(this.getPojoInstanceFor(clazz));
            FilterHolder holder = new FilterHolder((Filter)filter);
            holder.setName(annotation.filterName().equals("") ? clazz.getName() : annotation.filterName());
            holder.setDisplayName(annotation.displayName());
            LazyList.add((Object)this._filters, (Object)holder);
            for (InitParam ip : annotation.initParams()) {
                holder.setInitParameter(ip.name(), ip.value());
            }
            if (annotation.filterMapping() == null) continue;
            FilterMapping mapping = new FilterMapping();
            mapping.setFilterName(holder.getName());
            ArrayList<String> paths = new ArrayList<String>();
            for (String s : annotation.filterMapping().urlPattern()) {
                paths.add(AnnotationProcessor.normalizePattern(s));
            }
            mapping.setPathSpecs(paths.toArray(new String[paths.size()]));
            ArrayList<String> names = new ArrayList<String>();
            for (String s : annotation.filterMapping().servletNames()) {
                names.add(s);
            }
            mapping.setServletNames(names.toArray(new String[names.size()]));
            int dispatcher = 0;
            for (DispatcherType d : annotation.filterMapping().dispatcherTypes()) {
                dispatcher |= Dispatcher.type((DispatcherType)d);
            }
            mapping.setDispatches(dispatcher);
            LazyList.add((Object)this._filterMappings, (Object)mapping);
        }
    }

    public void processListeners() throws Exception {
        for (Class<?> clazz : this._finder.getClassesForAnnotation(ServletContextListener.class)) {
            PojoContextListener listener = new PojoContextListener(this.getPojoInstanceFor(clazz));
            LazyList.add((Object)this._listeners, (Object)listener);
        }
    }

    public List getServlets() {
        return this._servlets;
    }

    public List getServletMappings() {
        return this._servletMappings;
    }

    public List getFilters() {
        return this._filters;
    }

    public List getFilterMappings() {
        return this._filterMappings;
    }

    public List getListeners() {
        return this._listeners;
    }

    public void processRunAsAnnotations() throws Exception {
        for (Class<?> clazz : this._finder.getClassesForAnnotation(RunAs.class)) {
            String role;
            RunAs runAs = clazz.getAnnotation(RunAs.class);
            if (runAs == null || (role = runAs.value()) == null) continue;
            org.mortbay.jetty.plus.annotation.RunAs ra = new org.mortbay.jetty.plus.annotation.RunAs();
            ra.setTargetClass(clazz);
            ra.setRoleName(role);
            this._runAs.add(ra);
        }
    }

    public void processLifeCycleCallbackAnnotations() throws Exception {
        this.processPostConstructAnnotations();
        this.processPreDestroyAnnotations();
    }

    private void processPostConstructAnnotations() throws Exception {
        for (Method m : this._finder.getMethodsForAnnotation(PostConstruct.class)) {
            if (m.getParameterTypes().length != 0) {
                throw new IllegalStateException(m + " has parameters");
            }
            if (m.getReturnType() != Void.TYPE) {
                throw new IllegalStateException(m + " is not void");
            }
            if (m.getExceptionTypes().length != 0) {
                throw new IllegalStateException(m + " throws checked exceptions");
            }
            if (Modifier.isStatic(m.getModifiers())) {
                throw new IllegalStateException(m + " is static");
            }
            PostConstructCallback callback = new PostConstructCallback();
            callback.setTargetClass(m.getDeclaringClass());
            callback.setTarget(m);
            this._callbacks.add((LifeCycleCallback)callback);
        }
    }

    public void processPreDestroyAnnotations() throws Exception {
        for (Method m : this._finder.getMethodsForAnnotation(PreDestroy.class)) {
            if (m.getParameterTypes().length != 0) {
                throw new IllegalStateException(m + " has parameters");
            }
            if (m.getReturnType() != Void.TYPE) {
                throw new IllegalStateException(m + " is not void");
            }
            if (m.getExceptionTypes().length != 0) {
                throw new IllegalStateException(m + " throws checked exceptions");
            }
            if (Modifier.isStatic(m.getModifiers())) {
                throw new IllegalStateException(m + " is static");
            }
            PreDestroyCallback callback = new PreDestroyCallback();
            callback.setTargetClass(m.getDeclaringClass());
            callback.setTarget(m);
            this._callbacks.add((LifeCycleCallback)callback);
        }
    }

    public void processResourcesAnnotations() throws Exception {
        List<Class<?>> classes = this._finder.getClassesForAnnotation(Resources.class);
        for (Class<?> clazz : classes) {
            Resource[] resArray;
            Resources resources = clazz.getAnnotation(Resources.class);
            if (resources == null || (resArray = resources.value()) == null || resArray.length == 0) continue;
            for (int j = 0; j < resArray.length; ++j) {
                String name = resArray[j].name();
                String mappedName = resArray[j].mappedName();
                Resource.AuthenticationType auth = resArray[j].authenticationType();
                Class type = resArray[j].type();
                boolean shareable = resArray[j].shareable();
                if (name == null || name.trim().equals("")) {
                    throw new IllegalStateException("Class level Resource annotations must contain a name (Common Annotations Spec Section 2.3)");
                }
                NamingEntryUtil.bindToENC((String)name, (String)mappedName);
            }
        }
    }

    public void processResourceAnnotations() throws Exception {
        this.processClassResourceAnnotations();
        this.processMethodResourceAnnotations();
        this.processFieldResourceAnnotations();
    }

    public void processClassResourceAnnotations() throws Exception {
        List<Class<?>> classes = this._finder.getClassesForAnnotation(Resource.class);
        for (Class<?> clazz : classes) {
            Resource resource = clazz.getAnnotation(Resource.class);
            if (resource == null) continue;
            String name = resource.name();
            String mappedName = resource.mappedName();
            Resource.AuthenticationType auth = resource.authenticationType();
            Class type = resource.type();
            boolean shareable = resource.shareable();
            if (name == null || name.trim().equals("")) {
                throw new IllegalStateException("Class level Resource annotations must contain a name (Common Annotations Spec Section 2.3)");
            }
            NamingEntryUtil.bindToENC((String)name, (String)mappedName);
        }
    }

    public void processMethodResourceAnnotations() throws Exception {
        List<Method> methods = this._finder.getMethodsForAnnotation(Resource.class);
        for (Method m : methods) {
            Resource resource = m.getAnnotation(Resource.class);
            if (resource == null) continue;
            if (Modifier.isStatic(m.getModifiers())) {
                throw new IllegalStateException(m + " cannot be static");
            }
            if (!IntrospectionUtil.isJavaBeanCompliantSetter((Method)m)) {
                throw new IllegalStateException(m + " is not a java bean compliant setter method");
            }
            String name = m.getName().substring(3);
            name = name.substring(0, 1).toLowerCase() + name.substring(1);
            name = m.getDeclaringClass().getCanonicalName() + "/" + name;
            name = resource.name() != null && !resource.name().trim().equals("") ? resource.name() : name;
            String mappedName = resource.mappedName() != null && !resource.mappedName().trim().equals("") ? resource.mappedName() : null;
            Class<?> type = m.getParameterTypes()[0];
            Resource.AuthenticationType auth = resource.authenticationType();
            boolean shareable = resource.shareable();
            if (resource.type() != null && !resource.type().equals(Object.class) && !IntrospectionUtil.isTypeCompatible(type, (Class)resource.type(), (boolean)false)) {
                throw new IllegalStateException("@Resource incompatible type=" + resource.type() + " with method param=" + type + " for " + m);
            }
            Injection webXmlInjection = this._injections.getInjection(m.getDeclaringClass(), (Member)m);
            if (webXmlInjection == null) {
                try {
                    NamingEntryUtil.bindToENC((String)name, (String)mappedName);
                    Log.debug((String)("Bound " + (mappedName == null ? name : mappedName) + " as " + name));
                    Injection injection = new Injection();
                    injection.setTargetClass(m.getDeclaringClass());
                    injection.setJndiName(name);
                    injection.setMappingName(mappedName);
                    injection.setTarget((Member)m);
                    this._injections.add(injection);
                    continue;
                }
                catch (NamingException e) {
                    if (AnnotationProcessor.isEnvEntryType(type)) continue;
                    throw new IllegalStateException(e);
                }
            }
            Object value = webXmlInjection.lookupInjectedValue();
            if (IntrospectionUtil.isTypeCompatible(type, value.getClass(), (boolean)false)) continue;
            throw new IllegalStateException("Type of field=" + type + " is not compatible with Resource type=" + value.getClass());
        }
    }

    public void processFieldResourceAnnotations() throws Exception {
        List<Field> fields = this._finder.getFieldsForAnnotation(Resource.class);
        for (Field f : fields) {
            Resource resource = f.getAnnotation(Resource.class);
            if (resource == null) continue;
            if (Modifier.isStatic(f.getModifiers())) {
                throw new IllegalStateException(f + " cannot be static");
            }
            if (Modifier.isFinal(f.getModifiers())) {
                throw new IllegalStateException(f + " cannot be final");
            }
            String name = f.getDeclaringClass().getCanonicalName() + "/" + f.getName();
            name = resource.name() != null && !resource.name().trim().equals("") ? resource.name() : name;
            Class<?> type = f.getType();
            if (resource.type() != null && !resource.type().equals(Object.class) && !IntrospectionUtil.isTypeCompatible(type, (Class)resource.type(), (boolean)false)) {
                throw new IllegalStateException("@Resource incompatible type=" + resource.type() + " with field type =" + f.getType());
            }
            String mappedName = resource.mappedName() != null && !resource.mappedName().trim().equals("") ? resource.mappedName() : null;
            Resource.AuthenticationType auth = resource.authenticationType();
            boolean shareable = resource.shareable();
            Injection webXmlInjection = this._injections.getInjection(f.getDeclaringClass(), (Member)f);
            if (webXmlInjection == null) {
                try {
                    NamingEntryUtil.bindToENC((String)name, (String)mappedName);
                    Log.debug((String)("Bound " + (mappedName == null ? name : mappedName) + " as " + name));
                    Injection injection = new Injection();
                    injection.setTargetClass(f.getDeclaringClass());
                    injection.setJndiName(name);
                    injection.setMappingName(mappedName);
                    injection.setTarget((Member)f);
                    this._injections.add(injection);
                    continue;
                }
                catch (NamingException e) {
                    if (AnnotationProcessor.isEnvEntryType(type)) continue;
                    throw new IllegalStateException(e);
                }
            }
            Object value = webXmlInjection.lookupInjectedValue();
            if (IntrospectionUtil.isTypeCompatible(type, value.getClass(), (boolean)false)) continue;
            throw new IllegalStateException("Type of field=" + type + " is not compatible with Resource type=" + value.getClass());
        }
    }

    private Object getPojoInstanceFor(Class clazz) throws InstantiationException, IllegalAccessException {
        Object instance = this._pojoInstances.get(clazz);
        if (instance == null) {
            instance = clazz.newInstance();
            this._pojoInstances.put(clazz, instance);
        }
        return instance;
    }

    private static boolean isEnvEntryType(Class type) {
        boolean result = false;
        for (int i = 0; i < __envEntryTypes.length && !result; ++i) {
            result = type.equals(__envEntryTypes[i]);
        }
        return result;
    }

    protected static String normalizePattern(String p) {
        if (p != null && p.length() > 0 && !p.startsWith("/") && !p.startsWith("*")) {
            return "/" + p;
        }
        return p;
    }
}

