/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.annotations;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.annotation.Resources;
import javax.annotation.security.RunAs;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.servlet.Servlet;
import org.mortbay.jetty.plus.annotation.Injection;
import org.mortbay.jetty.plus.annotation.InjectionCollection;
import org.mortbay.jetty.plus.annotation.LifeCycleCallback;
import org.mortbay.jetty.plus.annotation.LifeCycleCallbackCollection;
import org.mortbay.jetty.plus.annotation.PostConstructCallback;
import org.mortbay.jetty.plus.annotation.PreDestroyCallback;
import org.mortbay.jetty.plus.annotation.RunAsCollection;
import org.mortbay.jetty.plus.naming.EnvEntry;
import org.mortbay.jetty.plus.naming.NamingEntry;
import org.mortbay.jetty.plus.naming.Transaction;
import org.mortbay.log.Log;
import org.mortbay.util.IntrospectionUtil;

public class AnnotationCollection {
    private Class _targetClass;
    private List _methods = new ArrayList();
    private List _fields = new ArrayList();
    private List _classes = new ArrayList();
    private static Class[] __envEntryTypes = new Class[]{String.class, Character.class, Integer.class, Boolean.class, Double.class, Byte.class, Short.class, Long.class, Float.class};

    public Class getTargetClass() {
        return this._targetClass;
    }

    public void setTargetClass(Class clazz) {
        this._targetClass = clazz;
    }

    public void addClass(Class clazz) {
        if (clazz.getDeclaredAnnotations().length == 0) {
            return;
        }
        this._classes.add(clazz);
    }

    public void addMethod(Method method) {
        if (method.getDeclaredAnnotations().length == 0) {
            return;
        }
        this._methods.add(method);
    }

    public void addField(Field field) {
        if (field.getDeclaredAnnotations().length == 0) {
            return;
        }
        this._fields.add(field);
    }

    public List getClasses() {
        return this._classes;
    }

    public List getMethods() {
        return this._methods;
    }

    public List getFields() {
        return this._fields;
    }

    public void processRunAsAnnotations(RunAsCollection runAsCollection) {
        for (int i = 0; i < this._classes.size(); ++i) {
            String role;
            RunAs runAs;
            Class clazz = (Class)this._classes.get(i);
            if (!Servlet.class.isAssignableFrom(clazz) || (runAs = clazz.getAnnotation(RunAs.class)) == null || (role = runAs.value()) == null) continue;
            org.mortbay.jetty.plus.annotation.RunAs ra = new org.mortbay.jetty.plus.annotation.RunAs();
            ra.setTargetClass(clazz);
            ra.setRoleName(role);
            runAsCollection.add(ra);
        }
    }

    public InjectionCollection processResourceAnnotations(InjectionCollection injections) {
        this.processClassResourceAnnotations();
        this.processMethodResourceAnnotations(injections);
        this.processFieldResourceAnnotations(injections);
        return injections;
    }

    public LifeCycleCallbackCollection processLifeCycleCallbackAnnotations(LifeCycleCallbackCollection callbacks) {
        this.processPostConstructAnnotations(callbacks);
        this.processPreDestroyAnnotations(callbacks);
        return callbacks;
    }

    public void processResourcesAnnotations() {
        for (int i = 0; i < this._classes.size(); ++i) {
            Resource[] resArray;
            Class clazz = (Class)this._classes.get(i);
            Resources resources = clazz.getAnnotation(Resources.class);
            if (resources == null || (resArray = resources.value()) == null || resArray.length == 0) continue;
            for (int j = 0; j < resArray.length; ++j) {
                String name = resArray[j].name();
                String mappedName = resArray[j].mappedName();
                Resource.AuthenticationType auth = resArray[j].authenticationType();
                Class type = resArray[j].type();
                boolean shareable = resArray[j].shareable();
                if (name == null || name.trim().equals("")) {
                    throw new IllegalStateException("Class level Resource annotations must contain a name (Common Annotations Spec Section 2.3)");
                }
                try {
                    if (type != null && AnnotationCollection.isEnvEntryType(type)) {
                        NamingEntry.bindToENC((String)(mappedName == null ? name : mappedName), (String)name, EnvEntry.class);
                        continue;
                    }
                    try {
                        NamingEntry.bindToENC((String)(mappedName == null ? name : mappedName), (String)name, org.mortbay.jetty.plus.naming.Resource.class);
                    }
                    catch (NameNotFoundException e) {
                        try {
                            NamingEntry.bindToENC((String)(mappedName == null ? name : mappedName), (String)name, EnvEntry.class);
                        }
                        catch (NameNotFoundException x) {
                            NamingEntry.bindToENC((String)(mappedName == null ? name : mappedName), (String)name, Transaction.class);
                        }
                    }
                    continue;
                }
                catch (NamingException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }

    private void processClassResourceAnnotations() {
        for (int i = 0; i < this._classes.size(); ++i) {
            Class clazz = (Class)this._classes.get(i);
            Resource resource = clazz.getAnnotation(Resource.class);
            if (resource == null) continue;
            String name = resource.name();
            String mappedName = resource.mappedName();
            Resource.AuthenticationType auth = resource.authenticationType();
            Class type = resource.type();
            boolean shareable = resource.shareable();
            if (name == null || name.trim().equals("")) {
                throw new IllegalStateException("Class level Resource annotations must contain a name (Common Annotations Spec Section 2.3)");
            }
            try {
                NamingEntry.bindToENC((String)(mappedName == null ? name : mappedName), (String)name, org.mortbay.jetty.plus.naming.Resource.class);
                continue;
            }
            catch (NamingException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private void processMethodResourceAnnotations(InjectionCollection webXmlInjections) {
        for (int i = 0; i < this._methods.size(); ++i) {
            Method m = (Method)this._methods.get(i);
            Resource resource = m.getAnnotation(Resource.class);
            if (resource == null) continue;
            if (Modifier.isStatic(m.getModifiers())) {
                throw new IllegalStateException(m + " cannot be static");
            }
            if (!IntrospectionUtil.isJavaBeanCompliantSetter((Method)m)) {
                throw new IllegalStateException(m + " is not a java bean compliant setter method");
            }
            String name = m.getName().substring(3);
            name = name.substring(0, 1).toLowerCase() + name.substring(1);
            name = m.getDeclaringClass().getCanonicalName() + "/" + name;
            name = resource.name() != null && !resource.name().trim().equals("") ? resource.name() : name;
            String mappedName = resource.mappedName() != null && !resource.mappedName().trim().equals("") ? resource.mappedName() : null;
            Class<?> type = m.getParameterTypes()[0];
            Resource.AuthenticationType auth = resource.authenticationType();
            boolean shareable = resource.shareable();
            if (resource.type() != null && !resource.type().equals(Object.class) && !IntrospectionUtil.isTypeCompatible(type, (Class)resource.type(), (boolean)false)) {
                throw new IllegalStateException("@Resource incompatible type=" + resource.type() + " with method param=" + type + " for " + m);
            }
            Injection webXmlInjection = webXmlInjections.getInjection(this.getTargetClass(), (Member)m);
            if (webXmlInjection == null) {
                try {
                    NamingEntry.bindToENC((String)(mappedName == null ? name : mappedName), (String)name, (Class)AnnotationCollection.getNamingEntryType(type));
                    Log.info((String)("Bound " + (mappedName == null ? name : mappedName) + " as " + name));
                    Injection injection = new Injection();
                    injection.setTargetClass(this.getTargetClass());
                    injection.setJndiName(name);
                    injection.setMappingName(mappedName);
                    injection.setTarget((Member)m);
                    webXmlInjections.add(injection);
                    continue;
                }
                catch (NamingException e) {
                    if (AnnotationCollection.isEnvEntryType(type)) continue;
                    throw new IllegalStateException(e);
                }
            }
            try {
                Object value = webXmlInjection.lookupInjectedValue();
                if (IntrospectionUtil.isTypeCompatible(type, value.getClass(), (boolean)false)) continue;
                throw new IllegalStateException("Type of field=" + type + " is not compatible with Resource type=" + value.getClass());
            }
            catch (NamingException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private void processFieldResourceAnnotations(InjectionCollection webXmlInjections) {
        for (int i = 0; i < this._fields.size(); ++i) {
            Field f = (Field)this._fields.get(i);
            Resource resource = f.getAnnotation(Resource.class);
            if (resource == null) continue;
            if (Modifier.isStatic(f.getModifiers())) {
                throw new IllegalStateException(f + " cannot be static");
            }
            if (Modifier.isFinal(f.getModifiers())) {
                throw new IllegalStateException(f + " cannot be final");
            }
            String name = f.getDeclaringClass().getCanonicalName() + "/" + f.getName();
            name = resource.name() != null && !resource.name().trim().equals("") ? resource.name() : name;
            Class<?> type = f.getType();
            if (resource.type() != null && !resource.type().equals(Object.class) && !IntrospectionUtil.isTypeCompatible(type, (Class)resource.type(), (boolean)false)) {
                throw new IllegalStateException("@Resource incompatible type=" + resource.type() + " with field type =" + f.getType());
            }
            String mappedName = resource.mappedName() != null && !resource.mappedName().trim().equals("") ? resource.mappedName() : null;
            Resource.AuthenticationType auth = resource.authenticationType();
            boolean shareable = resource.shareable();
            Injection webXmlInjection = webXmlInjections.getInjection(this.getTargetClass(), (Member)f);
            if (webXmlInjection == null) {
                try {
                    NamingEntry.bindToENC((String)(mappedName == null ? name : mappedName), (String)name, (Class)AnnotationCollection.getNamingEntryType(type));
                    Log.info((String)("Bound " + (mappedName == null ? name : mappedName) + " as " + name));
                    Injection injection = new Injection();
                    injection.setTargetClass(this.getTargetClass());
                    injection.setJndiName(name);
                    injection.setMappingName(mappedName);
                    injection.setTarget((Member)f);
                    webXmlInjections.add(injection);
                    continue;
                }
                catch (NamingException e) {
                    if (AnnotationCollection.isEnvEntryType(type)) continue;
                    throw new IllegalStateException(e);
                }
            }
            try {
                Object value = webXmlInjection.lookupInjectedValue();
                if (IntrospectionUtil.isTypeCompatible(type, value.getClass(), (boolean)false)) continue;
                throw new IllegalStateException("Type of field=" + type + " is not compatible with Resource type=" + value.getClass());
            }
            catch (NamingException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private void processPostConstructAnnotations(LifeCycleCallbackCollection callbacks) {
        for (int i = 0; i < this._methods.size(); ++i) {
            Method m = (Method)this._methods.get(i);
            if (!m.isAnnotationPresent(PostConstruct.class)) continue;
            if (m.getParameterTypes().length != 0) {
                throw new IllegalStateException(m + " has parameters");
            }
            if (m.getReturnType() != Void.TYPE) {
                throw new IllegalStateException(m + " is not void");
            }
            if (m.getExceptionTypes().length != 0) {
                throw new IllegalStateException(m + " throws checked exceptions");
            }
            if (Modifier.isStatic(m.getModifiers())) {
                throw new IllegalStateException(m + " is static");
            }
            PostConstructCallback callback = new PostConstructCallback();
            callback.setTargetClass(this.getTargetClass());
            callback.setTarget(m);
            callbacks.add((LifeCycleCallback)callback);
        }
    }

    private void processPreDestroyAnnotations(LifeCycleCallbackCollection callbacks) {
        for (int i = 0; i < this._methods.size(); ++i) {
            Method m = (Method)this._methods.get(i);
            if (!m.isAnnotationPresent(PreDestroy.class)) continue;
            if (m.getParameterTypes().length != 0) {
                throw new IllegalStateException(m + " has parameters");
            }
            if (m.getReturnType() != Void.TYPE) {
                throw new IllegalStateException(m + " is not void");
            }
            if (m.getExceptionTypes().length != 0) {
                throw new IllegalStateException(m + " throws checked exceptions");
            }
            if (Modifier.isStatic(m.getModifiers())) {
                throw new IllegalStateException(m + " is static");
            }
            PreDestroyCallback callback = new PreDestroyCallback();
            callback.setTargetClass(this.getTargetClass());
            callback.setTarget(m);
            callbacks.add((LifeCycleCallback)callback);
        }
    }

    private static boolean isEnvEntryType(Class type) {
        boolean result = false;
        for (int i = 0; i < __envEntryTypes.length && !result; ++i) {
            result = type.equals(__envEntryTypes[i]);
        }
        return result;
    }

    private static Class getNamingEntryType(Class type) {
        if (type == null) {
            return null;
        }
        if (AnnotationCollection.isEnvEntryType(type)) {
            return EnvEntry.class;
        }
        if (type.getName().equals("javax.transaction.UserTransaction")) {
            return Transaction.class;
        }
        return org.mortbay.jetty.plus.naming.Resource.class;
    }
}

