/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.annotations;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import org.mortbay.jetty.annotations.AnnotationCollection;
import org.mortbay.jetty.plus.annotation.InjectionCollection;
import org.mortbay.jetty.plus.annotation.LifeCycleCallbackCollection;
import org.mortbay.jetty.servlet.Holder;
import org.mortbay.log.Log;
import org.mortbay.util.IntrospectionUtil;

public class AnnotationProcessor {
    private HashMap annotationCollections = new HashMap();

    public void processClass(Class clazz) {
        if (clazz == null) {
            return;
        }
        AnnotationCollection collection = this.getAnnotationCollection(clazz);
        collection.addClass(clazz);
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            collection.addField(fields[i]);
        }
        Method[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            collection.addMethod(methods[i]);
        }
        Class ancestor = clazz.getSuperclass();
        while (!ancestor.equals(Object.class)) {
            this.processHierarchy(clazz, ancestor, collection);
            ancestor = ancestor.getSuperclass();
        }
    }

    public void processAnnotations(Holder holder, Class clazz, InjectionCollection webXmlInjections, LifeCycleCallbackCollection webXmlCallbacks) {
        if (clazz == null) {
            return;
        }
        AnnotationCollection collection = this.getAnnotationCollection(clazz);
        if (collection == null) {
            Log.warn((String)("No annotations for class " + clazz));
            return;
        }
        collection.processRunAsAnnotations(holder);
        collection.processResourcesAnnotations();
        collection.processResourceAnnotations(webXmlInjections);
        collection.processLifeCycleCallbackAnnotations(webXmlCallbacks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnnotationCollection getAnnotationCollection(Class clazz) {
        if (clazz == null) {
            return null;
        }
        Class<AnnotationProcessor> clazz2 = AnnotationProcessor.class;
        synchronized (AnnotationProcessor.class) {
            AnnotationCollection collection = (AnnotationCollection)this.annotationCollections.get(clazz);
            if (collection == null) {
                collection = new AnnotationCollection();
                collection.setTargetClass(clazz);
                this.annotationCollections.put(clazz, collection);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return collection;
        }
    }

    private void processHierarchy(Class targetClazz, Class ancestor, AnnotationCollection collection) {
        if (targetClazz == null) {
            return;
        }
        if (ancestor == null) {
            return;
        }
        collection.addClass(ancestor);
        Method[] methods = ancestor.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (methods[i].getAnnotations().length <= 0 || this.isOverriddenOrHidden(targetClazz, methods[i])) continue;
            collection.addMethod(methods[i]);
        }
        Field[] fields = ancestor.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i].getAnnotations().length <= 0 || this.isHidden(targetClazz, fields[i])) continue;
            collection.addField(fields[i]);
        }
    }

    private boolean isOverriddenOrHidden(Class derivedClass, Method superclassMethod) {
        if (Modifier.isPrivate(superclassMethod.getModifiers())) {
            return false;
        }
        if (Modifier.isPublic(superclassMethod.getModifiers()) || Modifier.isProtected(superclassMethod.getModifiers())) {
            boolean sameSig = false;
            for (Class c = derivedClass; c != superclassMethod.getDeclaringClass() && !sameSig; c = c.getSuperclass()) {
                sameSig = IntrospectionUtil.containsSameMethodSignature((Method)superclassMethod, (Class)c, (boolean)false);
            }
            return sameSig;
        }
        boolean sameSig = false;
        for (Class c = derivedClass; c != superclassMethod.getDeclaringClass() && !sameSig; c = c.getSuperclass()) {
            sameSig = IntrospectionUtil.containsSameMethodSignature((Method)superclassMethod, (Class)c, (boolean)true);
        }
        return sameSig;
    }

    private boolean isHidden(Class derivedClass, Field superclassField) {
        if (Modifier.isPrivate(superclassField.getModifiers())) {
            return false;
        }
        if (Modifier.isPublic(superclassField.getModifiers()) || Modifier.isProtected(superclassField.getModifiers())) {
            boolean hidden = false;
            Class c = derivedClass;
            while (!c.equals(superclassField.getDeclaringClass()) && !hidden) {
                hidden = IntrospectionUtil.containsSameFieldName((Field)superclassField, (Class)c, (boolean)false);
                c = c.getSuperclass();
            }
            return hidden;
        }
        boolean hidden = false;
        Class c = derivedClass;
        while (!c.equals(superclassField.getDeclaringClass()) && !hidden) {
            hidden = IntrospectionUtil.containsSameFieldName((Field)superclassField, (Class)c, (boolean)true);
        }
        return hidden;
    }
}

