/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.maven.h2spec;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.surefire.report.ReportTestCase;
import org.apache.maven.plugins.surefire.report.ReportTestSuite;
import org.apache.maven.plugins.surefire.report.SurefireReportParser;
import org.apache.maven.reporting.MavenReportException;
import org.mortbay.jetty.maven.h2spec.Failure;

public class H2SpecTestSuite {
    public static final String DEFAULT_VERSION = "2.6.0";

    public static String getSpecIdentifier(String specId, String name) {
        return specId + " - " + name;
    }

    public static List<Failure> parseReports(Log logger, File reportsDirectory, Set<String> excludeSpecs) {
        logger.debug((CharSequence)"Parsing h2spec reports");
        SurefireReportParser parser = new SurefireReportParser(Collections.singletonList(reportsDirectory), Locale.getDefault());
        String currentPackageName = "";
        ArrayList<Failure> failures = new ArrayList<Failure>();
        try {
            List parsedReports = parser.parseXMLReportFiles();
            logger.debug((CharSequence)(parsedReports.size() + " h2spec reports parsed."));
            for (ReportTestSuite parsedReport : parsedReports) {
                String name = parsedReport.getFullClassName();
                String specIdentifier = H2SpecTestSuite.getSpecIdentifier(currentPackageName, name);
                logger.debug((CharSequence)("Spec Identifier [" + specIdentifier + "]"));
                String packageName = parsedReport.getPackageName();
                if (packageName.length() > 0) {
                    currentPackageName = packageName;
                }
                if (parsedReport.getNumberOfErrors() <= 0) continue;
                for (ReportTestCase reportTestCase : parsedReport.getTestCases()) {
                    String failureDetail = reportTestCase.getFailureDetail();
                    if (failureDetail != null) {
                        String[] failureTokens = failureDetail.split("\n");
                        boolean ignored = excludeSpecs.contains(specIdentifier);
                        if (ignored) {
                            logger.debug((CharSequence)("Case Status: FAILED [" + specIdentifier + "] (ignored by excludeSpec): " + failureDetail));
                        } else {
                            logger.debug((CharSequence)("Case Status: FAILED: [" + specIdentifier + "] " + failureDetail));
                        }
                        String expected = failureTokens.length > 0 ? failureTokens[0] : "";
                        String actual = "";
                        int last = failureTokens.length - 1;
                        if (last > 0) {
                            actual = failureTokens[last];
                        }
                        failures.add(new Failure(name, currentPackageName, actual, expected, ignored));
                        continue;
                    }
                    logger.debug((CharSequence)"Case Status: SUCCESS");
                }
            }
        }
        catch (MavenReportException e) {
            logger.warn((CharSequence)e.getMessage(), (Throwable)e);
        }
        return failures;
    }
}

