/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.mortbay.cometd.Bayeux;
import org.mortbay.cometd.ChannelId;
import org.mortbay.cometd.Client;
import org.mortbay.cometd.DataFilter;
import org.mortbay.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Channel {
    private Bayeux _bayeux;
    private CopyOnWriteArrayList<Client> _subscribers = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<DataFilter> _dataFilters = new CopyOnWriteArrayList();
    private ChannelId _id;
    private ConcurrentMap<String, Channel> _children = new ConcurrentHashMap<String, Channel>();
    private Channel _wild;
    private Channel _wildWild;

    Channel(String id, Bayeux bayeux) {
        this._id = new ChannelId(id);
        this._bayeux = bayeux;
    }

    public void addChild(Channel channel) {
        ChannelId child = channel.getId();
        if (!this._id.isParentOf(child)) {
            throw new IllegalArgumentException(this._id + " not parent of " + child);
        }
        String next = child.getSegment(this._id.depth());
        if (child.depth() - this._id.depth() == 1) {
            Channel old = this._children.putIfAbsent(next, channel);
            if (old != null) {
                throw new IllegalArgumentException("Already Exists");
            }
            if ("*".equals(next)) {
                this._wild = channel;
            } else if ("**".equals(next)) {
                this._wildWild = channel;
            }
        } else {
            Channel branch = (Channel)this._children.get(next);
            branch = this._bayeux.getChannel((this._id.depth() == 0 ? "/" : this._id.toString() + "/") + next, true);
            branch.addChild(channel);
        }
    }

    public void addSubscriber(Client client) {
        client.addSubscription(this);
        this._subscribers.add(client);
    }

    public void addDataFilter(DataFilter filter) {
        this._dataFilters.add(filter);
    }

    public void removeDataFilter(DataFilter filter) {
        this._dataFilters.remove(filter);
    }

    public ChannelId getId() {
        return this._id;
    }

    public void removeSubscriber(Client client) {
        this._subscribers.remove(client);
        client.removeSubscription(this);
    }

    public void publish(ChannelId to, Client from, Map<String, Object> msg) {
        Object data;
        int tail = to.depth() - this._id.depth();
        Object old = data = msg.get("data");
        try {
            switch (tail) {
                case 0: {
                    for (DataFilter filter : this._dataFilters) {
                        data = filter.filter(from, this, data);
                    }
                    break;
                }
                case 1: {
                    if (this._wild != null) {
                        for (DataFilter filter : this._wild._dataFilters) {
                            data = filter.filter(from, this, data);
                        }
                    }
                }
                default: {
                    if (this._wildWild != null) {
                        for (DataFilter filter : this._wildWild._dataFilters) {
                            data = filter.filter(from, this, data);
                        }
                    }
                }
            }
        }
        catch (IllegalStateException e) {
            Log.debug((Throwable)e);
            return;
        }
        if (data != old) {
            msg.put("data", data);
        }
        boolean delivered = false;
        switch (tail) {
            case 0: {
                for (Client client : this._subscribers) {
                    client.deliver(from, to, msg);
                    delivered = true;
                }
                break;
            }
            case 1: {
                if (this._wild != null) {
                    for (Client subscriber : this._wild._subscribers) {
                        subscriber.deliver(from, to, msg);
                        delivered = true;
                    }
                }
            }
            default: {
                String next;
                Channel channel;
                if (this._wildWild != null) {
                    for (Client subscriber : this._wildWild._subscribers) {
                        subscriber.deliver(from, to, msg);
                        delivered = true;
                    }
                }
                if ((channel = (Channel)this._children.get(next = to.getSegment(this._id.depth()))) == null) break;
                if (delivered) {
                    msg = new HashMap<String, Object>(msg);
                }
                channel.publish(to, from, msg);
            }
        }
    }

    public String getToken(Client client, boolean subscribe, boolean send, boolean oneTime) {
        String token = Long.toString(this._bayeux.getRandom(client.hashCode()), 36);
        return token;
    }

    public String toString() {
        return this._id.toString();
    }

    public Channel getChild(ChannelId id) {
        String next = id.getSegment(this._id.depth());
        if (next == null) {
            return null;
        }
        Channel channel = (Channel)this._children.get(next);
        if (channel == null || channel.getId().depth() == id.depth()) {
            return channel;
        }
        return channel.getChild(id);
    }
}

