/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import org.mortbay.cometd.Channel;
import org.mortbay.cometd.ChannelId;
import org.mortbay.cometd.Client;
import org.mortbay.cometd.DataFilter;
import org.mortbay.cometd.JSONPTransport;
import org.mortbay.cometd.JSONTransport;
import org.mortbay.cometd.SecurityPolicy;
import org.mortbay.cometd.Transport;
import org.mortbay.util.DateCache;
import org.mortbay.util.ajax.JSON;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bayeux {
    public static final String META_CONNECT = "/meta/connect";
    public static final String META_DISCONNECT = "/meta/disconnect";
    public static final String META_HANDSHAKE = "/meta/handshake";
    public static final String META_PING = "/meta/ping";
    public static final String META_RECONNECT = "/meta/reconnect";
    public static final String META_STATUS = "/meta/status";
    public static final String META_SUBSCRIBE = "/meta/subscribe";
    public static final String META_UNSUBSCRIBE = "/meta/unsubscribe";
    public static final ChannelId META_CONNECT_ID = new ChannelId("/meta/connect");
    public static final ChannelId META_DISCONNECT_ID = new ChannelId("/meta/disconnect");
    public static final ChannelId META_HANDSHAKE_ID = new ChannelId("/meta/handshake");
    public static final ChannelId META_PING_ID = new ChannelId("/meta/ping");
    public static final ChannelId META_RECONNECT_ID = new ChannelId("/meta/reconnect");
    public static final ChannelId META_STATUS_ID = new ChannelId("/meta/status");
    public static final ChannelId META_SUBSCRIBE_ID = new ChannelId("/meta/subscribe");
    public static final ChannelId META_UNSUBSCRIBE_ID = new ChannelId("/meta/unsubscribe");
    public static final String CLIENT_FIELD = "clientId";
    public static final String DATA_FIELD = "data";
    public static final String CHANNEL_FIELD = "channel";
    public static final String ID_FIELD = "id";
    public static final String TIMESTAMP_FIELD = "timestamp";
    public static final String TRANSPORT_FIELD = "transport";
    public static final String ADVICE_FIELD = "advice";
    public static final String SUCCESSFUL_FIELD = "successful";
    public static final String SUBSCRIPTION_FIELD = "subscription";
    public static final String EXT_FIELD = "ext";
    private static final JSON.Literal EXT_JSON_COMMENTED = new JSON.Literal("{\"json-comment-filtered\":true}");
    private static HashMap<String, Class> _transports = new HashMap();
    HashMap<String, Handler> _handlers = new HashMap();
    public static final JSON.Literal TRANSPORTS;
    private static final JSON.Literal __NO_ADVICE;
    Channel _root = new Channel("/", this);
    ConcurrentHashMap<String, Client> _clients = new ConcurrentHashMap();
    SecurityPolicy _securityPolicy = new DefaultPolicy();
    Object _advice = new JSON.Literal("{\"reconnect\":\"retry\",\"interval\":0}");
    Object _unknownAdvice = new JSON.Literal("{\"reconnect\":\"handshake\",\"interval\":500}");
    int _logLevel;
    long _clientTimeoutMs = 60000L;
    boolean _JSONCommented;
    transient Timer _clientTimer;
    transient ServletContext _context;
    transient Random _random;
    transient DateCache _dateCache;
    transient ConcurrentHashMap<String, ChannelId> _channelIdCache;

    protected Bayeux() {
        this._handlers.put("*", new PublishHandler());
        this._handlers.put(META_HANDSHAKE, new HandshakeHandler());
        this._handlers.put(META_CONNECT, new ConnectHandler());
        this._handlers.put(META_RECONNECT, new ReconnectHandler());
        this._handlers.put(META_DISCONNECT, new DisconnectHandler());
        this._handlers.put(META_SUBSCRIBE, new SubscribeHandler());
        this._handlers.put(META_UNSUBSCRIBE, new UnsubscribeHandler());
        this._handlers.put(META_STATUS, new StatusHandler());
        this._handlers.put(META_PING, new PingHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialize(ServletContext context) {
        Bayeux bayeux = this;
        synchronized (bayeux) {
            this._context = context;
            try {
                this._random = SecureRandom.getInstance("SHA1PRNG");
            }
            catch (Exception e) {
                context.log("Could not get secure random for ID generation", (Throwable)e);
                this._random = new Random();
            }
            this._random.setSeed(this._random.nextLong() ^ (long)this.hashCode() ^ (long)(context.hashCode() << 32) ^ Runtime.getRuntime().freeMemory());
            this._dateCache = new DateCache();
            this._clientTimer = new Timer();
            this._channelIdCache = new ConcurrentHashMap();
        }
    }

    public ChannelId getChannelId(String id) {
        ChannelId cid = this._channelIdCache.get(id);
        if (cid == null) {
            cid = new ChannelId(id);
            this._channelIdCache.put(id, cid);
        }
        return cid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilter(String channels, DataFilter filter) {
        Bayeux bayeux = this;
        synchronized (bayeux) {
            Channel channel = this.getChannel(channels, true);
            channel.addDataFilter(filter);
        }
    }

    public Channel getChannel(String id) {
        ChannelId cid = this.getChannelId(id);
        if (cid.depth() == 0) {
            return null;
        }
        return this._root.getChild(cid);
    }

    public Channel getChannel(ChannelId id) {
        return this._root.getChild(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel getChannel(String id, boolean create) {
        Bayeux bayeux = this;
        synchronized (bayeux) {
            Channel channel = this.getChannel(id);
            if (channel == null && create) {
                channel = new Channel(id, this);
                this._root.addChild(channel);
                if (this.isLogInfo()) {
                    this.logInfo("newChannel: " + channel);
                }
            }
            return channel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Client getClient(String client_id) {
        Bayeux bayeux = this;
        synchronized (bayeux) {
            if (client_id == null) {
                return null;
            }
            Client client = this._clients.get(client_id);
            return client;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Client removeClient(String client_id) {
        Client client;
        Bayeux bayeux = this;
        synchronized (bayeux) {
            if (client_id == null) {
                return null;
            }
            client = this._clients.remove(client_id);
        }
        if (client != null) {
            client.unsubscribeAll();
        }
        return client;
    }

    protected Client newClient(String idPrefix) {
        return new Client(this, idPrefix);
    }

    public Set getClientIDs() {
        return this._clients.keySet();
    }

    String getTimeOnServer() {
        return this._dateCache.format(System.currentTimeMillis());
    }

    public Transport newTransport(Client client, Map message) {
        if (this.isLogDebug()) {
            this.logDebug("newTransport: client=" + client + ",message=" + message);
        }
        Transport result = null;
        try {
            Class trans_class;
            String jsonp;
            String type;
            String string = type = client == null ? null : client.getConnectionType();
            if (type == null) {
                type = (String)message.get("connectionType");
            }
            if (type == null && (jsonp = (String)message.get("jsonp")) != null) {
                if (this.isLogDebug()) {
                    this.logDebug("newTransport: using JSONPTransport with jsonp=" + jsonp);
                }
                result = new JSONPTransport(client != null && client.isJSONCommented());
                ((JSONPTransport)result).setJsonp(jsonp);
            }
            if (type != null && result == null && (trans_class = _transports.get(type)) != null) {
                if (trans_class.equals(JSONPTransport.class)) {
                    String jsonp2 = (String)message.get("jsonp");
                    if (jsonp2 == null) {
                        throw new Exception("JSONPTransport needs jsonp parameter");
                    }
                    result = new JSONPTransport(client != null && client.isJSONCommented());
                    ((JSONPTransport)result).setJsonp(jsonp2);
                } else {
                    result = (Transport)trans_class.newInstance();
                    result.setJSONCommented(client != null && client.isJSONCommented());
                }
            }
            if (result == null) {
                result = new JSONTransport(client != null && client.isJSONCommented());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.isLogDebug()) {
            this.logDebug("newTransport: result=" + result);
        }
        return result;
    }

    public void handle(Client client, Transport transport, Map<String, Object> message) throws IOException {
        String METHOD = "handle: ";
        String channel_id = (String)message.get(CHANNEL_FIELD);
        Handler handler = this._handlers.get(channel_id);
        if (handler == null) {
            handler = this._handlers.get("*");
        }
        if (this.isLogDebug()) {
            this.logDebug("handle: handler=" + handler);
        }
        handler.handle(client, transport, message);
    }

    public void publish(ChannelId to, Client from, Object data, String msgId) {
        HashMap<String, Object> msg = new HashMap<String, Object>();
        msg.put(CHANNEL_FIELD, to.toString());
        msg.put(TIMESTAMP_FIELD, this.getTimeOnServer());
        if (msgId == null) {
            long id = msg.hashCode() ^ (to == null ? 0 : to.hashCode()) ^ (from == null ? 0 : from.hashCode());
            id = id < 0L ? -id : id;
            msg.put(ID_FIELD, Long.toString(id, 36));
        }
        msg.put(DATA_FIELD, data);
        this._root.publish(to, from, msg);
    }

    void advise(Client client, Transport transport, Object advice) throws IOException {
        if (advice == null) {
            advice = this._advice;
        }
        if (advice == null) {
            advice = __NO_ADVICE;
        }
        String channel = "/meta/connections/" + client.getId();
        HashMap<String, Object> reply = new HashMap<String, Object>();
        reply.put(CHANNEL_FIELD, channel);
        reply.put(TIMESTAMP_FIELD, this._dateCache.format(System.currentTimeMillis()));
        reply.put(SUCCESSFUL_FIELD, Boolean.TRUE);
        reply.put(ADVICE_FIELD, advice);
        transport.send(reply);
    }

    long getRandom(long variation) {
        long l = this._random.nextLong() ^ variation;
        return l < 0L ? -l : l;
    }

    public SecurityPolicy getSecurityPolicy() {
        return this._securityPolicy;
    }

    public void setSecurityPolicy(SecurityPolicy securityPolicy) {
        this._securityPolicy = securityPolicy;
    }

    public int getLogLevel() {
        return this._logLevel;
    }

    public void setLogLevel(int logLevel) {
        this._logLevel = logLevel;
    }

    public boolean isLogInfo() {
        return this._logLevel > 0;
    }

    public boolean isLogDebug() {
        return this._logLevel > 1;
    }

    public void logInfo(String message) {
        if (this._logLevel > 0) {
            this._context.log(message);
        }
    }

    public void logDebug(String message) {
        if (this._logLevel > 1) {
            this._context.log(message);
        }
    }

    public void logDebug(String message, Throwable th) {
        if (this._logLevel > 1) {
            this._context.log(message, th);
        }
    }

    public long getClientTimeoutMs() {
        return this._clientTimeoutMs;
    }

    public void setClientTimeoutMs(long ms) {
        this._clientTimeoutMs = ms;
    }

    public boolean isJSONCommented() {
        return this._JSONCommented;
    }

    public void setJSONCommented(boolean commented) {
        this._JSONCommented = commented;
    }

    static {
        _transports.put("long-polling", JSONTransport.class);
        _transports.put("callback-polling", JSONPTransport.class);
        TRANSPORTS = new JSON.Literal("[\"long-polling\",\"callback-polling\"]");
        __NO_ADVICE = new JSON.Literal("{}");
    }

    private static class DefaultPolicy
    implements SecurityPolicy {
        private DefaultPolicy() {
        }

        public boolean canCreate(Client client, ChannelId channel, Map message) {
            return client != null && !"meta".equals(channel.getSegment(0));
        }

        public boolean canSubscribe(Client client, ChannelId channel, Map message) {
            return client != null && !"meta".equals(channel.getSegment(0));
        }

        public boolean canSend(Client client, ChannelId channel, Map message) {
            return client != null && !"meta".equals(channel.getSegment(0));
        }

        public boolean authenticate(String scheme, String user, String credentials) {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UnsubscribeHandler
    implements Handler {
        private UnsubscribeHandler() {
        }

        @Override
        public void handle(Client client, Transport transport, Map<String, Object> message) throws IOException {
            if (client == null) {
                return;
            }
            Bayeux.this._root.publish(META_UNSUBSCRIBE_ID, client, message);
            String channel_id = (String)message.get(Bayeux.SUBSCRIPTION_FIELD);
            Channel channel = Bayeux.this.getChannel(channel_id);
            if (channel != null) {
                channel.removeSubscriber(client);
            }
            HashMap<String, Object> reply = new HashMap<String, Object>();
            reply.put(Bayeux.CHANNEL_FIELD, channel_id);
            reply.put(Bayeux.SUBSCRIPTION_FIELD, channel.getId());
            reply.put(Bayeux.SUCCESSFUL_FIELD, Boolean.TRUE);
            reply.put("error", "");
            transport.send(reply);
            Bayeux.this._root.publish(META_UNSUBSCRIBE_ID, client, reply);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SubscribeHandler
    implements Handler {
        private SubscribeHandler() {
        }

        @Override
        public void handle(Client client, Transport transport, Map<String, Object> message) throws IOException {
            if (client == null) {
                throw new IllegalStateException("No client");
            }
            Bayeux.this._root.publish(META_SUBSCRIBE_ID, client, message);
            String subscribe_id = (String)message.get(Bayeux.SUBSCRIPTION_FIELD);
            if (subscribe_id == null) {
                subscribe_id = Long.toString(Bayeux.this.getRandom(((Object)message).hashCode() ^ client.hashCode()), 36);
                while (Bayeux.this.getChannel(subscribe_id) != null) {
                    subscribe_id = Long.toString(Bayeux.this.getRandom(((Object)message).hashCode() ^ client.hashCode()), 36);
                }
            }
            ChannelId cid = Bayeux.this.getChannelId(subscribe_id);
            HashMap<String, Object> reply = new HashMap<String, Object>();
            reply.put(Bayeux.CHANNEL_FIELD, Bayeux.META_SUBSCRIBE);
            reply.put(Bayeux.SUBSCRIPTION_FIELD, subscribe_id);
            if (Bayeux.this._securityPolicy.canSubscribe(client, cid, message)) {
                Channel channel = Bayeux.this.getChannel(cid);
                if (channel == null && Bayeux.this._securityPolicy.canCreate(client, cid, message)) {
                    channel = Bayeux.this.getChannel(subscribe_id, true);
                }
                if (channel != null) {
                    channel.addSubscriber(client);
                    reply.put(Bayeux.SUCCESSFUL_FIELD, Boolean.TRUE);
                    reply.put("error", "");
                } else {
                    reply.put(Bayeux.SUCCESSFUL_FIELD, Boolean.FALSE);
                    reply.put("error", "cannot create");
                }
            } else {
                reply.put(Bayeux.SUCCESSFUL_FIELD, Boolean.FALSE);
                reply.put("error", "cannot subscribe");
            }
            transport.send(reply);
            Bayeux.this._root.publish(META_SUBSCRIBE_ID, client, reply);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StatusHandler
    implements Handler {
        private StatusHandler() {
        }

        @Override
        public void handle(Client client, Transport transport, Map<String, Object> message) throws IOException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReconnectHandler
    implements Handler {
        private ReconnectHandler() {
        }

        @Override
        public void handle(Client client, Transport transport, Map<String, Object> message) throws IOException {
            Bayeux.this._root.publish(META_RECONNECT_ID, client, message);
            HashMap<String, Object> reply = new HashMap<String, Object>();
            reply.put(Bayeux.CHANNEL_FIELD, Bayeux.META_RECONNECT);
            reply.put(Bayeux.TIMESTAMP_FIELD, Bayeux.this._dateCache.format(System.currentTimeMillis()));
            if (client == null) {
                reply.put(Bayeux.SUCCESSFUL_FIELD, Boolean.FALSE);
                reply.put("error", "unknown clientID");
                if (Bayeux.this._unknownAdvice != null) {
                    reply.put(Bayeux.ADVICE_FIELD, Bayeux.this._unknownAdvice);
                }
                transport.setPolling(false);
                transport.send(reply);
            } else {
                String type = (String)message.get("connectionType");
                if (type != null) {
                    if (Bayeux.this.isLogDebug()) {
                        Bayeux.this.logDebug("Reconnect.handle: old connectionType=" + client.getConnectionType());
                    }
                    if (client.getConnectionType().equals("callback-polling")) {
                        if (Bayeux.this.isLogDebug()) {
                            Bayeux.this.logDebug("Reconnect.handle: connectionType remains callback-polling");
                        }
                    } else {
                        client.setConnectionType(type);
                        if (Bayeux.this.isLogDebug()) {
                            Bayeux.this.logDebug("Reconnect.handle: connectionType reset to " + type);
                        }
                    }
                }
                reply.put(Bayeux.SUCCESSFUL_FIELD, Boolean.TRUE);
                reply.put("error", "");
                transport.setPolling(true);
                transport.send(reply);
            }
            Bayeux.this._root.publish(META_RECONNECT_ID, client, reply);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PingHandler
    implements Handler {
        private PingHandler() {
        }

        @Override
        public void handle(Client client, Transport transport, Map<String, Object> message) throws IOException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HandshakeHandler
    implements Handler {
        private HandshakeHandler() {
        }

        @Override
        public void handle(Client client, Transport transport, Map<String, Object> message) throws IOException {
            if (Bayeux.this.isLogDebug()) {
                Bayeux.this.logDebug("handshake.handle: client=" + client + ",transport=" + transport + ",message=" + message);
            }
            if (client != null) {
                throw new IllegalStateException();
            }
            Bayeux.this._root.publish(META_HANDSHAKE_ID, client, message);
            if (Bayeux.this._securityPolicy.authenticate((String)message.get("authScheme"), (String)message.get("authUser"), (String)message.get("authToken"))) {
                client = Bayeux.this.newClient(null);
            }
            Map ext = (Map)message.get(Bayeux.EXT_FIELD);
            boolean commented = Bayeux.this._JSONCommented && ext != null && (Boolean)ext.get("json-comment-filtered") != false;
            HashMap<String, Object> reply = new HashMap<String, Object>();
            reply.put(Bayeux.CHANNEL_FIELD, Bayeux.META_HANDSHAKE);
            reply.put("version", new Double(0.1));
            reply.put("minimumVersion", new Double(0.1));
            if (Bayeux.this.isJSONCommented()) {
                reply.put(Bayeux.EXT_FIELD, EXT_JSON_COMMENTED);
            }
            if (client != null) {
                reply.put("supportedConnectionTypes", TRANSPORTS);
                reply.put("authSuccessful", Boolean.TRUE);
                reply.put(Bayeux.CLIENT_FIELD, client.getId());
                if (Bayeux.this._advice != null) {
                    reply.put(Bayeux.ADVICE_FIELD, Bayeux.this._advice);
                }
                client.setJSONCommented(commented);
                transport.setJSONCommented(commented);
            } else {
                reply.put("authSuccessful", Boolean.FALSE);
                if (Bayeux.this._advice != null) {
                    reply.put(Bayeux.ADVICE_FIELD, Bayeux.this._advice);
                }
            }
            if (Bayeux.this.isLogDebug()) {
                Bayeux.this.logDebug("handshake.handle: reply=" + reply);
            }
            transport.send(reply);
            Bayeux.this._root.publish(META_HANDSHAKE_ID, client, reply);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DisconnectHandler
    implements Handler {
        private DisconnectHandler() {
        }

        @Override
        public void handle(Client client, Transport transport, Map<String, Object> message) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PublishHandler
    implements Handler {
        private PublishHandler() {
        }

        @Override
        public void handle(Client client, Transport transport, Map<String, Object> message) throws IOException {
            String channel_id = (String)message.get(Bayeux.CHANNEL_FIELD);
            String id = (String)message.get(Bayeux.ID_FIELD);
            ChannelId cid = Bayeux.this.getChannelId(channel_id);
            Object data = message.get(Bayeux.DATA_FIELD);
            if (client == null && Bayeux.this._securityPolicy.authenticate((String)message.get("authScheme"), (String)message.get("authUser"), (String)message.get("authToken"))) {
                client = Bayeux.this.newClient(null);
            }
            HashMap<String, Object> reply = new HashMap<String, Object>();
            reply.put(Bayeux.CHANNEL_FIELD, channel_id);
            if (id != null) {
                reply.put(Bayeux.ID_FIELD, id);
            }
            if (data != null && Bayeux.this._securityPolicy.canSend(client, cid, message)) {
                Bayeux.this.publish(cid, client, data, id);
                reply.put(Bayeux.SUCCESSFUL_FIELD, Boolean.TRUE);
                reply.put("error", "");
            } else {
                reply.put(Bayeux.SUCCESSFUL_FIELD, Boolean.FALSE);
                reply.put("error", "unknown channel");
            }
            transport.send(reply);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConnectHandler
    implements Handler {
        private ConnectHandler() {
        }

        @Override
        public void handle(Client client, Transport transport, Map<String, Object> message) throws IOException {
            Channel connection;
            String METHOD = "handle: ";
            if (client == null) {
                throw new IllegalStateException("No client");
            }
            HashMap<String, Object> reply = new HashMap<String, Object>();
            reply.put(Bayeux.CHANNEL_FIELD, Bayeux.META_CONNECT);
            String type = (String)message.get("connectionType");
            client.setConnectionType(type);
            if (Bayeux.this.isLogDebug()) {
                Bayeux.this.logDebug("handle: connectionType set to " + type);
            }
            if ((connection = client.connect()) != null) {
                reply.put(Bayeux.SUCCESSFUL_FIELD, Boolean.TRUE);
                reply.put("error", "");
            } else {
                reply.put(Bayeux.SUCCESSFUL_FIELD, Boolean.FALSE);
                reply.put("error", "unknown client ID");
                if (Bayeux.this._unknownAdvice != null) {
                    reply.put(Bayeux.ADVICE_FIELD, Bayeux.this._unknownAdvice);
                }
            }
            reply.put(Bayeux.TIMESTAMP_FIELD, Bayeux.this._dateCache.format(System.currentTimeMillis()));
            transport.send(reply);
            transport.setPolling(false);
            Bayeux.this._root.publish(META_CONNECT_ID, client, reply);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Handler {
        public void handle(Client var1, Transport var2, Map<String, Object> var3) throws IOException;
    }
}

