/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.cometd.Bayeux;
import org.mortbay.cometd.DataFilter;
import org.mortbay.cometd.filter.JSONDataFilter;
import org.mortbay.util.ajax.JSON;

public abstract class AbstractCometdServlet
extends HttpServlet {
    private static final long serialVersionUID = 7376511945687140178L;
    public static final String ORG_MORTBAY_BAYEUX = "org.mortbay.bayeux";
    public static final String CLIENT_ATTR = "org.mortbay.cometd.client";
    public static final String TRANSPORT_ATTR = "org.mortbay.cometd.transport";
    public static final String MESSAGE_PARAM = "message";
    public static final String TUNNEL_INIT_PARAM = "tunnelInit";
    public static final String HTTP_CLIENT_ID = "BAYEUX_HTTP_CLIENT";
    protected Bayeux _bayeux;
    protected long _timeout = 45000L;

    public Bayeux getBayeux() {
        return this._bayeux;
    }

    protected abstract Bayeux newBayeux();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws ServletException {
        Object object = AbstractCometdServlet.class;
        synchronized (AbstractCometdServlet.class) {
            if (this._bayeux == null) {
                this._bayeux = (Bayeux)this.getServletContext().getAttribute(ORG_MORTBAY_BAYEUX);
                if (this._bayeux == null) {
                    this._bayeux = this.newBayeux();
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            object = this._bayeux;
            synchronized (object) {
                String timeout;
                this._bayeux.initialize(this.getServletContext());
                this.getServletContext().setAttribute(ORG_MORTBAY_BAYEUX, (Object)this._bayeux);
                String filters = this.getInitParameter("filters");
                if (filters != null) {
                    try {
                        Object[] objects = (Object[])JSON.parse((InputStream)this.getServletContext().getResourceAsStream(filters));
                        for (int i = 0; objects != null && i < objects.length; ++i) {
                            Map filter_def = (Map)objects[i];
                            Class<?> c = Thread.currentThread().getContextClassLoader().loadClass((String)filter_def.get("class"));
                            DataFilter filter = (DataFilter)c.newInstance();
                            if (filter instanceof JSONDataFilter) {
                                ((JSONDataFilter)filter).init(filter_def.get("init"));
                            }
                            this._bayeux.addFilter((String)filter_def.get("channels"), filter);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.getServletContext().log("Could not parse: " + filters, (Throwable)e);
                        throw new ServletException((Throwable)e);
                    }
                }
                if ((timeout = this.getInitParameter("timeout")) != null) {
                    this._timeout = Long.parseLong(timeout);
                }
                this._bayeux.setClientTimeoutMs(this._timeout * 3L / 2L);
                String commentedJSON = this.getInitParameter("JSONCommented");
                this._bayeux.setJSONCommented(commentedJSON != null && Boolean.parseBoolean(commentedJSON));
                String l = this.getInitParameter("logLevel");
                if (l != null && l.length() > 0) {
                    this._bayeux.setLogLevel(Integer.parseInt(l));
                }
            }
            return;
        }
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String init = req.getParameter(TUNNEL_INIT_PARAM);
        if ("iframe".equals(init)) {
            throw new IllegalStateException("Not supported");
        }
        super.service(req, resp);
    }
}

