/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.cometd.Bayeux;
import org.mortbay.cometd.Client;
import org.mortbay.cometd.ContinuationBayeux;
import org.mortbay.cometd.ContinuationClient;
import org.mortbay.cometd.DataFilter;
import org.mortbay.cometd.JSONPTransport;
import org.mortbay.cometd.PlainTextJSONTransport;
import org.mortbay.cometd.Transport;
import org.mortbay.util.ajax.Continuation;
import org.mortbay.util.ajax.ContinuationSupport;
import org.mortbay.util.ajax.JSON;

public class CometdServlet
extends HttpServlet {
    private static final long serialVersionUID = 7376511945687140178L;
    public static final String ORG_MORTBAY_BAYEUX = "org.mortbay.bayeux";
    public static final String CLIENT_ATTR = "org.mortbay.cometd.client";
    public static final String MESSAGE_PARAM = "message";
    public static final String TUNNEL_INIT_PARAM = "tunnelInit";
    public static final String BROWSER_ID = "bayeuxBID";
    private Bayeux _bayeux;
    private long _timeout = 45000L;
    private boolean _verbose;
    private boolean _rpcSupport;

    public Bayeux getBayeux() {
        return this._bayeux;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws ServletException {
        Object object = CometdServlet.class;
        synchronized (CometdServlet.class) {
            if (this._bayeux == null) {
                this._bayeux = (Bayeux)this.getServletContext().getAttribute(ORG_MORTBAY_BAYEUX);
                if (this._bayeux == null) {
                    this._bayeux = new ContinuationBayeux();
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            object = this._bayeux;
            synchronized (object) {
                String l;
                String rpcSupport;
                String timeout;
                this._bayeux.initialize(this.getServletContext());
                this.getServletContext().setAttribute(ORG_MORTBAY_BAYEUX, (Object)this._bayeux);
                String filters = this.getInitParameter("filters");
                if (filters != null) {
                    try {
                        Object[] objects = (Object[])JSON.parse((InputStream)this.getServletContext().getResourceAsStream(filters));
                        for (int i = 0; objects != null && i < objects.length; ++i) {
                            Map filter_def = (Map)objects[i];
                            Class<?> c = Thread.currentThread().getContextClassLoader().loadClass((String)filter_def.get("class"));
                            DataFilter filter = (DataFilter)c.newInstance();
                            filter.init(filter_def.get("init"));
                            this._bayeux.addFilter((String)filter_def.get("channels"), filter);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.getServletContext().log("Could not parse: " + filters, (Throwable)e);
                        throw new ServletException((Throwable)e);
                    }
                }
                if ((timeout = this.getInitParameter("timeout")) != null) {
                    this._timeout = Long.parseLong(timeout);
                }
                this._bayeux.setClientTimeoutMs(this._timeout * 3L / 2L);
                String verbose = this.getInitParameter("verbose");
                if (verbose != null) {
                    this._verbose = Boolean.parseBoolean(verbose);
                }
                if ((rpcSupport = this.getInitParameter("rpcSupport")) != null) {
                    this._rpcSupport = Boolean.parseBoolean(rpcSupport);
                }
                if ((l = this.getInitParameter("logLevel")) != null && l.length() > 0) {
                    this._bayeux.setLogLevel(Integer.parseInt(l));
                }
            }
            return;
        }
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String init = req.getParameter(TUNNEL_INIT_PARAM);
        if ("iframe".equals(init)) {
            if (this._verbose) {
                System.err.println("--> IFRAME NOT SUPPORTED!!!!");
            }
            if (this._verbose) {
                System.err.println("<-- Tunnel Over");
            }
        } else {
            super.service(req, resp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        List messages;
        Object clientObj = req.getAttribute(CLIENT_ATTR);
        Client client = clientObj instanceof Client ? (Client)clientObj : null;
        Transport transport = null;
        Continuation continuation = null;
        String bid = null;
        if (client != null) {
            if (this._bayeux.isLogDebug()) {
                this._bayeux.logDebug("doPost: client seen before: " + client);
            }
            transport = (Transport)req.getAttribute("transport");
            transport.setResponse(resp);
            bid = (String)req.getAttribute(BROWSER_ID);
        } else {
            String[] batches = null;
            int batch_index = 0;
            Object batch = null;
            int index = 0;
            Map message = null;
            int message_count = 0;
            batches = req.getParameterValues(MESSAGE_PARAM);
            String jsonpParam = req.getParameter("jsonp");
            if (jsonpParam != null && this._bayeux.isLogDebug()) {
                this._bayeux.logDebug("doPost: jsonp=" + jsonpParam);
            }
            while (batch_index < batches.length) {
                if (batch == null) {
                    if (this._verbose) {
                        System.err.println("=" + batch_index + "=>" + batches[batch_index]);
                    }
                    index = 0;
                    batch = JSON.parse((String)batches[batch_index++]);
                }
                if (batch == null) continue;
                if (batch.getClass().isArray()) {
                    message = (Map)Array.get(batch, index++);
                    if (index >= Array.getLength(batch)) {
                        batch = null;
                    }
                } else {
                    message = (Map)batch;
                    batch = null;
                }
                ++message_count;
                if (jsonpParam != null) {
                    message.put("jsonp", jsonpParam);
                }
                if ((client = this._bayeux.getClient((String)message.get("clientId"))) != null) break;
                transport = this._bayeux.newTransport(client, message);
                transport.setResponse(resp);
                this._bayeux.handle(null, transport, message);
                message = null;
                break;
            }
            if (client != null) {
                transport = this._bayeux.newTransport(client, message);
                transport.setResponse(resp);
                if (this._verbose && transport instanceof PlainTextJSONTransport) {
                    ((PlainTextJSONTransport)transport).setVerbose(this._verbose);
                }
                if (this._verbose && transport instanceof JSONPTransport) {
                    ((JSONPTransport)transport).setVerbose(this._verbose);
                }
                try {
                    if (this._rpcSupport) {
                        client.responsePending();
                    }
                    if (message != null) {
                        this._bayeux.handle(client, transport, message);
                    }
                    message = null;
                    while (batch_index < batches.length) {
                        if (batch == null) {
                            if (this._verbose) {
                                System.err.println("=" + batch_index + "=>" + batches[batch_index]);
                            }
                            index = 0;
                            batch = JSON.parse((String)batches[batch_index++]);
                        }
                        if (batch == null) continue;
                        if (batch.getClass().isArray()) {
                            message = (Map)Array.get(batch, index++);
                            if (index >= Array.getLength(batch)) {
                                batch = null;
                            }
                        } else {
                            message = (Map)batch;
                            batch = null;
                        }
                        if (message != null) {
                            this._bayeux.handle(client, transport, message);
                        }
                        message = null;
                    }
                }
                finally {
                    if (this._rpcSupport) {
                        client.responded();
                    }
                }
            }
        }
        while (transport.isPolling()) {
            if (this._bayeux.isLogDebug()) {
                this._bayeux.logDebug("doPost: transport is polling");
            }
            long timeout = this._timeout;
            continuation = ContinuationSupport.getContinuation((HttpServletRequest)req, (Object)client);
            if (!continuation.isPending()) {
                client.access();
            }
            List messages2 = null;
            Client client2 = client;
            synchronized (client2) {
                messages2 = client.takeMessages();
                if (messages2 == null && !continuation.isPending()) {
                    ((ContinuationClient)client).setContinuation(continuation);
                    req.setAttribute(CLIENT_ATTR, (Object)client);
                    req.setAttribute(BROWSER_ID, (Object)bid);
                    req.setAttribute("transport", (Object)transport);
                    if (this._bayeux.isLogDebug()) {
                        this._bayeux.logDebug("doPost: setting transport for request: " + transport);
                    }
                    continuation.suspend(timeout);
                    messages2 = client.takeMessages();
                }
                continuation.reset();
                ((ContinuationClient)client).setContinuation(null);
                if (messages2 == null) {
                    transport.setPolling(false);
                }
            }
            if (messages2 != null) {
                transport.send(messages2);
            }
            if (transport.keepAlive()) continue;
            transport.setPolling(false);
        }
        if (this._rpcSupport && client != null && (messages = client.takeMessages()) != null) {
            transport.send(messages);
        }
        transport.complete();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }
}

