/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd.filter;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import org.mortbay.cometd.Client;
import org.mortbay.cometd.DataFilter;
import org.mortbay.util.LazyList;

public class JSONDataFilter
implements DataFilter {
    public void init(Object init) {
    }

    public Object filter(Object data, Client from) throws IllegalStateException {
        if (data == null) {
            return null;
        }
        if (data instanceof Map) {
            return this.filterMap((Map)data, from);
        }
        if (data instanceof List) {
            return this.filterArray(LazyList.toArray((Object)data, Object.class), from);
        }
        if (data.getClass().isArray()) {
            return this.filterArray(data, from);
        }
        if (data instanceof Number) {
            return this.filterNumber((Number)data);
        }
        if (data instanceof Boolean) {
            return this.filterBoolean((Boolean)data);
        }
        if (data instanceof String) {
            return this.filterString((String)data);
        }
        return this.filterString(data.toString());
    }

    protected Object filterString(String string) {
        return string;
    }

    protected Object filterBoolean(Boolean bool) {
        return bool;
    }

    protected Object filterNumber(Number number) {
        return number;
    }

    protected Object filterArray(Object array, Client from) {
        if (array == null) {
            return null;
        }
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Array.set(array, i, this.filter(Array.get(array, i), from));
        }
        return array;
    }

    protected Object filterMap(Map object, Client from) {
        if (object == null) {
            return null;
        }
        for (Map.Entry entry : object.entrySet()) {
            entry.setValue(this.filter(entry.getValue(), from));
        }
        return object;
    }
}

