/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mortbay.cometd.Bayeux;
import org.mortbay.cometd.Channel;
import org.mortbay.cometd.DataFilter;
import org.mortbay.log.Log;
import org.mortbay.util.LazyList;

public class Client {
    private Bayeux _bayeux;
    private String _id;
    private String _type;
    private ArrayList<Map> _messages = new ArrayList();
    private int _responsesPending;
    private Object _dataFilters = null;
    private Channel _connection = null;
    private Set<Channel> _subscriptions = new HashSet<Channel>();
    private long _access;

    Client(Bayeux bayeux, String idPrefix) {
        this._bayeux = bayeux;
        this._id = idPrefix == null ? Long.toString(bayeux.getRandom((long)System.identityHashCode(this) ^ System.currentTimeMillis()), 36) : idPrefix + "_" + Long.toString(bayeux.getRandom((long)System.identityHashCode(this) ^ System.currentTimeMillis()), 36);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataFilter(DataFilter filter) {
        Client client = this;
        synchronized (client) {
            this._dataFilters = LazyList.add((Object)this._dataFilters, (Object)filter);
        }
    }

    public String getConnectionType() {
        return this._type;
    }

    public String getId() {
        return this._id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel connect() {
        Client client = this;
        synchronized (client) {
            String connection_id = "/meta/connections/" + this.getId();
            this._connection = this._bayeux.newChannel(connection_id);
            this._connection.addSubscriber(this);
            return this._connection;
        }
    }

    public Channel getConnection() {
        return this._connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMessages() {
        Client client = this;
        synchronized (client) {
            return this._messages != null && this._messages.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataFilter(DataFilter filter) {
        Client client = this;
        synchronized (client) {
            this._dataFilters = LazyList.remove((Object)this._dataFilters, (Object)filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List takeMessages() {
        Client client = this;
        synchronized (client) {
            if (this._messages == null || this._messages.size() == 0) {
                return null;
            }
            ArrayList<Map> list = this._messages;
            this._messages = new ArrayList();
            return list;
        }
    }

    public String toString() {
        return this._id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deliver(Map message) {
        Client client = this;
        synchronized (client) {
            if (this._connection == null) {
                return;
            }
            this._messages.add(message);
            if (this._responsesPending < 1) {
                this.resume();
            }
        }
    }

    public void resume() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object filterData(Object data, Client from) {
        Client client = this;
        synchronized (client) {
            try {
                for (int f = 0; f < LazyList.size((Object)this._dataFilters); ++f) {
                    data = ((DataFilter)LazyList.get((Object)this._dataFilters, (int)f)).filter(data, from);
                    if (data != null) continue;
                    return null;
                }
            }
            catch (IllegalStateException e) {
                Log.debug((Throwable)e);
                return null;
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int responded() {
        Client client = this;
        synchronized (client) {
            return this._responsesPending--;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int responsePending() {
        Client client = this;
        synchronized (client) {
            return ++this._responsesPending;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setConnectionType(String type) {
        Client client = this;
        synchronized (client) {
            this._type = type;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setId(String _id) {
        Client client = this;
        synchronized (client) {
            this._id = _id;
        }
    }

    void addSubscription(Channel channel) {
        this._subscriptions.add(channel);
    }

    void access() {
        this._access = System.currentTimeMillis();
    }

    long getLastAccess() {
        return this._access;
    }
}

