/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.servlet.ServletContext;
import org.mortbay.cometd.Channel;
import org.mortbay.cometd.ChannelPattern;
import org.mortbay.cometd.Client;
import org.mortbay.cometd.DataFilter;
import org.mortbay.cometd.IFrameTransport;
import org.mortbay.cometd.PlainTextJSONTransport;
import org.mortbay.cometd.SecurityPolicy;
import org.mortbay.cometd.Transport;
import org.mortbay.util.DateCache;

public class Bayeux {
    public static final String META_CONNECT = "/meta/connect";
    public static final String META_DISCONNECT = "/meta/disconnect";
    public static final String META_HANDSHAKE = "/meta/handshake";
    public static final String META_PING = "/meta/ping";
    public static final String META_RECONNECT = "/meta/reconnect";
    public static final String META_STATUS = "/meta/status";
    public static final String META_SUBSCRIBE = "/meta/subscribe";
    public static final String META_UNSUBSCRIBE = "/meta/unsubscribe";
    public static final String CLIENT_ATTR = "clientId";
    public static final String DATA_ATTR = "data";
    public static final String CHANNEL_ATTR = "channel";
    public static final String TIMESTAMP_ATTR = "timestamp";
    public static final String TRANSPORT_ATTR = "transport";
    HashMap _channels = new HashMap();
    HashMap _clients = new HashMap();
    ServletContext _context;
    DateCache _dateCache = new DateCache();
    Random _random = new Random(System.currentTimeMillis());
    HashMap _handlers = new HashMap();
    HashMap _transports = new HashMap();
    HashMap _filters = new HashMap();
    ArrayList _filterOrder = new ArrayList();
    SecurityPolicy _securityPolicy = new DefaultPolicy();

    Bayeux(ServletContext context) {
        this._handlers.put("*", new PublishHandler());
        this._handlers.put(META_HANDSHAKE, new HandshakeHandler());
        this._handlers.put(META_CONNECT, new ConnectHandler());
        this._handlers.put(META_RECONNECT, new ReconnectHandler());
        this._handlers.put(META_DISCONNECT, new DisconnectHandler());
        this._handlers.put(META_SUBSCRIBE, new SubscribeHandler());
        this._handlers.put(META_UNSUBSCRIBE, new UnsubscribeHandler());
        this._handlers.put(META_STATUS, new StatusHandler());
        this._handlers.put(META_PING, new PingHandler());
        this._transports.put("iframe", IFrameTransport.class);
        this._transports.put("http-polling", PlainTextJSONTransport.class);
        this._transports.put("long-polling", PlainTextJSONTransport.class);
        this._context = context;
    }

    public Channel getChannel(String id) {
        return (Channel)this._channels.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilter(String channels, DataFilter filter) {
        HashMap hashMap = this._filters;
        synchronized (hashMap) {
            ChannelPattern pattern = new ChannelPattern(channels);
            this._filters.put(pattern, filter);
            this._filterOrder.remove(pattern);
            this._filterOrder.add(pattern);
        }
    }

    public Channel newChannel(String id) {
        Channel channel = (Channel)this._channels.get(id);
        if (channel == null) {
            channel = new Channel(id, this);
            Iterator p = this._filterOrder.iterator();
            while (p.hasNext()) {
                ChannelPattern pattern = (ChannelPattern)p.next();
                if (!pattern.matches(id)) continue;
                channel.addDataFilter((DataFilter)this._filters.get(pattern));
            }
            this._channels.put(id, channel);
        }
        return channel;
    }

    public Set getChannelIDs() {
        return this._channels.keySet();
    }

    public Client getClient(String client_id) {
        return (Client)this._clients.get(client_id);
    }

    public Set getClientIDs() {
        return this._clients.keySet();
    }

    String getTimeOnServer() {
        return this._dateCache.format(System.currentTimeMillis());
    }

    Transport newTransport(Client client, Map message) {
        try {
            Class trans_class;
            String type;
            String string = type = client == null ? null : client.getConnectionType();
            if (type == null) {
                type = (String)message.get("connectionType");
            }
            if (type != null && (trans_class = (Class)this._transports.get(type)) != null) {
                return (Transport)trans_class.newInstance();
            }
            return new PlainTextJSONTransport();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void handle(Client client, Transport transport, Map message) throws IOException {
        String channel_id = (String)message.get(CHANNEL_ATTR);
        HashMap<String, String> reply = new HashMap<String, String>();
        reply.put(CHANNEL_ATTR, channel_id);
        Handler handler = (Handler)this._handlers.get(channel_id);
        if (handler == null) {
            handler = (Handler)this._handlers.get("*");
        }
        handler.handle(client, transport, message);
    }

    long getRandom() {
        return this._random.nextLong();
    }

    public SecurityPolicy getSecurityPolicy() {
        return this._securityPolicy;
    }

    public void setSecurityPolicy(SecurityPolicy securityPolicy) {
        this._securityPolicy = securityPolicy;
    }

    private static class DefaultPolicy
    implements SecurityPolicy {
        private DefaultPolicy() {
        }

        public boolean canCreate(Client client, Channel channel, Map message) {
            return true;
        }

        public boolean canSubscribe(Client client, Channel channel, Map message) {
            return true;
        }

        public boolean canSend(Client client, Channel channel, Map message) {
            return true;
        }
    }

    private class UnsubscribeHandler
    implements Handler {
        private UnsubscribeHandler() {
        }

        public void handle(Client client, Transport transport, Map message) throws IOException {
            if (client == null) {
                return;
            }
            String channel_id = (String)message.get("subscription");
            Channel channel = Bayeux.this.getChannel(channel_id);
            if (channel != null) {
                channel.removeSubscriber(client);
            }
            HashMap<String, Object> reply = new HashMap<String, Object>();
            reply.put(Bayeux.CHANNEL_ATTR, channel_id);
            reply.put("subscription", channel.getId());
            reply.put("successful", Boolean.TRUE);
            reply.put("error", "");
            transport.send(reply);
        }
    }

    private class SubscribeHandler
    implements Handler {
        private SubscribeHandler() {
        }

        public void handle(Client client, Transport transport, Map message) throws IOException {
            Channel channel;
            if (client == null) {
                throw new IllegalStateException("No client");
            }
            String channel_id = (String)message.get("subscription");
            if (channel_id == null) {
                channel_id = Long.toString(Bayeux.this.getRandom(), 36);
                while (Bayeux.this.getChannel(channel_id) != null) {
                    channel_id = Long.toString(Bayeux.this.getRandom(), 36);
                }
            }
            if ((channel = Bayeux.this.getChannel(channel_id)) == null && Bayeux.this._securityPolicy.canCreate(client, channel, message)) {
                channel = Bayeux.this.newChannel(channel_id);
            }
            HashMap<String, Object> reply = new HashMap<String, Object>();
            reply.put(Bayeux.CHANNEL_ATTR, channel_id);
            reply.put("subscription", channel.getId());
            if (channel != null && Bayeux.this._securityPolicy.canSubscribe(client, channel, message)) {
                channel.addSubscriber(client);
                reply.put("successful", Boolean.TRUE);
                reply.put("error", "");
            } else {
                reply.put("successful", Boolean.FALSE);
                reply.put("error", "cannot subscribe");
            }
            transport.send(reply);
        }
    }

    private class StatusHandler
    implements Handler {
        private StatusHandler() {
        }

        public void handle(Client client, Transport transport, Map message) throws IOException {
        }
    }

    private class ReconnectHandler
    implements Handler {
        private ReconnectHandler() {
        }

        public void handle(Client client, Transport transport, Map message) throws IOException {
            String channel_id = "/meta/connections/" + message.get(Bayeux.CLIENT_ATTR);
            HashMap<String, Object> reply = new HashMap<String, Object>();
            reply.put(Bayeux.CHANNEL_ATTR, channel_id);
            reply.put("connectionId", channel_id);
            reply.put(Bayeux.TIMESTAMP_ATTR, Bayeux.this._dateCache.format(System.currentTimeMillis()));
            if (client == null) {
                reply.put("successful", Boolean.FALSE);
                reply.put("error", "unknown clientID");
                transport.setPolling(false);
                transport.send(reply);
            } else {
                String type = (String)message.get("connectionType");
                if (type != null) {
                    client.setConnectionType(type);
                }
                reply.put("successful", Boolean.TRUE);
                reply.put("error", "");
                transport.setPolling(true);
                transport.send(reply);
            }
        }
    }

    private class PingHandler
    implements Handler {
        private PingHandler() {
        }

        public void handle(Client client, Transport transport, Map message) throws IOException {
        }
    }

    private class HandshakeHandler
    implements Handler {
        private HandshakeHandler() {
        }

        public void handle(Client client, Transport transport, Map message) throws IOException {
            if (client != null) {
                throw new IllegalStateException();
            }
            client = new Client();
            Bayeux.this._clients.put(client.getId(), client);
            String channel_id = "/meta/connections/" + client.getId();
            Channel channel = new Channel(channel_id, Bayeux.this);
            Bayeux.this._channels.put(channel_id, channel);
            HashMap<String, Object> reply = new HashMap<String, Object>();
            reply.put(Bayeux.CHANNEL_ATTR, Bayeux.META_HANDSHAKE);
            reply.put("supportedConnectionTypes", new String[]{"long-polling", "iframe"});
            reply.put("authSuccessful", Boolean.TRUE);
            reply.put(Bayeux.CLIENT_ATTR, client.getId());
            reply.put("version", new Double(0.1));
            reply.put("minimumVersion", new Double(0.1));
            transport.send(reply);
        }
    }

    private class DisconnectHandler
    implements Handler {
        private DisconnectHandler() {
        }

        public void handle(Client client, Transport transport, Map message) {
        }
    }

    private class PublishHandler
    implements Handler {
        private PublishHandler() {
        }

        public void handle(Client client, Transport transport, Map message) throws IOException {
            String channel_id = (String)message.get(Bayeux.CHANNEL_ATTR);
            Channel channel = Bayeux.this.getChannel(channel_id);
            Object data = message.get(Bayeux.DATA_ATTR);
            HashMap<String, Object> reply = new HashMap<String, Object>();
            reply.put(Bayeux.CHANNEL_ATTR, channel_id);
            if (channel != null && data != null && Bayeux.this._securityPolicy.canSend(client, channel, message)) {
                channel.publish(data, client);
                reply.put("successful", Boolean.TRUE);
                reply.put("error", "");
            } else {
                reply.put("successful", Boolean.FALSE);
                reply.put("error", "unknown channel");
            }
            transport.send(reply);
        }
    }

    private class ConnectHandler
    implements Handler {
        private ConnectHandler() {
        }

        public void handle(Client client, Transport transport, Map message) throws IOException {
            HashMap<String, Object> reply = new HashMap<String, Object>();
            if (client == null) {
                throw new IllegalStateException("No client");
            }
            String type = (String)message.get("connectionType");
            client.setConnectionType(type);
            String channel_id = "/meta/connections/" + client.getId();
            Channel channel = Bayeux.this.getChannel(channel_id);
            if (channel != null) {
                channel.addSubscriber(client);
                reply.put("successful", Boolean.TRUE);
                reply.put("error", "");
            } else {
                reply.put("successful", Boolean.FALSE);
                reply.put("error", "unknown client ID");
            }
            reply.put("connectionId", channel_id);
            reply.put(Bayeux.TIMESTAMP_ATTR, Bayeux.this._dateCache.format(System.currentTimeMillis()));
            transport.send(reply);
            transport.setPolling(true);
        }
    }

    private static interface Handler {
        public void handle(Client var1, Transport var2, Map var3) throws IOException;
    }
}

