/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.cometd.Bayeux;
import org.mortbay.cometd.Client;
import org.mortbay.cometd.DataFilter;
import org.mortbay.cometd.IFrameTransport;
import org.mortbay.cometd.JSON;
import org.mortbay.cometd.PlainTextJSONTransport;
import org.mortbay.cometd.Transport;
import org.mortbay.util.TypeUtil;
import org.mortbay.util.ajax.Continuation;
import org.mortbay.util.ajax.ContinuationSupport;

public class CometdServlet
extends HttpServlet {
    public static final String ORG_MORTBAY_BAYEUX = "org.mortbay.bayeux";
    public static final String CLIENT_ATTR = "org.mortbay.cometd.client";
    public static final String MESSAGE_PARAM = "message";
    public static final String TUNNEL_INIT_PARAM = "tunnelInit";
    public static final String BROWSER_ID = "bayeuxBID";
    private Bayeux _bayeux;
    private long _timeout = 45000L;
    private long _multiTimeout = 0L;
    private Object _multiAdvice = null;
    private Map _bidCount = new HashMap();
    private boolean _verbose;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws ServletException {
        String verbose;
        String multiTimeout;
        String timeout;
        Class clazz = CometdServlet.class;
        synchronized (clazz) {
            this._bayeux = (Bayeux)this.getServletContext().getAttribute(ORG_MORTBAY_BAYEUX);
            if (this._bayeux == null) {
                this._bayeux = new Bayeux(this.getServletContext());
                this.getServletContext().setAttribute(ORG_MORTBAY_BAYEUX, (Object)this._bayeux);
            }
        }
        String filters = this.getInitParameter("filters");
        if (filters != null) {
            try {
                Object[] objects = (Object[])JSON.parse(this.getServletContext().getResourceAsStream(filters));
                for (int i = 0; objects != null && i < objects.length; ++i) {
                    Map filter_def = (Map)objects[i];
                    Class<?> c = Thread.currentThread().getContextClassLoader().loadClass((String)filter_def.get("class"));
                    DataFilter filter = (DataFilter)c.newInstance();
                    filter.init(filter_def.get("init"));
                    this._bayeux.addFilter((String)filter_def.get("channels"), filter);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.getServletContext().log("Could not parse: " + filters, (Throwable)e);
                throw new ServletException((Throwable)e);
            }
        }
        if ((timeout = this.getInitParameter("timeout")) != null) {
            this._timeout = Long.parseLong(timeout);
        }
        if ((multiTimeout = this.getInitParameter("multi-timeout")) != null) {
            this._multiTimeout = Long.parseLong(multiTimeout);
            this._multiAdvice = new JSON.Literal("{\"status\":\"multipleconnections\",\"reconnect\":\"retry\",\"interval\":" + this._multiTimeout + ",\"transport\":{\"long-polling\":{}}}");
        }
        if ((verbose = this.getInitParameter("verbose")) != null) {
            this._verbose = Boolean.parseBoolean(verbose);
        }
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String init = req.getParameter(TUNNEL_INIT_PARAM);
        if ("iframe".equals(init)) {
            if (this._verbose) {
                System.err.println("--> Init Tunnel - IFRAME CURRENTLY BROKEN!!!!!!!");
            }
            IFrameTransport transport = new IFrameTransport();
            transport.initTunnel(resp);
            if (this._verbose) {
                System.err.println("<-- Tunnel Over");
            }
        } else {
            super.service(req, resp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Object clientObj = req.getAttribute(CLIENT_ATTR);
        Client client = clientObj instanceof Client ? (Client)clientObj : null;
        Transport transport = null;
        Continuation continuation = null;
        String bid = null;
        if (client != null) {
            transport = (Transport)req.getAttribute("transport");
            transport.setResponse(resp);
            bid = (String)req.getAttribute(BROWSER_ID);
            if (this._multiTimeout > 0L && this.decBID(bid) == 0) {
                // empty if block
            }
        } else {
            if (this._multiTimeout > 0L) {
                Cookie[] cookies = req.getCookies();
                for (int i = 0; cookies != null && i < cookies.length; ++i) {
                    if (!cookies[i].getName().equals(BROWSER_ID)) continue;
                    bid = cookies[i].getValue();
                }
                if (bid == null) {
                    long l1 = this._bayeux._random.nextLong();
                    long l2 = this._bayeux._random.nextLong();
                    bid = Long.toString(l1 < 0L ? -l1 : l1, 16) + Long.toString(l2 < 0L ? -l2 : l2, 16);
                    Cookie cookie = new Cookie(BROWSER_ID, bid);
                    cookie.setPath("/");
                    resp.addCookie(cookie);
                }
            }
            String[] batches = null;
            int batch_index = 0;
            Object batch = null;
            int index = 0;
            Map message = null;
            int message_count = 0;
            batches = req.getParameterValues(MESSAGE_PARAM);
            while (batch_index < batches.length) {
                if (batch == null) {
                    if (this._verbose) {
                        System.err.println("=" + batch_index + "=>" + batches[batch_index]);
                    }
                    index = 0;
                    batch = JSON.parse(batches[batch_index++]);
                }
                if (batch == null) continue;
                if (batch.getClass().isArray()) {
                    message = (Map)Array.get(batch, index++);
                    if (index >= Array.getLength(batch)) {
                        batch = null;
                    }
                } else {
                    message = (Map)batch;
                    batch = null;
                }
                ++message_count;
                client = this._bayeux.getClient((String)message.get("clientId"));
                if (client != null) break;
                transport = this._bayeux.newTransport(client, message);
                transport.setResponse(resp);
                this._bayeux.handle(null, transport, message);
                message = null;
                break;
            }
            if (client != null) {
                transport = this._bayeux.newTransport(client, message);
                transport.setResponse(resp);
                if (this._verbose && transport instanceof PlainTextJSONTransport) {
                    ((PlainTextJSONTransport)transport).setVerbose(this._verbose);
                }
                if (message != null) {
                    this._bayeux.handle(client, transport, message);
                }
                message = null;
                while (batch_index < batches.length) {
                    if (batch == null) {
                        if (this._verbose) {
                            System.err.println("=" + batch_index + "=>" + batches[batch_index]);
                        }
                        index = 0;
                        batch = JSON.parse(batches[batch_index++]);
                    }
                    if (batch == null) continue;
                    if (batch.getClass().isArray()) {
                        message = (Map)Array.get(batch, index++);
                        if (index >= Array.getLength(batch)) {
                            batch = null;
                        }
                    } else {
                        message = (Map)batch;
                        batch = null;
                    }
                    if (message != null) {
                        this._bayeux.handle(client, transport, message);
                    }
                    message = null;
                }
            }
        }
        while (transport.isPolling()) {
            long timeout = this._timeout;
            continuation = ContinuationSupport.getContinuation((HttpServletRequest)req, (Object)client);
            List messages = null;
            Client client2 = client;
            synchronized (client2) {
                messages = client.takeMessages();
                if (messages == null && !continuation.isPending()) {
                    if (this._multiTimeout > 0L && this.incBID(bid) > 1) {
                        timeout = this._multiTimeout;
                        this._bayeux.advise(client, transport, this._multiAdvice);
                    }
                    client.addContinuation(continuation);
                    req.setAttribute(CLIENT_ATTR, (Object)client);
                    req.setAttribute(BROWSER_ID, (Object)bid);
                    req.setAttribute("transport", (Object)transport);
                    continuation.suspend(timeout);
                    client.removeContinuation(continuation);
                    messages = client.takeMessages();
                }
                continuation.reset();
                client.removeContinuation(continuation);
                if (messages == null) {
                    transport.setPolling(false);
                }
            }
            if (messages != null) {
                transport.send(messages);
            }
            if (transport.keepAlive()) continue;
            transport.setPolling(false);
        }
        transport.complete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int incBID(String bid) {
        Map map = this._bidCount;
        synchronized (map) {
            Integer count = (Integer)this._bidCount.get(bid);
            count = TypeUtil.newInteger((int)(count == null ? 1 : count + 1));
            this._bidCount.put(bid, count);
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int decBID(String bid) {
        Map map = this._bidCount;
        synchronized (map) {
            Integer count = (Integer)this._bidCount.get(bid);
            Integer n = count = count == null || count <= 1 ? null : TypeUtil.newInteger((int)(count - 1));
            if (count == null) {
                this._bidCount.remove(bid);
                return 0;
            }
            this._bidCount.put(bid, count);
            return count;
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }
}

