/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd.session;

import dojox.cometd.Bayeux;
import dojox.cometd.Client;
import dojox.cometd.Extension;
import dojox.cometd.Message;
import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.util.EventListener;
import java.util.Map;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.mortbay.cometd.AbstractBayeux;
import org.mortbay.cometd.MessageImpl;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.security.B64Code;
import org.mortbay.jetty.servlet.AbstractSessionManager;
import org.mortbay.jetty.servlet.HashSessionManager;
import org.mortbay.log.Log;
import org.mortbay.util.ByteArrayOutputStream2;

public class BayeuxSessionManager
extends HashSessionManager {
    public static final String BAYEUX_SESSION = "/service/ext/session";
    AbstractBayeux _bayeux;
    private String _secret = "Really Private";

    protected void initialize(Bayeux bayeux) {
        Log.info((String)("Bayeux Session Manager initialized for " + this._context.getContextPath()));
        this._bayeux = (AbstractBayeux)bayeux;
        this._bayeux.setRequestAvailable(true);
        this._bayeux.addExtension((Extension)new SessionExt());
    }

    protected AbstractSessionManager.Session newSession(HttpServletRequest request) {
        return new BayeuxSession(request);
    }

    protected AbstractSessionManager.Session newSession(long created, String clusterId) {
        return new BayeuxSession(created, clusterId);
    }

    public void doStart() throws Exception {
        super.doStart();
        this._context.getContextHandler().addEventListener((EventListener)new ServletContextAttributeListener(){

            public void attributeAdded(ServletContextAttributeEvent scab) {
                if (scab.getName().equals("dojox.cometd.bayeux")) {
                    Bayeux bayeux = (Bayeux)scab.getValue();
                    BayeuxSessionManager.this.initialize(bayeux);
                }
            }

            public void attributeRemoved(ServletContextAttributeEvent scab) {
            }

            public void attributeReplaced(ServletContextAttributeEvent scab) {
            }
        });
    }

    private Object encode(Object o, String valueSecret) {
        return null;
    }

    private Object decode(String value, String valueSecret) {
        return null;
    }

    protected class BayeuxSession
    extends HashSessionManager.Session {
        Client _client;
        boolean _dirty;

        protected BayeuxSession(HttpServletRequest request) {
            super((HashSessionManager)BayeuxSessionManager.this, request);
        }

        public BayeuxSession(long created, String clusterId) {
            super((HashSessionManager)BayeuxSessionManager.this, created, clusterId);
            this._dirty = true;
        }

        public void setClient(Client client) {
            this._client = client;
        }

        protected void access(long time) {
            super.access(time);
        }

        public void invalidate() throws IllegalStateException {
            super.invalidate();
            this._dirty = true;
        }

        public synchronized void removeAttribute(String name) {
            super.removeAttribute(name);
            this._dirty = true;
        }

        public synchronized void setAttribute(String name, Object value) {
            super.setAttribute(name, value);
            this._dirty = true;
        }

        protected void complete() {
            super.complete();
            if (this._dirty && this._client != null) {
                this._dirty = false;
                MessageImpl message = BayeuxSessionManager.this._bayeux.newMessage();
                ByteArrayOutputStream2 bout = new ByteArrayOutputStream2();
                try {
                    this.save((OutputStream)bout);
                    byte[] buf = bout.toByteArray();
                    String encoded = new String(B64Code.encode((byte[])buf));
                    message.put((Object)"data", (Object)encoded);
                }
                catch (Exception e) {
                    Log.warn((Throwable)e);
                }
                BayeuxSessionManager.this._bayeux.deliver(this._client, this._client, BayeuxSessionManager.BAYEUX_SESSION, (Message)message);
            }
        }
    }

    protected class SessionExt
    implements Extension {
        protected SessionExt() {
        }

        public Message rcv(Message message) {
            return message;
        }

        public Message rcvMeta(Message message) {
            if (message.getChannel().equals("/meta/handshake")) {
                String session;
                Map ext = (Map)message.get((Object)"ext");
                String string = session = ext == null ? null : (String)ext.get("session");
                if (session != null) {
                    byte[] buf = B64Code.decode((char[])session.toCharArray());
                    ByteArrayInputStream bin = new ByteArrayInputStream(buf);
                    try {
                        HashSessionManager.Session s = BayeuxSessionManager.this.restoreSession(bin);
                        ((BayeuxSession)s).access(System.currentTimeMillis());
                        ((Request)BayeuxSessionManager.this._bayeux.getCurrentRequest()).setSession((HttpSession)s);
                        String cid = message.getClientId();
                        Client client = BayeuxSessionManager.this._bayeux.getClient(cid);
                        ((BayeuxSession)s).setClient(client);
                        BayeuxSessionManager.this.addSession((AbstractSessionManager.Session)s);
                        Log.info((String)("Restored session " + s.getId() + " for bayeux client " + cid));
                    }
                    catch (Exception e) {
                        Log.warn((Throwable)e);
                    }
                }
            }
            return message;
        }

        public Message send(Message message) {
            return message;
        }

        public Message sendMeta(Message message) {
            if (message.getChannel().equals("/meta/handshake")) {
                String cid = message.getClientId();
                Client client = BayeuxSessionManager.this._bayeux.getClient(cid);
                ((BayeuxSession)BayeuxSessionManager.this._bayeux.getCurrentRequest().getSession(true)).setClient(client);
            }
            return message;
        }
    }
}

