/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cometd.Message;
import org.mortbay.cometd.MessageImpl;
import org.mortbay.util.ArrayQueue;
import org.mortbay.util.StringMap;
import org.mortbay.util.ajax.JSON;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessagePool {
    private final ArrayQueue<MessageImpl> _messagePool;
    private final ArrayQueue<JSON.ReaderSource> _readerPool;
    private StringMap _fieldStrings = new StringMap();
    private StringMap _valueStrings = new StringMap();
    private JSON _json;
    private JSON _msgJSON;
    private JSON _batchJSON;

    public MessagePool() {
        this(50);
    }

    public MessagePool(int capacity) {
        this._fieldStrings.put("advice", (Object)"advice");
        this._fieldStrings.put("channel", (Object)"channel");
        this._fieldStrings.put("clientId", (Object)"clientId");
        this._fieldStrings.put("data", (Object)"data");
        this._fieldStrings.put("error", (Object)"error");
        this._fieldStrings.put("ext", (Object)"ext");
        this._fieldStrings.put("id", (Object)"id");
        this._fieldStrings.put("subscription", (Object)"subscription");
        this._fieldStrings.put("successful", (Object)"successful");
        this._fieldStrings.put("timestamp", (Object)"timestamp");
        this._fieldStrings.put("transport", (Object)"transport");
        this._fieldStrings.put("connectionType", (Object)"connectionType");
        this._valueStrings.put("/meta/client", (Object)"/meta/client");
        this._valueStrings.put("/meta/connect", (Object)"/meta/connect");
        this._valueStrings.put("/meta/disconnect", (Object)"/meta/disconnect");
        this._valueStrings.put("/meta/handshake", (Object)"/meta/handshake");
        this._valueStrings.put("/meta/subscribe", (Object)"/meta/subscribe");
        this._valueStrings.put("/meta/unsubscribe", (Object)"/meta/unsubscribe");
        this._valueStrings.put("long-polling", (Object)"long-polling");
        this._json = new JSON(){

            protected Map newMap() {
                return new HashMap(8);
            }

            protected String toString(char[] buffer, int offset, int length) {
                Map.Entry entry = MessagePool.this._valueStrings.getEntry(buffer, offset, length);
                if (entry != null) {
                    return (String)entry.getValue();
                }
                String s = new String(buffer, offset, length);
                return s;
            }
        };
        this._msgJSON = new JSON(){

            protected Map newMap() {
                return MessagePool.this.newMessage();
            }

            protected String toString(char[] buffer, int offset, int length) {
                Map.Entry entry = MessagePool.this._fieldStrings.getEntry(buffer, offset, length);
                if (entry != null) {
                    return (String)entry.getValue();
                }
                String s = new String(buffer, offset, length);
                return s;
            }

            protected JSON contextFor(String field) {
                return MessagePool.this._json;
            }
        };
        this._batchJSON = new JSON(){

            protected Map newMap() {
                return MessagePool.this.newMessage();
            }

            protected Object[] newArray(int size) {
                return new Message[size];
            }

            protected JSON contextFor(String field) {
                return MessagePool.this._json;
            }

            protected JSON contextForArray() {
                return MessagePool.this._msgJSON;
            }
        };
        this._messagePool = new ArrayQueue(capacity, capacity);
        this._readerPool = new ArrayQueue(capacity, capacity);
    }

    public JSON getJSON() {
        return this._json;
    }

    public void setJSON(JSON json) {
        this._json = json;
    }

    public JSON getMsgJSON() {
        return this._msgJSON;
    }

    public void setMsgJSON(JSON msgJSON) {
        this._msgJSON = msgJSON;
    }

    public JSON getBatchJSON() {
        return this._batchJSON;
    }

    public void setBatchJSON(JSON batchJSON) {
        this._batchJSON = batchJSON;
    }

    public MessageImpl newMessage() {
        MessageImpl message = (MessageImpl)this._messagePool.poll();
        if (message == null) {
            message = new MessageImpl(this);
        }
        message.incRef();
        return message;
    }

    public MessageImpl newMessage(Message associated) {
        MessageImpl message = (MessageImpl)this._messagePool.poll();
        if (message == null) {
            message = new MessageImpl(this);
        }
        message.incRef();
        if (associated != null) {
            message.setAssociated(associated);
        }
        return message;
    }

    void recycleMessage(MessageImpl message) {
        message.clear();
        this._messagePool.offer((Object)message);
    }

    public Message[] parse(Reader reader) throws IOException {
        JSON.ReaderSource source = (JSON.ReaderSource)this._readerPool.poll();
        if (source == null) {
            source = new JSON.ReaderSource(reader);
        } else {
            source.setReader(reader);
        }
        Object batch = this._batchJSON.parse((JSON.Source)source);
        this._readerPool.offer((Object)source);
        if (batch == null) {
            return new Message[0];
        }
        if (batch.getClass().isArray()) {
            return (Message[])batch;
        }
        return new Message[]{(Message)batch};
    }

    public Message[] parse(String s) throws IOException {
        Object batch = this._batchJSON.parse((JSON.Source)new JSON.StringSource(s));
        if (batch == null) {
            return new Message[0];
        }
        if (batch.getClass().isArray()) {
            return (Message[])batch;
        }
        return new Message[]{(Message)batch};
    }

    public void parseTo(String fodder, List<Message> messages) {
        Object batch = this._batchJSON.parse((JSON.Source)new JSON.StringSource(fodder));
        if (batch == null) {
            return;
        }
        if (batch.getClass().isArray()) {
            Message[] msgs = (Message[])batch;
            for (int m = 0; m < msgs.length; ++m) {
                messages.add(msgs[m]);
            }
        } else {
            messages.add((Message)batch);
        }
    }

    public String toString() {
        return "MessagePool:" + this._messagePool.size() + "/" + this._messagePool.getCapacity();
    }
}

