/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.assertions.Assertions;
import java.io.Serializable;

public class DBRef
implements Serializable {
    private static final long serialVersionUID = -849581217713362618L;
    private final Object id;
    private final String collectionName;

    public DBRef(String collectionName, Object id) {
        this.id = Assertions.notNull((String)"id", (Object)id);
        this.collectionName = (String)Assertions.notNull((String)"ns", (Object)collectionName);
    }

    public Object getId() {
        return this.id;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DBRef dbRef = (DBRef)o;
        if (!this.collectionName.equals(dbRef.collectionName)) {
            return false;
        }
        return this.id.equals(dbRef.id);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.collectionName.hashCode();
        return result;
    }

    public String toString() {
        return "{ \"$ref\" : \"" + this.collectionName + "\", \"$id\" : \"" + this.id + "\" }";
    }
}

