/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.AggregateIterableImpl;
import com.mongodb.DistinctIterableImpl;
import com.mongodb.FindIterableImpl;
import com.mongodb.ListIndexesIterableImpl;
import com.mongodb.MapReduceIterableImpl;
import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoNamespace;
import com.mongodb.MongoWriteConcernException;
import com.mongodb.MongoWriteException;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.WriteError;
import com.mongodb.assertions.Assertions;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.bulk.BulkWriteUpsert;
import com.mongodb.bulk.DeleteRequest;
import com.mongodb.bulk.InsertRequest;
import com.mongodb.bulk.UpdateRequest;
import com.mongodb.bulk.WriteRequest;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.DistinctIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.ListIndexesIterable;
import com.mongodb.client.MapReduceIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.CreateIndexOptions;
import com.mongodb.client.model.DeleteManyModel;
import com.mongodb.client.model.DeleteOneModel;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.FindOptions;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.RenameCollectionOptions;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.UpdateManyModel;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.operation.CountOperation;
import com.mongodb.operation.CreateIndexOperation;
import com.mongodb.operation.DropCollectionOperation;
import com.mongodb.operation.DropIndexOperation;
import com.mongodb.operation.FindAndDeleteOperation;
import com.mongodb.operation.FindAndReplaceOperation;
import com.mongodb.operation.FindAndUpdateOperation;
import com.mongodb.operation.MixedBulkWriteOperation;
import com.mongodb.operation.OperationExecutor;
import com.mongodb.operation.ReadOperation;
import com.mongodb.operation.RenameCollectionOperation;
import com.mongodb.operation.WriteOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWrapper;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.CollectibleCodec;
import org.bson.codecs.configuration.CodecRegistry;

class MongoCollectionImpl<T>
implements MongoCollection<T> {
    private final MongoNamespace namespace;
    private final Class<T> clazz;
    private final ReadPreference readPreference;
    private final CodecRegistry codecRegistry;
    private final WriteConcern writeConcern;
    private final OperationExecutor executor;

    MongoCollectionImpl(MongoNamespace namespace, Class<T> clazz, CodecRegistry codecRegistry, ReadPreference readPreference, WriteConcern writeConcern, OperationExecutor executor) {
        this.namespace = (MongoNamespace)Assertions.notNull((String)"namespace", (Object)namespace);
        this.clazz = (Class)Assertions.notNull((String)"clazz", clazz);
        this.codecRegistry = (CodecRegistry)Assertions.notNull((String)"codecRegistry", (Object)codecRegistry);
        this.readPreference = (ReadPreference)Assertions.notNull((String)"readPreference", (Object)readPreference);
        this.writeConcern = (WriteConcern)Assertions.notNull((String)"writeConcern", (Object)writeConcern);
        this.executor = (OperationExecutor)Assertions.notNull((String)"executor", (Object)executor);
    }

    @Override
    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    @Override
    public Class<T> getDefaultClass() {
        return this.clazz;
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Override
    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    @Override
    public <C> MongoCollection<C> withDefaultClass(Class<C> clazz) {
        return new MongoCollectionImpl<C>(this.namespace, clazz, this.codecRegistry, this.readPreference, this.writeConcern, this.executor);
    }

    @Override
    public MongoCollection<T> withCodecRegistry(CodecRegistry codecRegistry) {
        return new MongoCollectionImpl<T>(this.namespace, this.clazz, codecRegistry, this.readPreference, this.writeConcern, this.executor);
    }

    @Override
    public MongoCollection<T> withReadPreference(ReadPreference readPreference) {
        return new MongoCollectionImpl<T>(this.namespace, this.clazz, this.codecRegistry, readPreference, this.writeConcern, this.executor);
    }

    @Override
    public MongoCollection<T> withWriteConcern(WriteConcern writeConcern) {
        return new MongoCollectionImpl<T>(this.namespace, this.clazz, this.codecRegistry, this.readPreference, writeConcern, this.executor);
    }

    @Override
    public long count() {
        return this.count(new Document(), new CountOptions());
    }

    @Override
    public long count(Object filter) {
        return this.count(filter, new CountOptions());
    }

    @Override
    public long count(Object filter, CountOptions options) {
        CountOperation operation = new CountOperation(this.namespace).filter(this.asBson(filter)).skip(options.getSkip()).limit(options.getLimit()).maxTime(options.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
        if (options.getHint() != null) {
            operation.hint((BsonValue)this.asBson(options.getHint()));
        } else if (options.getHintString() != null) {
            operation.hint((BsonValue)new BsonString(options.getHintString()));
        }
        return (Long)this.executor.execute((ReadOperation)operation, this.readPreference);
    }

    @Override
    public <C> DistinctIterable<C> distinct(String fieldName, Class<C> clazz) {
        return new DistinctIterableImpl<C>(this.namespace, clazz, this.codecRegistry, this.readPreference, this.executor, fieldName);
    }

    @Override
    public FindIterable<T> find() {
        return this.find(new BsonDocument(), this.clazz);
    }

    @Override
    public <C> FindIterable<C> find(Class<C> clazz) {
        return this.find(new BsonDocument(), clazz);
    }

    @Override
    public FindIterable<T> find(Object filter) {
        return this.find(filter, this.clazz);
    }

    @Override
    public <C> FindIterable<C> find(Object filter, Class<C> clazz) {
        return new FindIterableImpl<C>(this.namespace, clazz, this.codecRegistry, this.readPreference, this.executor, filter, new FindOptions());
    }

    @Override
    public AggregateIterable<Document> aggregate(List<?> pipeline) {
        return this.aggregate(pipeline, Document.class);
    }

    @Override
    public <C> AggregateIterable<C> aggregate(List<?> pipeline, Class<C> clazz) {
        return new AggregateIterableImpl<C>(this.namespace, clazz, this.codecRegistry, this.readPreference, this.executor, pipeline);
    }

    @Override
    public MapReduceIterable<Document> mapReduce(String mapFunction, String reduceFunction) {
        return this.mapReduce(mapFunction, reduceFunction, Document.class);
    }

    @Override
    public <C> MapReduceIterable<C> mapReduce(String mapFunction, String reduceFunction, Class<C> clazz) {
        return new MapReduceIterableImpl<C>(this.namespace, clazz, this.codecRegistry, this.readPreference, this.executor, mapFunction, reduceFunction);
    }

    @Override
    public BulkWriteResult bulkWrite(List<? extends WriteModel<? extends T>> requests) {
        return this.bulkWrite(requests, new BulkWriteOptions());
    }

    @Override
    public BulkWriteResult bulkWrite(List<? extends WriteModel<? extends T>> requests, BulkWriteOptions options) {
        ArrayList<InsertRequest> writeRequests = new ArrayList<InsertRequest>(requests.size());
        for (WriteModel<T> writeModel : requests) {
            InsertRequest writeRequest;
            if (writeModel instanceof InsertOneModel) {
                InsertOneModel insertOneModel = (InsertOneModel)writeModel;
                if (this.getCodec() instanceof CollectibleCodec) {
                    ((CollectibleCodec)this.getCodec()).generateIdIfAbsentFromDocument(insertOneModel.getDocument());
                }
                writeRequest = new InsertRequest(this.asBson(insertOneModel.getDocument()));
            } else if (writeModel instanceof ReplaceOneModel) {
                ReplaceOneModel replaceOneModel = (ReplaceOneModel)writeModel;
                writeRequest = new UpdateRequest(this.asBson(replaceOneModel.getFilter()), this.asBson(replaceOneModel.getReplacement()), WriteRequest.Type.REPLACE).upsert(replaceOneModel.getOptions().isUpsert());
            } else if (writeModel instanceof UpdateOneModel) {
                UpdateOneModel updateOneModel = (UpdateOneModel)writeModel;
                writeRequest = new UpdateRequest(this.asBson(updateOneModel.getFilter()), this.asBson(updateOneModel.getUpdate()), WriteRequest.Type.UPDATE).multi(false).upsert(updateOneModel.getOptions().isUpsert());
            } else if (writeModel instanceof UpdateManyModel) {
                UpdateManyModel updateManyModel = (UpdateManyModel)writeModel;
                writeRequest = new UpdateRequest(this.asBson(updateManyModel.getFilter()), this.asBson(updateManyModel.getUpdate()), WriteRequest.Type.UPDATE).multi(true).upsert(updateManyModel.getOptions().isUpsert());
            } else if (writeModel instanceof DeleteOneModel) {
                DeleteOneModel deleteOneModel = (DeleteOneModel)writeModel;
                writeRequest = new DeleteRequest(this.asBson(deleteOneModel.getFilter())).multi(false);
            } else if (writeModel instanceof DeleteManyModel) {
                DeleteManyModel deleteManyModel = (DeleteManyModel)writeModel;
                writeRequest = new DeleteRequest(this.asBson(deleteManyModel.getFilter())).multi(true);
            } else {
                throw new UnsupportedOperationException(String.format("WriteModel of type %s is not supported", writeModel.getClass()));
            }
            writeRequests.add(writeRequest);
        }
        return (BulkWriteResult)this.executor.execute((WriteOperation)new MixedBulkWriteOperation(this.namespace, writeRequests, options.isOrdered(), this.writeConcern));
    }

    @Override
    public void insertOne(T document) {
        if (this.getCodec() instanceof CollectibleCodec) {
            ((CollectibleCodec)this.getCodec()).generateIdIfAbsentFromDocument(document);
        }
        this.executeSingleWriteRequest((WriteRequest)new InsertRequest(this.asBson(document)));
    }

    @Override
    public void insertMany(List<? extends T> documents) {
        this.insertMany(documents, new InsertManyOptions());
    }

    @Override
    public void insertMany(List<? extends T> documents, InsertManyOptions options) {
        ArrayList<InsertRequest> requests = new ArrayList<InsertRequest>(documents.size());
        for (T document : documents) {
            if (this.getCodec() instanceof CollectibleCodec) {
                ((CollectibleCodec)this.getCodec()).generateIdIfAbsentFromDocument(document);
            }
            requests.add(new InsertRequest(this.asBson(document)));
        }
        this.executor.execute((WriteOperation)new MixedBulkWriteOperation(this.namespace, requests, options.isOrdered(), this.writeConcern));
    }

    @Override
    public DeleteResult deleteOne(Object filter) {
        return this.delete(filter, false);
    }

    @Override
    public DeleteResult deleteMany(Object filter) {
        return this.delete(filter, true);
    }

    @Override
    public UpdateResult replaceOne(Object filter, T replacement) {
        return this.replaceOne(filter, replacement, new UpdateOptions());
    }

    @Override
    public UpdateResult replaceOne(Object filter, T replacement, UpdateOptions updateOptions) {
        return this.toUpdateResult(this.executeSingleWriteRequest((WriteRequest)new UpdateRequest(this.asBson(filter), this.asBson(replacement), WriteRequest.Type.REPLACE).upsert(updateOptions.isUpsert())));
    }

    @Override
    public UpdateResult updateOne(Object filter, Object update) {
        return this.updateOne(filter, update, new UpdateOptions());
    }

    @Override
    public UpdateResult updateOne(Object filter, Object update, UpdateOptions updateOptions) {
        return this.update(filter, update, updateOptions, false);
    }

    @Override
    public UpdateResult updateMany(Object filter, Object update) {
        return this.updateMany(filter, update, new UpdateOptions());
    }

    @Override
    public UpdateResult updateMany(Object filter, Object update, UpdateOptions updateOptions) {
        return this.update(filter, update, updateOptions, true);
    }

    @Override
    public T findOneAndDelete(Object filter) {
        return this.findOneAndDelete(filter, new FindOneAndDeleteOptions());
    }

    @Override
    public T findOneAndDelete(Object filter, FindOneAndDeleteOptions options) {
        return (T)this.executor.execute((WriteOperation)new FindAndDeleteOperation(this.namespace, this.getCodec()).filter(this.asBson(filter)).projection(this.asBson(options.getProjection())).sort(this.asBson(options.getSort())));
    }

    @Override
    public T findOneAndReplace(Object filter, T replacement) {
        return this.findOneAndReplace(filter, replacement, new FindOneAndReplaceOptions());
    }

    @Override
    public T findOneAndReplace(Object filter, T replacement, FindOneAndReplaceOptions options) {
        return (T)this.executor.execute((WriteOperation)new FindAndReplaceOperation(this.namespace, this.getCodec(), this.asBson(replacement)).filter(this.asBson(filter)).projection(this.asBson(options.getProjection())).sort(this.asBson(options.getSort())).returnOriginal(options.getReturnOriginal()).upsert(options.isUpsert()));
    }

    @Override
    public T findOneAndUpdate(Object filter, Object update) {
        return this.findOneAndUpdate(filter, update, new FindOneAndUpdateOptions());
    }

    @Override
    public T findOneAndUpdate(Object filter, Object update, FindOneAndUpdateOptions options) {
        return (T)this.executor.execute((WriteOperation)new FindAndUpdateOperation(this.namespace, this.getCodec(), this.asBson(update)).filter(this.asBson(filter)).projection(this.asBson(options.getProjection())).sort(this.asBson(options.getSort())).returnOriginal(options.getReturnOriginal()).upsert(options.isUpsert()));
    }

    @Override
    public void dropCollection() {
        this.executor.execute((WriteOperation)new DropCollectionOperation(this.namespace));
    }

    @Override
    public void createIndex(Object key) {
        this.createIndex(key, new CreateIndexOptions());
    }

    @Override
    public void createIndex(Object key, CreateIndexOptions createIndexOptions) {
        this.executor.execute((WriteOperation)new CreateIndexOperation(this.getNamespace(), this.asBson(key)).name(createIndexOptions.getName()).background(createIndexOptions.isBackground()).unique(createIndexOptions.isUnique()).sparse(createIndexOptions.isSparse()).expireAfterSeconds(createIndexOptions.getExpireAfterSeconds()).version(createIndexOptions.getVersion()).weights(this.asBson(createIndexOptions.getWeights())).defaultLanguage(createIndexOptions.getDefaultLanguage()).languageOverride(createIndexOptions.getLanguageOverride()).textIndexVersion(createIndexOptions.getTextIndexVersion()).twoDSphereIndexVersion(createIndexOptions.getTwoDSphereIndexVersion()).bits(createIndexOptions.getBits()).min(createIndexOptions.getMin()).max(createIndexOptions.getMax()).bucketSize(createIndexOptions.getBucketSize()));
    }

    @Override
    public ListIndexesIterable<Document> listIndexes() {
        return this.listIndexes(Document.class);
    }

    @Override
    public <C> ListIndexesIterable<C> listIndexes(Class<C> clazz) {
        return new ListIndexesIterableImpl<C>(this.getNamespace(), clazz, this.codecRegistry, ReadPreference.primary(), this.executor);
    }

    @Override
    public void dropIndex(String indexName) {
        this.executor.execute((WriteOperation)new DropIndexOperation(this.namespace, indexName));
    }

    @Override
    public void dropIndexes() {
        this.dropIndex("*");
    }

    @Override
    public void renameCollection(MongoNamespace newCollectionNamespace) {
        this.renameCollection(newCollectionNamespace, new RenameCollectionOptions());
    }

    @Override
    public void renameCollection(MongoNamespace newCollectionNamespace, RenameCollectionOptions renameCollectionOptions) {
        this.executor.execute((WriteOperation)new RenameCollectionOperation(this.getNamespace(), newCollectionNamespace).dropTarget(renameCollectionOptions.isDropTarget()));
    }

    private DeleteResult delete(Object filter, boolean multi) {
        BulkWriteResult result = this.executeSingleWriteRequest((WriteRequest)new DeleteRequest(this.asBson(filter)).multi(multi));
        if (result.wasAcknowledged()) {
            return DeleteResult.acknowledged((long)result.getDeletedCount());
        }
        return DeleteResult.unacknowledged();
    }

    private UpdateResult update(Object filter, Object update, UpdateOptions updateOptions, boolean multi) {
        return this.toUpdateResult(this.executeSingleWriteRequest((WriteRequest)new UpdateRequest(this.asBson(filter), this.asBson(update), WriteRequest.Type.UPDATE).upsert(updateOptions.isUpsert()).multi(multi)));
    }

    private BulkWriteResult executeSingleWriteRequest(WriteRequest request) {
        try {
            return (BulkWriteResult)this.executor.execute((WriteOperation)new MixedBulkWriteOperation(this.namespace, Arrays.asList(request), true, this.writeConcern));
        }
        catch (MongoBulkWriteException e) {
            if (e.getWriteErrors().isEmpty()) {
                throw new MongoWriteConcernException(e.getWriteConcernError(), e.getServerAddress());
            }
            throw new MongoWriteException(new WriteError((WriteError)e.getWriteErrors().get(0)), e.getServerAddress());
        }
    }

    private UpdateResult toUpdateResult(BulkWriteResult result) {
        if (result.wasAcknowledged()) {
            Long modifiedCount = result.isModifiedCountAvailable() ? Long.valueOf(result.getModifiedCount()) : null;
            BsonValue upsertedId = result.getUpserts().isEmpty() ? null : ((BulkWriteUpsert)result.getUpserts().get(0)).getId();
            return UpdateResult.acknowledged((long)result.getMatchedCount(), (Long)modifiedCount, (BsonValue)upsertedId);
        }
        return UpdateResult.unacknowledged();
    }

    private Codec<T> getCodec() {
        return this.getCodec(this.clazz);
    }

    private <C> Codec<C> getCodec(Class<C> clazz) {
        return this.codecRegistry.get(clazz);
    }

    private BsonDocument asBson(Object document) {
        return BsonDocumentWrapper.asBsonDocument((Object)document, (CodecRegistry)this.codecRegistry);
    }
}

